Ext.onReady(function() {
    if (Ext.Date) {
        Ext.Date.monthNames = ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            Gen: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            Mag: 4,
            Giu: 5,
            Lug: 6,
            Ago: 7,
            Set: 8,
            Ott: 9,
            Nov: 10,
            Dic: 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Domenica", "Lunedi", "Martedi", "Mercoledi", "Giovedi", "Venerdi", "Sabato"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }

    if (Ext.util && Ext.util.Format) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u20ac', // Euro
            dateFormat: 'd/m/Y',
            timeFormat: 'H:i'
        });
    }
});

Ext.define("Ext.locale.it.form.field.Date", {
    override: "Ext.form.field.Date",

    format: "d/m/Y", 
    ariaFormat: 'M j Y',
    altFormats: "d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d",
    disabledDaysText: "Disabilitato", 
    ariaDisabledDaysText: "Questo giorno \u00E8 disabilitato",
    disabledDatesText: "Disabilitato", 
    ariaDisabledDatesText: "Questa data non pu\u00F2 essere selezionata",
    minText: "La data deve essere maggiore o uguale a {0}",
    ariaMinText: "La data deve essere maggiore o uguale a {0}",
    maxText: "La data deve essere minore o uguale a {0}",
    ariaMaxText: "La data deve essere minore o uguale a {0}",
    invalidText: "{0} non \u00E8 una data valida, deve essere nel formato {1}",
    formatText: "Il formato richiesto \u00E8 DD/MM/YYYY"
});

Ext.define("Ext.locale.it.form.field.Time", {
    override: "Ext.form.field.Time",

    minText: "L'ora deve essere maggiore o uguale a {0}",
    maxText: "L'ora deve essere minore o uguale a {0}",
    invalidText: "{0} non \u00E8 un Orario valido", 
    format: "H:i",
    formatText: "Il formato richiesto \u00E8 HH:MM" 
});

Ext.define("Ext.locale.it.picker.Date", {
    override: 'Ext.picker.Date',

    todayText: 'Oggi',
    ariaTitle: 'Scegli Data: {0}',
    ariaTitleDateFormat: 'F d',
    todayTip: '{0} (Barra spaziatrice)',
    minText: 'Data precedente alla data minima',
    ariaMinText: 'La data \u00E8 minore di quella minima consentita',
    maxText: 'Data successiva alla data massima',
    ariaMaxText: 'La data \u00E8 maggiore di quella massima consentita',
    disabledDaysText: 'Disabilitato',
    ariaDisabledDaysText: 'Questo giorno \u00E8 disabilitato',
    disabledDatesText: 'Disabilitato',
    ariaDisabledDatesText: 'Questa data \u00E8 disabilitata',
    nextText: 'Mese successivo (CTRL+Destra)', 
    prevText: 'Mese precedente (CTRL+Sinistra)', 
    monthYearText: 'Scegli un Mese (CTRL+Sopra/Sotto per cambiare anno)', 
    monthYearFormat: 'F Y', 
    startDay: 0,
    longDayFormat: 'd F Y'
});

Ext.define("Ext.locale.it.picker.Month", {
    override: "Ext.picker.Month",
    
    okText: 'OK',
    cancelText: 'Annulla'
});
/*
Ext.define("Ext.locale.it.picker.Time", {
    override: "Ext.picker.Time",
    
    format: "H:i"
});*/
