// Insert newest revisions on top
const UI_REVISIONS = [
	{
		revision: "N/A",
		revDate : "2022-02-18",
		jira    : "GAN-1302",
		context : "Report of bug in attempting to grant privileges.",
		solution: "Fixed by better error handling.",
		risk	: "LOW"
	},
	{
		revision: "281921",
		revDate : "2022-02-18",
		jira    : "GAN-1302",
		context : "Modal does not layout properly on Mike’s screen since he has altered his desktop font size.",
		solution: "Increasing modal height and width so it will layout properly in Mike’s desktop. Note that any layout will break if a user increases their overall desktop font even greater than what Mike has set.",
		risk	: "LOW"
	},
	{
		revision: "280749",
		revDate : "2022-02-03",
		jira    : "GAN-1282",
		context : "Table Records grid with lvarchar shows erroneous error message about max length.",
		solution: "If column is lvarchar type, I removed the maxlength limitations.",
		risk	: "LOW"
	},
	{
		revision: "280697",
		revDate : "2022-02-03",
		jira    : "GAN-1281",
		context : "Report of error in finding/selecting next statement if terminating semi-colon is on a line all lby itself.",
		solution: "Modified regex that looks for and matches next statement.",
		risk	: "LOW"
	},
	{
		revision: "279697",
		revDate : "2022-01-21",
		jira    : "GAN-1270",
		context : "Report that SqlExplorer does not handle database names well if the user fails to type it in the case to exactly match how a database was created.",
		solution: "Make database name comparison case agnostic.",
		risk	: "LOW"
	},
	{
		revision: "279694",
		revDate : "2022-01-21",
		jira    : "GAN-1258",
		context : "Request by Mike to fix bug that occurs when rename table is performed.",
		solution: "Fixed bug by changing table name in currentServer.nodeId.name",
		risk	: "LOW"
	},
	{
		revision: "279469",
		revDate : "2022-01-19",
		jira    : "GAN-1257",
		context : "Mike reported that Table Records grid fails to keep column resize widths after a record is added.",
		solution: "Modified the onDirectstoreMetaChange of the sqlTableRecordsStore so that the metadata is only used to create the grid if the number or names of columns has changed.",
		risk	: "LOW"
	},
	{
		revision: "279457",
		revDate : "2022-01-19",
		jira    : "GAN-1256",
		context : "Cloning a table causes column names to be wrapped in double quotes.",
		solution: "Removed double quotes from column names.",
		risk	: "LOW"
	},
	{
		revision: "279440",
		revDate : "2022-01-19",
		jira    : "GAN-1265",
		context : "Because Mike uses a larger font on his machine, some of the components may experience overflow.",
		solution: "Increased Binary Editor window width from 665px to 800px. This will create extra white space for the majority of users who leave font settings at default.",
		risk	: "LOW"
	},
	{
		revision: "278835",
		revDate : "2022-01-13",
		jira    : "GAN-1266",
		context : "Server, Database, and Username information on the top line is not aligned properly.",
		solution: "Modified label css padding.",
		risk	: "LOW"
	},
	{
		revision: "278833",
		revDate : "2022-01-13",
		jira    : "GAN-1264",
		context : "Request to remove semi-colon requirement on SQL Queries tab statements.",
		solution: "Modified REGEX to make semi-colon optional as part of statement.",
		risk	: "LOW"
	},
	{
		revision: "278829",
		revDate : "2022-01-13",
		jira    : "GAN-1260",
		context : "Request to layout datetime picker so time numbers are visible.",
		solution: "Increased size of hour, minutes, seconds number fields, and widened overall picker window.",
		risk	: "LOW"
	},
	{
		revision: "277069",
		revDate : "2021-10-26",
		jira    : "GAN-1178",
		context : "Report of bug in SQL Scripts run options due to STORAGE_ATTRIBUTES containing semi-colons.",
		solution: "Modified parser to take into account the scenario stated in context.",
		risk	: "MEDIUM"
	},
	{
		revision: "277055",
		revDate : "2021-10-26",
		jira    : "GAN-1154",
		context : "Request by Mike Bowers to add missing storage attribute options and fix some problems with them in a create table command.",
		solution: "Implemented all points in the request.",
		risk	: "LOW"
	},
	{
		revision: "274218",
		revDate : "2021-10-26",
		jira    : "GAN-1154",
		context : "Request to move binary editor to common source.",
		solution: "Modify SqlExplorer to use binary editor from new source location.",
		risk	: "LOW"
	},
	{
		revision: "274016",
		revDate : "2021-10-22",
		jira    : "GAN-1145",
		context : "Request to add export capability to SQL Scripts tab.",
		solution: "Added export button. We already had import.",
		risk	: "LOW"
	},
	{
		revision: "273988",
		revDate : "2021-10-22",
		jira    : "GAN-1150",
		context : "While testing, discovered that the backend returns a default width of 65500 for LVB and LVC data types.",
		solution: "Override the default width and clear.",
		risk	: "LOW"
	},
	{
		revision: "273050",
		revDate : "2021-10-12",
		jira    : "GAN-1116",
		context : "Request by Mike to change how faircom database access is handled.",
		solution: "Implemented Mike's detailed criteria on how to handle faircom db access.",
		risk	: "LOW"
	},
	{
		revision: "272666",
		revDate : "2021-10-05",
		jira    : "GAN-1128",
		context : "SQL Statements with embedded comments causes infinite loop.",
		solution: "Fixed SQL Scripts tab selection and execution in UI so infinite loop is not created.",
		risk	: "HIGH"
	},
	{
		revision: "272662",
		revDate : "2021-10-05",
		jira    : "GAN-1125",
		context : "Request by Mike to make 3rd party libs embedded.",
		solution: "Added 3rd party libs to resources directory in UI project.",
		risk	: "LOW"
	},
	{
		revision: "272206",
		revDate : "2021-09-28",
		jira    : "GAN-1101",
		context : "Report by Walter that reset doesn't set port to correct number.",
		solution: "Modified reset function to reset to original values set upon display of login panel.",
		risk	: "LOW"
	},
	{
		revision: "272205",
		revDate : "2021-09-28",
		jira    : "GAN-1100",
		context : "Report that the warning message on SQL Queries tab changes the entered sql statement to something invalid.",
		solution: "Fixed so that the modifySqlQueriesStatement is not called if there is an error/warning statement to display.",
		risk	: "MEDIUM"
	},
	{
		revision: "271994",
		revDate : "2021-09-23",
		jira    : "GAN-1109",
		context : "Report that the 'id' column sometimes fails to appear.",
		solution: "Fixed required changes to both our code and overriding a Sencha method that was erroring.",
		risk	: "LOW"
	},
	{
		revision: "271989",
		revDate : "2021-09-23",
		jira    : "GAN-1116",
		context : "Request to disable editing on SYSTABLE node type selection.",
		solution: "Disabled rowediting plugin and add/remove buttons when a systable is selected.",
		risk	: "LOW"
	},
	{
		revision: "271901",
		revDate : "2021-09-22",
		jira    : "GAN-1107",
		context : "Mike requested we hide rowid in certain places within the UI.",
		solution: "Implemented hide of rowid. Also, fixed default widths based on data type in Create Table.",
		risk	: "LOW"
	},
	{
		revision: "271896",
		revDate : "2021-09-22",
		jira    : "GAN-1114",
		context : "Mike testing discovered Login modal has text fields not wide enough.",
		solution: "Increased withs.",
		risk	: "LOW"
	},
	{
		revision: "271892",
		revDate : "2021-09-22",
		jira    : "GAN-1113",
		context : "Mike testing discovered Error Viewer has text fields not wide enough.",
		solution: "Increased with of textfields and lookup button.",
		risk	: "LOW"
	},
	{
		revision: "271819",
		revDate : "2021-09-17",
		jira    : "GAN-1108",
		context : "Mike testing discovered single character column names are not accepted.",
		solution: "Fixed regex expression used to validate names.",
		risk	: "LOW"
	},
	{
		revision: "271634",
		revDate : "2021-09-17",
		jira    : "GAN-1098",
		context : "Request to add data ranges for data type dropdown.",
		solution: "Added min/max ranges in width for each data type.",
		risk	: "LOW"
	},
	{
		revision: "271591",
		revDate : "2021-09-16",
		jira    : "GAN-1095",
		context : "Request by Mike to modify how we handle < Large Data >.",
		solution: "The requirements, after discussion with Mike, are now that this should behave as follows. If the results grid does not contain the rowid, alert the user that it is a required column in order for us to show < Large Data > contents, instructing them on how to form the select statement with the rowid included.",
		risk	: "LOW"
	},
	{
		revision: "271156",
		revDate : "2021-09-09",
		jira    : "CTREEACE-6965",
		context : "Request to improve workflow on server disconnect.",
		solution: "Modified workflow so user doesn't have to press disconnect if server is interrupted.",
		risk	: "LOW"
	},
	{
		revision: "271012",
		revDate : "2021-09-08",
		jira    : "GAN-1067",
		context : "Request by Mike to add ability to editors to null out values.",
		solution: "Added clear button and ability to set values to null.",
		risk	: "LOW"
	},
	{
		revision: "270963",
		revDate : "2021-09-02",
		jira    : "GAN-1074",
		context : "Request to fix the fact nothing shows when Columns selected.",
		solution: "Removed since there is nothing to show when Columns selected.",
		risk	: "LOW"
	},
	{
		revision: "270752",
		revDate : "2021-09-02",
		jira    : "GAN-1061",
		context : "Request to set cursor inside editor.",
		solution: "Placed cursor inside editor.",
		risk	: "LOW"
	},
	{
		revision: "270703",
		revDate : "2021-09-01",
		jira    : "GAN-1079",
		context : "Request to disallow pasting text larger than column permits.",
		solution: "Added column width enforcement.",
		risk	: "LOW"
	},
	{
		revision: "270683",
		revDate : "2021-09-01",
		jira    : "GAN-1087",
		context : "Request to improve workflow",
		solution: "Implemented improvements to eliminate errors on binary columns, only allow import of file sizes that fit in column.",
		risk	: "LOW"
	},
	{
		revision: "270617",
		revDate : "2021-08-31",
		jira    : "GAN-1084",
		context : "Request to remove paging clause if \"top\" is 0.",
		solution: "Removed paging clause if top is 0.",
		risk	: "LOW"
	},
	{
		revision: "270520",
		revDate : "2021-08-31",
		jira    : "GAN-1062",
		context : "Request to add import/export buttons to Large String editor.",
		solution: "Added import/export/reset buttons. Also, implemented logic to support various string data types along with different size constraints.",
		risk	: "MEDIUM"
	},
	{
		revision: "270334",
		revDate : "2021-08-30",
		jira    : "GAN-1068",
		context : "Request to change the way the BIT data type column is handled.",
		solution: "Changed editor to checkcolumn.",
		risk	: "MEDIUM"
	},
	{
		revision: "270148",
		revDate : "2021-08-27",
		jira    : "GAN-1070",
		context : "Testing by Mike",
		solution: "Fixed by keeping the editor definition that is sent from the server. Note that this should be changed. The backend should not be dictating the UI appearance and functionality. But, since that is how things are currently done, I'm modified UI to respect column and editor definition dictated by backend. We need to change this. Note: the backend fixes doubles at 6 precision.",
		risk	: "MEDIUM"
	},
	{
		revision: "269999",
		revDate : "2021-08-27",
		jira    : "GAN-1071",
		context : "Testing by Mike",
		solution: "Before Store Sync, Remove AutoIncr Fields From ModifiedRecords",
		risk	: "MEDIUM"
	},
	{
		revision: "269999",
		revDate : "2021-08-27",
		jira    : "GAN-1072",
		context : "Testing by Mike and Adam",
		solution: "Create Table is showing wrong error message if table name left blank.",
		risk	: "LOW"
	},
	{
		revision: "269998",
		revDate : "2021-08-27",
		jira    : "GAN-1064",
		context : "Request to improve Clone Table Layout.",
		solution: "Made requested improvements",
		risk	: "LOW"
	},
	{
		revision: "269764",
		revDate : "2021-08-24",
		jira    : "GAN-1066",
		context : "Fix grid column sizes per formula laid out in Jira",
		solution: "Dynamically set columns to greater of header text width or 20 (if text) 10 (if numeric)",
		risk	: "LOW"
	},
	{
		revision: "269751",
		revDate : "2021-08-04",
		jira    : "GAN-1052",
		context : "Request by Kevin to persist column settings so that paging doesn't resize columns.",
		solution: "Keep column sizes, show/hide status, and order while on same table.",
		risk	: "LOW"
	},
	{
		revision: "269293",
		revDate : "2021-08-16",
		jira    : "GAN-1038",
		context : "Need to improve workflow of binary editor with Table Records grid editing.",
		solution: "Delay updating any Blob data until user confirms update to the grid record.",
		risk	: "MEDIUM"
	},
	{
		revision: "269163",
		revDate : "2021-08-12",
		jira    : "GAN-1038",
		context : "Requested improvements to how large strings are edited.",
		solution: "Added \"large string editor\" to Table Records tab.",
		risk	: "LOW"
	},
	{
		revision: "268805",
		revDate : "2021-08-04",
		jira    : "GAN-1049",
		context : "Request to add more features to Binary Image viewer.",
		solution: "Refactored binary viewer to allow for editing of a table row/column's binary data by importing a new binary file and saving it.",
		risk	: "MEDIUM"
	},
	{
		revision: "268007",
		revDate : "2021-07-19",
		jira    : "GAN-1045",
		context : "Modify layout so things fit better.",
		solution: "Modified layout of SQL Queries tab and removed Execution Plan tab because it's included in the former.",
		risk	: "LOW"
	},
	{
		revision: "267743",
		revDate : "2021-07-16",
		jira    : "GAN-1024",
		context : "Retheme to a more modern look.",
		solution: "Swapped to classic Crisp with some customizations.",
		risk	: "LOW"
	},
	{
		revision: "267531",
		revDate : "2021-07-14",
		jira    : "GAN-1037",
		context : "Report of not being able to update the record with a rowid of 0.",
		solution: "Fixed the record sanitization routine which was removing any property whose value is empty. Unfortunately, that was also clearing any property with a 0 value. Fixed.",
		risk	: "LOW"
	},
	{
		revision: "267484",
		revDate : "2021-07-14",
		jira    : "GAN-1032",
		context : "Report of Table Records tab cannot update records.",
		solution: "Fixed reported issue along with other issues.",
		risk	: "MEDIUM"
	},
	{
		revision: "265399",
		revDate : "2021-06-14",
		jira    : "GAN-413",
		context : "Multiple bugs reported with only one remaining - refresh on database node doesn't work.",
		solution: "Fixed refresh on Database node.",
		risk	: "LOW"
	},
	{
		revision: "265038",
		revDate : "2021-06-10",
		jira    : "GAN-739",
		context : "Report that user is able to type in a database that is invalid when selecting a database to connect to.",
		solution: "Add code to force user to select from valid list.",
		risk	: "LOW"
	},
	{
		revision: "265036",
		revDate : "2021-06-10",
		jira    : "GAN-536",
		context : "Request to allow starting comment above SELECT statement.",
		solution: "Permit comment starting with \"--\"",
		risk	: "LOW"
	},
	{
		revision: "265013",
		revDate : "2021-06-08",
		jira    : "GAN-853",
		context : "Request to add TZ selection on SQL Queries tab for displaying date/time/timestamp columns.",
		solution: "Added Moment.js library and modified method that detects metadata changes to format date/time/timestamp columns per user-selected TZ.",
		risk	: "LOW"
	},
	{
		revision: "264999",
		revDate : "2021-06-07",
		jira    : "GAN-340",
		context : "Request to change how ECHO and PROCEDURE statements are handled/displayed to results panel.",
		solution: "Modified output per request. Since Procedures and Triggers are not supported, a message to this effect is printed out.",
		risk	: "LOW"
	},
	{
		revision: "264306",
		revDate : "2021-06-02",
		jira    : "GAN-980",
		context : "Problems with Table Records grid when 'id' column added to table definition",
		solution: "Fixed to dynamically change 'id' column to '_id' on UI and back on persistence.",
		risk	: "MEDIUM"
	},
	{
		revision: "264306",
		revDate : "2021-05-22",
		jira    : "CTREEACE-8173",
		context : "Design decision to rename id to rowid",
		solution: "Changed id to rowid on table records crud operations.",
		risk	: "MEDIUM"
	},
	{
		revision: "264132",
		revDate : "2021-05-20",
		jira    : "GAN-889",
		context : "Request to fix problem with Index names by prepending the table name.",
		solution: "Fixed Index names. Example: custmast.sys_001",
		risk	: "LOW"
	},
	{
		revision: "264054",
		revDate : "2021-05-18",
		jira    : "GAN-487",
		context : "Request to add X to close session. Adam reported that, in testing, the session doesn't actually register as disconnected with the server.",
		solution: "Modified disconnect method to wait for response from backend before closing SqlExplorer UI session.",
		risk	: "LOW"
	},
	{
		revision: "264053",
		revDate : "2021-05-18",
		jira    : "GAN-868",
		context : "Request to enhance script capabilities to process IF blocks",
		solution: "Refactoring parser and execution of SQL stmts.",
		risk	: "HIGH"
	},
	{
		revision: "262603",
		revDate : "2021-04-22",
		jira    : "GAN-894",
		context : "Request by Mike Bowers to reorder columns on Details tab.",
		solution: "Added logic to resort metadata columns before creating grid.",
		risk	: "LOW"
	},
	{
		revision: "262563",
		revDate : "2021-04-22",
		jira    : "GAN-892",
		context : "Request by Mike Bowers to implement paging where possible on the SqlExplorer.",
		solution: "See comment in Jira as to implementation details for SQL Queries tab and Table Records tab.",
		risk	: "LOW"
	},
	{
		revision: "262558",
		revDate : "2021-04-21",
		jira    : "GAN-898",
		context : "Request by Mike to add pagination capability to SQL Queries tab.",
		solution: "Added TOP and SKIP options, which modifies the SQL statement.",
		risk	: "LOW"
	},
	{
		revision: "262457",
		revDate : "2021-04-21",
		jira    : "GAN-857",
		context : "Mike requesting addition of rowid to various grids",
		solution: "Finished adding rowid logic",
		risk	: "LOW"
	},
	{
		revision: "252077",
		revDate : "2021-04-15",
		jira    : "GAN-859",
		context : "Request to add username to titlebar of app",
		solution: "Added username after server and database",
		risk	: "LOW"
	},
	{
		revision: "261997",
		revDate : "2021-04-15",
		jira    : "GAN-856",
		context : "Ron testing the \"Create View\" modal discovered the WHERE dropdown is erroneously populated.",
		solution: "Fixed dropdown to contain proper list of table columns.",
		risk	: "LOW"
	},
	{
		revision: "261940",
		revDate : "2021-04-14",
		jira    : "GAN-768",
		context : "Testing by Mike Bowers, requesting mutual exclusivity between ALL columns and specific columns",
		solution: "Implemented request and also refactored a lot of the code to be readable.",
		risk	: "MEDIUM"
	},
	{
		revision: "261829",
		revDate : "2021-04-14",
		jira    : "GAN-834",
		context : "Mike testing and found login screen does not close automatically.",
		solution: "Discovered that LastPass plugin doesn't play well with \"hidden\" fields, such as we have in this login form. Changed to use css opacity setting to hide/display the databaseCombo field.",
		risk	: "LOW"
	},
	{
		revision: "261649",
		revDate : "2021-04-12",
		jira    : "GAN-770",
		context : "Request to Not Display Table Name Error if Exiting",
		solution: "Modified Table Name Error Check to be Only Upon Create Button Click.",
		risk	: "LOW"
	},
	{
		revision: "261480",
		revDate : "2021-04-09",
		jira    : "GAN-771",
		context : "Request to add feature which uses Ctrl+ENTER to execute primary buttons.",
		solution: "Added logic so that Ctrl+ENTER runs Execute and Run All on SQL Queries and SQL Scripts tabs, respectively.",
		risk    : "LOW"
	},
	{
		revision: "259539",
		revDate : "2021-03-17",
		jira    : "GAN-764",
		context : "Results fail to show in SQL Queries tab if 'All' rows selected",
		solution: "Fixed so that if 'All' rows selected, it changes maxRows to 999999 when executing query.",
		risk    : "LOW"
	},
	{
		revision: "259143",
		revDate : "2021-03-12",
		jira    : "GAN-766",
		context : "Performing a Create New Database Fails to Navigate User into New Database",
		solution: "Modified workflow to include a checkbox where the user can choose to open new SqlExplorer session that auto-navigates user to newly created database.",
		risk    : "LOW"
	},
	{
		revision: "258988",
		revDate : "2021-03-11",
		jira    : "GAN-766",
		context : "Performing a Create New Database Fails to Navigate User into New Database",
		solution: "Modified workflow to include a checkbox where the user can choose to open new SqlExplorer session that auto-navigates user to newly created database.",
		risk    : "LOW"
	},
	{
		revision: "N/A",
		revDate : "2021-03-10",
		jira    : "GAN-765",
		context : "Request by Mike Bowers to make the Create Table in SqlExplorer more consistent with MqttExplorer by providing validation and constraints.",
		solution: "Modified table to dynamically constrain and validate record based on data type selection.",
		risk    : "LOW"
	},
	{
		revision: "257397",
		revDate : "2021-02-24",
		jira    : "GAN-750",
		context : "Request by Mauro to remove '0' from values in 'Max Rows' dropdown.",
		solution: "Removed 0 as 'Max Rows' dropdown value.",
		risk    : "LOW"
	},
	{
		revision: "257394",
		revDate : "2021-02-24",
		jira    : "GAN-763",
		context : "Request by Mike Bowers to change tab title from 'Items View' to 'Details'",
		solution: "Changed tab text",
		risk    : "LOW"
	},
	{
		revision: "256854",
		revDate : "2021-02-18",
		jira    : "GAN-743",
		context : "Need ability for QA to easily determine if the build they are testing contains the fix they are testing.",
		solution: "Added a UI Revisions modal, activated by Ctrl+Shift+Q",
		risk    : "LOW"
	},
	{
		revision: "255852",
		revDate : "2021-02-09",
		jira    : "GAN-690",
		context : "Testing revealed auto/manual buttons do not work as expected",
		solution: "Removed auto/manual in favor of the connection always setting autoCommit = \"on\". In addition, we are moving the Isolation Level to the login dialog",
		risk    : "LOW"
	},
	{
		revision: "255836",
		revDate : "2021-02-08",
		jira    : "GAN-449",
		context : "Enrico testing and discovered new tables now showing in list of tables",
		solution: "Fixed so that if a table is created or dropped, via the SQL Scripts tab, the left sidebar \"Tables\" node is refreshed so the given table is added/dropped from the tree.",
		risk    : "LOW"
	},
	{
		revision: "255513",
		revDate : "2020-02-05",
		jira    : "GAN-351",
		context : "Testing by Walter",
		solution: "Changed out logo, added refresh button to reset app.",
		risk    : "LOW"
	},
	{
		revision: "255499",
		revDate : "2020-02-05",
		jira    : "GAN-705",
		context : "Testing app by Alex",
		solution: "By fixing another error, which involved overriding method onFieldTab in Ext.grid.RowEditor, I believe this fixed the reported problem. After fixing core Sencha code, I no longer saw the given error.",
		risk    : "LOW"
	},
	{
		revision: "255484",
		revDate : "2020-02-04",
		jira    : "GAN-701",
		context : "Testing by Mike",
		solution: "Enable access to \"Table Records\" tab on views",
		risk    : "LOW"
	},
	{
		revision: "255481",
		revDate : "2020-02-04",
		jira    : "GAN-598",
		context : "Request by Mike B to default \"max rows\" to 1000",
		solution: "Ignore setting in local storage and force default to 1000",
		risk    : "LOW"
	},
	{
		revision: "255331",
		revDate : "2020-02-02",
		jira    : "GAN-634",
		context : "Walter testing the UI discovered a problem with case matching",
		solution: "Select record in database dropdown that matches the \"Default SQL Database\" entry, without respect to case.",
		risk    : "LOW"
	}
];