/*
 * Decompiled with CFR 0.152.
 */
package execPlanGraph;

final class QEPNodeTypes {
    protected static final int NT_UNKNOWN = 0;
    protected static final int NT_PROJECT = 1;
    protected static final int NT_RESTRICT = 2;
    protected static final int NT_JOIN = 3;
    protected static final int NT_TBL_SCAN = 4;
    protected static final int NT_REMT_SCAN = 5;
    protected static final int NT_IDX_SCAN = 6;
    protected static final int NT_SORT = 7;
    protected static final int NT_DIDX = 8;
    protected static final int NT_UNION = 9;
    protected static final int NT_INTERSECT = 10;
    protected static final int NT_MINUS = 11;
    protected static final int NT_LOGOP = 12;
    protected static final int NT_RELOP = 13;
    protected static final int NT_ARITHOP = 14;
    protected static final int NT_FNOP = 15;
    protected static final int NT_CONST = 16;
    protected static final int NT_PARAM = 17;
    protected static final int NT_PEXPR = 18;
    protected static final int NT_SFN = 19;
    protected static final int NT_DBTBL = 20;
    protected static final int NT_GRP_BY = 21;
    protected static final int NT_DIDX_PEXPRIDX = 22;
    protected static final int NT_IXOP = 23;
    protected static final int NT_DIDX_PEXPRS = 24;
    protected static final int NT_FLDREF = 25;
    protected static final int NT_DIDX_FLDIDS = 26;
    protected static final int NT_FLDID = 27;
    protected static final int NT_PF_FLDREF = 28;
    protected static final int NT_PF_OP = 29;
    protected static final int NT_PF_VALUE = 30;
    protected static final int NT_PF_SFN = 31;
    protected static final int NT_JN_TYPE = 32;
    protected static final int NT_JN_COND = 33;
    protected static final int NT_JN_OP = 34;
    protected static final int NT_JN_OPT = 35;
    protected static final int NT_EXPR = 37;
    protected static final int NT_SORT_BY = 38;
    protected static final int NT_TID_NODE = 39;
    protected static final int NT_TID_UNION = 40;
    protected static final int NT_TID_INTER = 41;
    protected static final int NT_DELETE = 42;
    protected static final int NT_INSERT = 43;
    protected static final int NT_SELECT = 44;
    protected static final int NT_UPDATE = 45;
    protected static final int NT_CRTBL = 46;
    protected static final int NT_FLD_NAME = 47;
    protected static final int NT_OP = 48;
    protected static final int NT_CONSTANT = 49;
    protected static final int NT_TREEID_PENUM = 50;
    protected static final int NT_DISTINCT = 51;
    protected static final int NT_SORT_EXPR = 52;
    protected static final int NT_SORT_DESC = 53;

    QEPNodeTypes() {
    }

    protected static int getNodeType(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        if (string.equalsIgnoreCase("project")) {
            return 1;
        }
        if (string.equalsIgnoreCase("restrict")) {
            return 2;
        }
        if (string.equalsIgnoreCase("join")) {
            return 3;
        }
        if (string.equalsIgnoreCase("table scan")) {
            return 4;
        }
        if (string.equalsIgnoreCase("remote table scan")) {
            return 5;
        }
        if (string.equalsIgnoreCase("index scan")) {
            return 6;
        }
        if (string.toLowerCase().startsWith("sort in temp")) {
            return 7;
        }
        if (string.equalsIgnoreCase("index scan of dyn. index")) {
            return 8;
        }
        if (string.equalsIgnoreCase("union")) {
            return 9;
        }
        if (string.equalsIgnoreCase("intersect")) {
            return 10;
        }
        if (string.equalsIgnoreCase("minus")) {
            return 11;
        }
        if (string.equalsIgnoreCase("logical operator")) {
            return 12;
        }
        if (string.equalsIgnoreCase("relational operator")) {
            return 13;
        }
        if (string.equalsIgnoreCase("arithmetic operator")) {
            return 14;
        }
        if (string.equalsIgnoreCase("functional operator")) {
            return 15;
        }
        if (string.equalsIgnoreCase("field referred")) {
            return 25;
        }
        if (string.equalsIgnoreCase("const")) {
            return 16;
        }
        if (string.equalsIgnoreCase("param")) {
            return 17;
        }
        if (string.equalsIgnoreCase("pexpr")) {
            return 18;
        }
        if (string.equalsIgnoreCase("sfn")) {
            return 19;
        }
        if (string.equalsIgnoreCase("dyn. idx on pexprs")) {
            return 22;
        }
        if (string.equalsIgnoreCase("pexprs")) {
            return 24;
        }
        if (string.equalsIgnoreCase("fldids")) {
            return 26;
        }
        if (string.equalsIgnoreCase("fldid")) {
            return 27;
        }
        if (string.equalsIgnoreCase("pf_fldref")) {
            return 28;
        }
        if (string.equalsIgnoreCase("pf_operator")) {
            return 29;
        }
        if (string.equalsIgnoreCase("pf_value")) {
            return 30;
        }
        if (string.equalsIgnoreCase("pf_sfn")) {
            return 31;
        }
        if (string.equalsIgnoreCase("join type")) {
            return 32;
        }
        if (string.equalsIgnoreCase("join condn")) {
            return 33;
        }
        if (string.equalsIgnoreCase("join operator")) {
            return 34;
        }
        if (string.equalsIgnoreCase("sort by")) {
            return 38;
        }
        if (string.equalsIgnoreCase("group by")) {
            return 21;
        }
        if (string.equalsIgnoreCase("distinct")) {
            return 51;
        }
        if (string.equalsIgnoreCase("desc")) {
            return 53;
        }
        return 0;
    }

    protected static String getNodeType(int n) {
        switch (n) {
            case 1: {
                return "Project";
            }
            case 2: {
                return "Restrict";
            }
            case 3: {
                return "Join";
            }
            case 7: {
                return "Sort";
            }
            case 4: {
                return "Table Scan";
            }
            case 5: {
                return "Remote Scan";
            }
            case 6: {
                return "Index Scan";
            }
            case 8: {
                return "DIDX";
            }
            case 9: {
                return "Union";
            }
            case 10: {
                return "Intersect";
            }
            case 11: {
                return "Minus";
            }
        }
        return "Unknown";
    }

    protected static char getMnemonic(int n) {
        switch (n) {
            case 1: {
                return 'P';
            }
            case 2: {
                return 'c';
            }
            case 3: {
                return 'J';
            }
            case 7: {
                return 'o';
            }
            case 4: {
                return 'T';
            }
            case 5: {
                return 'e';
            }
            case 6: {
                return 'x';
            }
            case 8: {
                return 'D';
            }
            case 9: {
                return 'n';
            }
            case 10: {
                return 'I';
            }
            case 11: {
                return 'M';
            }
        }
        return '\u0000';
    }
}

