/*
 * Decompiled with CFR 0.152.
 */
package execPlanGraph;

import ctree.sqlsp.DhSQLException;
import ctree.sqlsp.SQLCursor;
import execPlanGraph.QEPDIDXSupportList;
import execPlanGraph.QEPHelpers;
import execPlanGraph.QEPNodeTypes;
import execPlanGraph.QEPOpSupportList;
import execPlanGraph.QEPPFSupportList;
import execPlanGraph.QEPProjectSupportList;
import execPlanGraph.QEPSfnSupportList;
import execPlanGraph.QEPSortBySupportList;
import execPlanGraph.QEPSupportList;
import execPlanGraph.QEPTreeLbl;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class QEPTree {
    public String jsonText;
    protected int nodeType;
    protected int nodeID;
    protected int parentID;
    protected double cost;
    protected double card;
    protected int width;
    protected int lWidth;
    protected int rWidth;
    protected QEPSupportList lSuppList;
    protected QEPSupportList rSuppList;
    protected ArrayList<Integer> lSuppNodeIDs;
    protected ArrayList<Integer> rSuppNodeIDs;
    protected QEPTree lchild;
    protected QEPTree rchild;

    protected QEPTree(int n, int n2, int n3, double d, double d2) {
        this.nodeType = n;
        this.nodeID = n2;
        this.parentID = n3;
        this.cost = d;
        this.card = d2;
        this.width = 0;
        this.lWidth = 1;
        this.rWidth = 1;
        this.lSuppList = null;
        this.rSuppList = null;
        this.lSuppNodeIDs = new ArrayList();
        this.rSuppNodeIDs = new ArrayList();
        this.lchild = null;
        this.rchild = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QEPTree(QEPTreeLbl qEPTreeLbl, String string, String string2, Integer n) {
        block32: {
            QEPTree qEPTree = null;
            this.width = 0;
            this.lWidth = 1;
            this.rWidth = 1;
            this.lSuppList = null;
            this.rSuppList = null;
            this.lSuppNodeIDs = new ArrayList();
            this.rSuppNodeIDs = new ArrayList();
            this.lchild = null;
            this.rchild = null;
            try {
                Object object;
                Object object2;
                String string3 = "select node_type, node_id, parent_id, is_supportive, cost, cardinality, node_info, child_number from admin.qep_tbl where query_id = '2'";
                Class.forName("ctree.jdbc.ctreeDriver");
                String string4 = "jdbc:ctree:6597@localhost:ctreesql";
                Connection connection = DriverManager.getConnection(string4, "ADMIN", "ADMIN");
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                block25: while (resultSet.next()) {
                    int n2;
                    object2 = resultSet.getString(1);
                    this.nodeType = QEPNodeTypes.getNodeType((String)object2);
                    this.nodeID = resultSet.getInt(2);
                    this.parentID = resultSet.getInt(3);
                    String string5 = resultSet.getString(4);
                    boolean bl = string5 != null && string5.equals("Y");
                    this.cost = resultSet.getFloat(5);
                    this.card = resultSet.getFloat(6);
                    if (this.nodeType == 0) {
                        object = resultSet.getString(7);
                        if (object == null || !((String)object).equalsIgnoreCase("*")) continue;
                        this.nodeType = 16;
                    }
                    if (!bl) {
                        QEPTree qEPTree2 = new QEPTree(this.nodeType, this.nodeID, this.parentID, this.cost, this.card);
                        if (qEPTree != null) {
                            qEPTree.insert(qEPTree2);
                        } else {
                            qEPTree = qEPTree2;
                        }
                        switch (this.nodeType) {
                            case 4: 
                            case 5: 
                            case 6: {
                                object = resultSet.getString(7);
                                n2 = resultSet.getInt(8);
                                qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, (String)object), this.nodeID, n2);
                                break;
                            }
                        }
                        continue;
                    }
                    if (qEPTree == null) continue;
                    object = resultSet.getString(7);
                    if (object == null) {
                        object = "";
                    }
                    n2 = resultSet.getInt(8);
                    switch (this.nodeType) {
                        case 18: 
                        case 25: {
                            qEPTree.addSuppInfo(new QEPProjectSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                        case 38: {
                            qEPTree.addSuppInfo(new QEPSortBySupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                        case 34: {
                            qEPTree.addSuppInfo(new QEPOpSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                        case 15: 
                        case 19: {
                            qEPTree.addSuppInfo(new QEPSfnSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                        case 22: 
                        case 24: 
                        case 26: {
                            qEPTree.addSuppInfo(new QEPDIDXSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            qEPTree.addSuppInfo(new QEPPFSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                            continue block25;
                        }
                    }
                    qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, (String)object), this.parentID, n2);
                }
                resultSet.close();
                if (qEPTree == null) break block32;
                qEPTree.replacePexprs();
                qEPTree.formatSuppInfo();
                object2 = null;
                try {
                    object2 = new BufferedWriter(new FileWriter("tree.json"));
                    object = new JSONObject();
                    this.encodeTree((JSONObject)object, qEPTree);
                    StringWriter stringWriter = new StringWriter();
                    ((JSONObject)object).writeJSONString(stringWriter);
                    this.jsonText = stringWriter.toString();
                    ((Writer)object2).write(this.jsonText);
                }
                catch (IOException iOException) {
                    Logger.getLogger(QEPTree.class.getName()).log(Level.SEVERE, null, iOException);
                }
                finally {
                    try {
                        if (object2 != null) {
                            ((BufferedWriter)object2).close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(QEPTree.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                }
                qEPTreeLbl.setRoot(qEPTree);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                qEPTree = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(QEPTree.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
        }
    }

    public QEPTree(String string, String string2, Integer n) {
        block29: {
            QEPTree qEPTree = null;
            this.width = 0;
            this.lWidth = 1;
            this.rWidth = 1;
            this.lSuppList = null;
            this.rSuppList = null;
            this.lSuppNodeIDs = new ArrayList();
            this.rSuppNodeIDs = new ArrayList();
            this.lchild = null;
            this.rchild = null;
            try {
                SQLCursor sQLCursor = new SQLCursor("select node_type, node_id, parent_id, is_supportive, cost, cardinality, node_info, child_number from " + string + "." + string2 + " where query_id = " + n + " order by node_id");
                boolean bl = false;
                sQLCursor.open();
                sQLCursor.fetch();
                while (sQLCursor.found()) {
                    String string3;
                    if (sQLCursor.wasNULL(1)) {
                        this.nodeType = 0;
                    } else {
                        string3 = (String)sQLCursor.getValue(1, (short)17);
                        this.nodeType = QEPNodeTypes.getNodeType(string3);
                    }
                    this.nodeID = sQLCursor.wasNULL(2) ? 0 : (Integer)sQLCursor.getValue(2, (short)4);
                    this.parentID = sQLCursor.wasNULL(3) ? 0 : (Integer)sQLCursor.getValue(3, (short)4);
                    String string4 = sQLCursor.wasNULL(4) ? null : (String)sQLCursor.getValue(4, (short)17);
                    bl = string4 != null && string4.equals("Y");
                    this.cost = sQLCursor.wasNULL(5) ? 0.0 : (Double)sQLCursor.getValue(5, (short)6);
                    this.card = sQLCursor.wasNULL(6) ? 0.0 : (Double)sQLCursor.getValue(6, (short)6);
                    if (this.nodeType == 0) {
                        if (sQLCursor.wasNULL(7)) {
                            sQLCursor.fetch();
                            continue;
                        }
                        string3 = (String)sQLCursor.getValue(7, (short)17);
                        if (string3.equalsIgnoreCase("*")) {
                            this.nodeType = 16;
                        } else {
                            sQLCursor.fetch();
                            continue;
                        }
                    }
                    if (!bl) {
                        QEPTree qEPTree2 = new QEPTree(this.nodeType, this.nodeID, this.parentID, this.cost, this.card);
                        if (qEPTree != null) {
                            qEPTree.insert(qEPTree2);
                        } else {
                            qEPTree = qEPTree2;
                        }
                        switch (this.nodeType) {
                            case 4: 
                            case 5: 
                            case 6: {
                                this.card = sQLCursor.wasNULL(6) ? 0.0 : (Double)sQLCursor.getValue(6, (short)6);
                                int n2 = 0;
                                String string5 = "";
                                if (!sQLCursor.wasNULL(7)) {
                                    string5 = (String)sQLCursor.getValue(7, (short)17);
                                }
                                if (!sQLCursor.wasNULL(8)) {
                                    n2 = (Integer)sQLCursor.getValue(8, (short)4);
                                }
                                qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, string5), this.nodeID, n2);
                                break;
                            }
                        }
                    } else if (qEPTree != null) {
                        string3 = sQLCursor.wasNULL(7) ? "" : (String)sQLCursor.getValue(7, (short)17);
                        int n3 = sQLCursor.wasNULL(8) ? 0 : (Integer)sQLCursor.getValue(8, (short)4);
                        switch (this.nodeType) {
                            case 18: 
                            case 25: {
                                qEPTree.addSuppInfo(new QEPProjectSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            case 38: {
                                qEPTree.addSuppInfo(new QEPSortBySupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: 
                            case 34: {
                                qEPTree.addSuppInfo(new QEPOpSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            case 15: 
                            case 19: {
                                qEPTree.addSuppInfo(new QEPSfnSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            case 22: 
                            case 24: 
                            case 26: {
                                qEPTree.addSuppInfo(new QEPDIDXSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: {
                                qEPTree.addSuppInfo(new QEPPFSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                                break;
                            }
                            default: {
                                qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, string3), this.parentID, n3);
                            }
                        }
                    }
                    sQLCursor.fetch();
                }
                sQLCursor.close();
                if (qEPTree == null) break block29;
                qEPTree.replacePexprs();
                qEPTree.formatSuppInfo();
                JSONObject jSONObject = new JSONObject();
                this.encodeTree(jSONObject, qEPTree);
                StringWriter stringWriter = new StringWriter();
                try {
                    jSONObject.writeJSONString(stringWriter);
                }
                catch (IOException iOException) {
                    Logger.getLogger(QEPTree.class.getName()).log(Level.SEVERE, null, iOException);
                }
                this.jsonText = stringWriter.toString();
            }
            catch (DhSQLException dhSQLException) {
                System.out.println(dhSQLException);
                qEPTree = null;
            }
        }
    }

    protected Map encodeSuppList(QEPSupportList qEPSupportList) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (qEPSupportList != null) {
            linkedHashMap.put("nodeType", qEPSupportList.nodeType);
            linkedHashMap.put("nodeID", qEPSupportList.nodeID);
            linkedHashMap.put("suppInfo", qEPSupportList.suppInfo);
            JSONArray jSONArray = new JSONArray();
            if (qEPSupportList.formattedSuppInfo != null) {
                jSONArray.addAll(Arrays.asList(qEPSupportList.formattedSuppInfo));
            }
            linkedHashMap.put("formattedSuppInfo", jSONArray);
            JSONObject jSONObject = new JSONObject();
            if (qEPSupportList.next != null) {
                // empty if block
            }
            JSONObject jSONObject2 = new JSONObject();
            if (qEPSupportList.prev != null) {
                // empty if block
            }
        }
        return linkedHashMap;
    }

    protected void encodeNode(JSONObject jSONObject, QEPTree qEPTree) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("nodeType", qEPTree.nodeType);
        linkedHashMap.put("nodeID", qEPTree.nodeID);
        linkedHashMap.put("parentID", qEPTree.parentID);
        linkedHashMap.put("cost", qEPTree.cost);
        linkedHashMap.put("card", qEPTree.card);
        linkedHashMap.put("width", qEPTree.width);
        linkedHashMap.put("lWidth", qEPTree.lWidth);
        linkedHashMap.put("rWidth", qEPTree.rWidth);
        Map map = this.encodeSuppList(qEPTree.lSuppList);
        linkedHashMap.put("lSuppList", map);
        Map map2 = this.encodeSuppList(qEPTree.rSuppList);
        linkedHashMap.put("rSuppList", map2);
        linkedHashMap.put("lSuppNodeIDs", qEPTree.lSuppNodeIDs);
        linkedHashMap.put("rSuppNodeIDs", qEPTree.rSuppNodeIDs);
        linkedHashMap.put("lchild", null);
        linkedHashMap.put("rchild", null);
        jSONObject.putAll(linkedHashMap);
    }

    private void encodeTree(JSONObject jSONObject, QEPTree qEPTree) {
        int n = 300;
        if (qEPTree != null) {
            this.encodeNode(jSONObject, qEPTree);
            JSONObject jSONObject2 = new JSONObject();
            this.encodeTree(jSONObject2, qEPTree.lchild());
            jSONObject.put("lchild", jSONObject2);
            if (qEPTree.hasRChild()) {
                JSONObject jSONObject3 = new JSONObject();
                this.encodeTree(jSONObject3, qEPTree.rchild());
                jSONObject.put("rchild", jSONObject3);
            }
        }
    }

    protected void insert(QEPTree qEPTree) {
        boolean bl = this.hasRChild();
        if (this.nodeID == qEPTree.parentID) {
            if (bl && this.lchild != null) {
                this.rchild = qEPTree;
            } else {
                this.lchild = qEPTree;
            }
        } else if (bl && this.rchild != null) {
            this.rchild.insert(qEPTree);
        } else if (this.lchild != null) {
            this.lchild.insert(qEPTree);
        } else {
            this.lchild = qEPTree;
        }
        int n = this.width = bl ? Math.max(QEPTree.widthOf(this.lchild), QEPTree.widthOf(this.rchild)) + 1 : QEPTree.widthOf(this.lchild);
        if (bl) {
            this.lWidth = QEPTree.lWidthOf(this.lchild) + QEPTree.rWidthOf(this.lchild);
            this.rWidth = QEPTree.lWidthOf(this.rchild) + QEPTree.rWidthOf(this.rchild);
        } else {
            this.lWidth = QEPTree.lWidthOf(this.lchild);
            this.rWidth = QEPTree.rWidthOf(this.lchild);
        }
    }

    protected static int widthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.width;
    }

    protected static int lWidthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.lWidth;
    }

    protected static int rWidthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.rWidth;
    }

    protected boolean addSuppInfo(QEPSupportList qEPSupportList, int n, int n2) {
        Integer n3 = n;
        if (this.nodeID == n) {
            if (qEPSupportList.isLSuppInfo()) {
                if (this.lSuppList != null) {
                    this.lSuppList.add(qEPSupportList);
                } else {
                    this.lSuppList = qEPSupportList;
                }
                this.lSuppNodeIDs.add(qEPSupportList.getNodeID());
            } else {
                if (this.rSuppList != null) {
                    this.rSuppList.add(qEPSupportList);
                } else {
                    this.rSuppList = qEPSupportList;
                }
                this.rSuppNodeIDs.add(qEPSupportList.getNodeID());
            }
        } else if (this.lSuppNodeIDs.contains(n3)) {
            if (!this.lSuppList.addChild(qEPSupportList, n, n2)) {
                this.lSuppList.add(qEPSupportList);
            }
            this.lSuppNodeIDs.add(qEPSupportList.getNodeID());
        } else if (this.rSuppNodeIDs.contains(n3)) {
            if (!this.rSuppList.addChild(qEPSupportList, n, n2)) {
                this.rSuppList.add(qEPSupportList);
            }
            this.rSuppNodeIDs.add(qEPSupportList.getNodeID());
        } else {
            boolean bl = false;
            if (this.lchild != null) {
                bl = this.lchild.addSuppInfo(qEPSupportList, n, n2);
            }
            return !bl && this.rchild != null ? this.rchild.addSuppInfo(qEPSupportList, n, n2) : bl;
        }
        return true;
    }

    protected QEPTree lchild() {
        return this.lchild;
    }

    protected QEPTree rchild() {
        return this.rchild;
    }

    protected int getType() {
        return this.nodeType;
    }

    protected String getTypeStr() {
        switch (this.nodeType) {
            case 1: {
                return "PROJECT";
            }
            case 2: {
                return "RESTRICT";
            }
            case 3: {
                return "JOIN";
            }
            case 4: {
                return "TABLE SCAN";
            }
            case 5: {
                return "REMOTE TABLE SCAN";
            }
            case 6: {
                return "INDEX SCAN";
            }
            case 7: {
                return "SORT";
            }
            case 8: {
                return "DYNAMIC INDEX";
            }
            case 9: {
                return "UNION";
            }
            case 10: {
                return "INTERSECT";
            }
            case 11: {
                return "MINUS";
            }
        }
        return String.valueOf(this.nodeType);
    }

    protected boolean hasRChild() {
        switch (this.nodeType) {
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    protected int getNodeID() {
        return this.nodeID;
    }

    protected double getCost() {
        return this.cost;
    }

    protected double getCard() {
        return this.card;
    }

    protected int drawSuppInfo(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.lSuppList != null) {
            n3 = this.lSuppList.drawSuppInfo(graphics, n, n2, true);
        }
        if (this.rSuppList != null) {
            n4 = this.rSuppList.drawSuppInfo(graphics, n, n2, false);
        }
        return n3 > n4 ? n3 : n4;
    }

    protected String[] getToolTipText() {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.rSuppList != null ? this.rSuppList.getSuppInfo(this.rSuppList) : null;
            }
            case 3: {
                return this.lSuppList != null ? (this.rSuppList != null ? QEPHelpers.concat(this.lSuppList.getSuppInfo(this.lSuppList), this.rSuppList.getSuppInfo(this.rSuppList)) : this.lSuppList.getSuppInfo(this.lSuppList)) : (this.rSuppList != null ? this.rSuppList.getSuppInfo(this.rSuppList) : null);
            }
            case 7: {
                return this.lSuppList != null ? this.lSuppList.getSuppInfo(this.lSuppList) : null;
            }
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return null;
    }

    protected String[] replacePexprs() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (this.lchild != null) {
            stringArray = this.lchild.replacePexprs();
        }
        if (this.rchild != null) {
            stringArray = QEPHelpers.concat(stringArray, this.rchild.replacePexprs());
        }
        if (this.lSuppList != null) {
            stringArray2 = this.lSuppList.replacePexprs(this.lSuppList, stringArray);
        }
        if (this.rSuppList != null) {
            stringArray3 = this.rSuppList.replacePexprs(this.rSuppList, stringArray);
        }
        switch (this.nodeType) {
            case 1: 
            case 5: {
                return stringArray3 == null ? stringArray : stringArray3;
            }
            case 8: {
                return stringArray2 == null ? stringArray : stringArray2;
            }
        }
        return stringArray;
    }

    protected void formatSuppInfo() {
        if (this.lSuppList != null) {
            this.lSuppList.formattedSuppInfo = this.lSuppList.getSuppInfo(this.lSuppList);
        }
        if (this.rSuppList != null) {
            this.rSuppList.formattedSuppInfo = this.rSuppList.getSuppInfo(this.rSuppList);
        }
        if (this.lchild != null) {
            this.lchild.formatSuppInfo();
        }
        if (this.rchild != null) {
            this.rchild.formatSuppInfo();
        }
    }

    protected void formatSuppInfo(Graphics2D graphics2D) {
        graphics2D.scale(1.0, 1.0);
        if (this.lSuppList != null) {
            this.lSuppList.formatSuppInfo(this.lSuppList, graphics2D);
        }
        if (this.rSuppList != null) {
            this.rSuppList.formatSuppInfo(this.rSuppList, graphics2D);
        }
        if (this.lchild != null) {
            this.lchild.formatSuppInfo(graphics2D);
        }
        if (this.rchild != null) {
            this.rchild.formatSuppInfo(graphics2D);
        }
    }
}

