/*
 * Decompiled with CFR 0.152.
 */
package ctree.sqlsp;

import ctree.sqlsp.DhSQLException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class SQLDA {
    private static final int TPE_MAX_FLDLEN_P1 = 901;
    private static final int TPE_MAX_FIELD = 500;
    private static final int DEFAULT_INIT_SIZE = 5;
    public static final short TPE_DT_ERR = -1;
    public static final short TPE_DT_CHAR = 1;
    public static final short TPE_DT_NUMERIC = 2;
    public static final short TPE_DT_SMALLINT = 3;
    public static final short TPE_DT_INTEGER = 4;
    public static final short TPE_DT_SMALLFLOAT = 5;
    public static final short TPE_DT_REAL = 5;
    public static final short TPE_DT_FLOAT = 6;
    public static final short TPE_DT_DATE = 7;
    public static final short TPE_DT_MONEY = 8;
    public static final short TPE_DT_TIME = 9;
    public static final short TPE_DT_TIMESTAMP = 10;
    public static final short TPE_DT_TINYINT = 11;
    public static final short TPE_DT_BINARY = 12;
    public static final short TPE_DT_BIT = 13;
    public static final short TPE_DT_LVC = 14;
    public static final short TPE_DT_LVB = 15;
    public static final short TPE_DT_BIGINT = 16;
    public static final short TPE_DT_NCHAR = 17;
    public static final short TPE_DT_NVARCHAR = 18;
    public static final short TPE_DT_NCHAR_CS = 19;
    public static final short TPE_DT_NVARCHAR_CS = 20;
    public static final short TPE_DT_VARCHAR = 21;
    public static final short TPE_DT_BLOB = 22;
    public static final short TPE_DT_CLOB = 23;
    public static final short TPE_DT_NLVC = 24;
    public static final short TPE_DT_NCLOB = 25;
    public static final short TPE_DT_VARBINARY = 26;
    public static final short TPE_DT_MAXTYPES = 26;
    private static final short INPUT_PARAM = 0;
    private static final short INPUT_OUTPUT_PARAM = 1;
    private short nVars;
    private Object[] params;
    private short[] ivarptrs;
    private short[] length;
    private int[] precision;
    private short[] scale;
    private short[] hosttype;
    private short[] param_types;
    private int nParams;
    private int nInParams;
    private int nOutParams;
    private int nInOutParams;
    int times;
    int incr;
    private short[] procArgTypes;
    private short[] procArghTypes;

    public SQLDA() {
        this(5);
        this.log("CTOR default of SQLDA");
    }

    public SQLDA(int n) {
        this.log("CTOR with 1 argument of SQLDA");
        this.params = new Object[n];
        this.ivarptrs = new short[n];
        this.length = new short[n];
        this.precision = new int[n];
        this.scale = new short[n];
        this.hosttype = new short[n];
        this.param_types = new short[n];
        this.nVars = 0;
        this.times = 2;
        this.incr = 0;
        for (int i = 0; i < n; ++i) {
            this.scale[i] = -4;
            this.length[i] = -4;
            this.precision[i] = -4;
            this.hosttype[i] = -1;
            this.params[i] = null;
            this.param_types[i] = 0;
            this.ivarptrs[i] = -1;
        }
        this.nParams = 0;
        this.nInParams = 0;
        this.nOutParams = 0;
        this.nInOutParams = 0;
    }

    public void setParam(int n, Object object) throws DhSQLException {
        this.log("SQLDA.setParam");
        if (n < 1) {
            throw new DhSQLException(-20145, "Invalid field reference");
        }
        --n;
        int n2 = this.params.length;
        this.log("capacity is " + n2);
        while (n >= n2) {
            this.resize();
            n2 = this.params.length;
        }
        if (object instanceof StringBuffer) {
            object = ((StringBuffer)object).toString();
        }
        this.params[n] = object;
        if (object == null) {
            this.hosttype[n] = 17;
            this.length[n] = 0;
        } else {
            short s = this.hosttype[n];
            if (this.nParams != 0 && n < this.nParams && (this.procArghTypes[n] == 14 || this.procArghTypes[n] == 24 || this.procArghTypes[n] == 15 || this.procArghTypes[n] == 22 || this.procArghTypes[n] == 23 || this.procArghTypes[n] == 25)) {
                this.ivarptrs[n] = -1;
                this.param_types[n] = this.procArgTypes[n];
                this.hosttype[n] = this.procArghTypes[n];
                this.length[n] = 0;
            } else {
                this.hosttype[n] = SQLDA.identify(object);
                this.ivarptrs[n] = 1;
            }
            if (this.param_types[n] == 1 && this.hosttype[n] != s) {
                throw new DhSQLException(-20008, "Inconsistent Types");
            }
        }
        if (++n > this.nVars) {
            this.nVars = (short)n;
        }
        this.log("f = " + n + " nVars = " + this.nVars + " val = " + object);
    }

    public void registerOutParam(int n, short s) throws DhSQLException {
        this.registerOutParam(n, s, (short)-4);
    }

    public void registerOutParam(int n, short s, short s2) throws DhSQLException {
        this.log("SQLDA.registerOutParam");
        int n2 = this.params.length;
        this.log("capacity is " + n2);
        if (this.procArgTypes[--n] == 0) {
            throw new DhSQLException(-20162, "IN parameter Can't be registered");
        }
        while (n >= n2) {
            this.resize();
            n2 = this.params.length;
        }
        if (n >= n2) {
            this.resize();
        }
        this.param_types[n] = 1;
        if (s < 0 || s > 26) {
            throw new DhSQLException(-20008, "Inconsistent Types");
        }
        if (s == 14 || s == 15 || s == 22 || s == 23 || s == 24 || s == 25) {
            throw new DhSQLException(-20024, "Not Yet Implemented Error");
        }
        if (s == 18) {
            s = (short)17;
        }
        if (this.hosttype[n] != -1) {
            if (this.hosttype[n] != s) {
                throw new DhSQLException(-20008, "Inconsistent Types");
            }
        } else {
            this.scale[n] = s2;
            this.hosttype[n] = s;
        }
        this.scale[n] = s2;
        if (++n > this.nVars) {
            this.nVars = (short)n;
        }
        this.log("pindex = " + n + " nVars = " + this.nVars);
    }

    public void resetParams() {
        this.log("SQLDA.resetParams");
        for (int i = 0; i < this.nVars; ++i) {
            this.scale[i] = -4;
            this.precision[i] = -4;
            this.params[i] = null;
            this.ivarptrs[i] = -1;
            this.hosttype[i] = -1;
            this.param_types[i] = 0;
        }
        this.nVars = 0;
    }

    public short getLength(int n) throws DhSQLException {
        this.log("SQLDA.getLength");
        this.log("Length " + this.length[--n]);
        return this.length[n];
    }

    public Object getValue(int n, short s) throws DhSQLException {
        this.log("SQLDA.getValue");
        return this.params[--n];
    }

    public short getnVars() throws DhSQLException {
        return this.nVars;
    }

    public boolean isNULL(int n) {
        this.log("SQLDA.isNULL");
        return this.params[--n] == null;
    }

    public void setNULL(int n) throws DhSQLException {
        this.log("SQLDA.setNULL");
        this.setParam(n, null);
    }

    private void resize() {
        int n;
        this.log("SQLDA.resize");
        int n2 = n = this.params.length;
        n = this.times * n2 + this.incr;
        this.log("resizing " + n2 + " to " + n);
        Object[] objectArray = this.params;
        this.params = new Object[n];
        System.arraycopy(objectArray, 0, this.params, 0, n2);
        short[] sArray = this.ivarptrs;
        this.ivarptrs = new short[n];
        System.arraycopy(sArray, 0, this.ivarptrs, 0, n2);
        short[] sArray2 = this.hosttype;
        this.hosttype = new short[n];
        System.arraycopy(sArray2, 0, this.hosttype, 0, n2);
        int[] nArray = this.precision;
        this.precision = new int[n];
        System.arraycopy(nArray, 0, this.precision, 0, n2);
        short[] sArray3 = this.scale;
        this.scale = new short[n];
        System.arraycopy(sArray3, 0, this.scale, 0, n2);
        short[] sArray4 = this.length;
        this.length = new short[n];
        System.arraycopy(sArray4, 0, this.length, 0, n2);
        short[] sArray5 = this.param_types;
        this.param_types = new short[n];
        System.arraycopy(sArray5, 0, this.param_types, 0, n2);
        for (int i = n2; i < n; ++i) {
            this.scale[i] = -4;
            this.length[i] = -4;
            this.precision[i] = -4;
            this.hosttype[i] = -1;
            this.params[i] = null;
            this.ivarptrs[i] = -1;
            this.param_types[i] = 0;
        }
    }

    static short identify(Object object) {
        if (object instanceof String) {
            return 17;
        }
        if (object instanceof StringBuffer) {
            return 17;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Boolean) {
            return 13;
        }
        if (object instanceof byte[]) {
            return 12;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof BigInteger) {
            return 16;
        }
        if (object instanceof Float) {
            return 5;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Date) {
            return 7;
        }
        if (object instanceof Time) {
            return 9;
        }
        if (object instanceof Timestamp) {
            return 10;
        }
        if (object instanceof Long) {
            return 16;
        }
        return -1;
    }

    public Object get_type_arrayptr() {
        this.log("SQLDA.get_type_arrayptr");
        return this.hosttype;
    }

    public Object get_ivarptrs_arrayptr() {
        this.log("SQLDA.get_ivarptrs_arrayptr");
        return this.ivarptrs;
    }

    public int get_int_value(short s) {
        this.log("SQLDA.get_int_value");
        return (Integer)this.params[s];
    }

    public float get_float_value(short s) {
        this.log("SQLDA.get_float_value");
        return ((Float)this.params[s]).floatValue();
    }

    public double get_double_value(short s) {
        this.log("SQLDA.get_double_value");
        return (Double)this.params[s];
    }

    public boolean get_boolean_value(short s) {
        this.log("SQLDA.get_boolean_value");
        return (Boolean)this.params[s];
    }

    public Object get_binary_value(short s) {
        this.log("SQLDA.get_binary_value");
        return this.params[s];
    }

    public Object get_string_value(short s) {
        this.log("SQLDA.get_string_value");
        return this.params[s];
    }

    public int get_string_length(Object object) {
        this.log("SQLDA.get_string_length");
        return ((String)object).length();
    }

    public Object get_date_value(short s) {
        this.log("SQLDA.get_date_value");
        return this.params[s];
    }

    public Object get_time_value(short s) {
        this.log("SQLDA.get_time_value");
        return this.params[s];
    }

    public Object get_ts_value(short s) {
        this.log("SQLDA.get_ts_value");
        return this.params[s];
    }

    public int get_num_scale(short s) {
        this.log("SQLDA.get_num_scale");
        return ((BigDecimal)this.params[s]).scale();
    }

    public Object get_numeric_value(short s) {
        this.log("SQLDA.get_numeric_value");
        return ((BigDecimal)this.params[s]).toString();
    }

    public Object get_bigint_value(short s) {
        this.log("SQLDA.get_bigint_value");
        return this.params[s].toString();
    }

    public void toC_wrapper(long l) {
        this.toC(l, this.ivarptrs, this.length, this.precision, this.scale, this.hosttype, this.param_types);
    }

    public void fromC_wrapper(long l) {
        this.fromC(l, this.ivarptrs, this.length, this.precision, this.scale, this.hosttype);
    }

    public native void toC(long var1, short[] var3, short[] var4, int[] var5, short[] var6, short[] var7, short[] var8);

    public native void fromC(long var1, short[] var3, short[] var4, int[] var5, short[] var6, short[] var7);

    public native void log(String var1);

    public native void err(String var1);

    public int getNoOfParams() {
        return this.nParams;
    }

    public int getNoOfInParams() {
        return this.nInParams;
    }

    public int getNoOfOutParams() {
        return this.nOutParams;
    }

    public int getNoOfInOutParams() {
        return this.nInOutParams;
    }

    public void setParamCounts(int n, int n2, int n3, int n4) {
        this.nParams = n;
        this.nInParams = n2;
        this.nOutParams = n3;
        this.nInOutParams = n4;
    }

    public void setParamTypes(int n, short[] sArray) throws DhSQLException {
        this.log("SQLDA.setParamTypes");
        this.procArgTypes = new short[n];
        this.procArghTypes = new short[n];
        for (int i = 0; i < n; ++i) {
            short s = sArray[i];
            short s2 = (short)(s & 0xFF);
            if ((s = (short)((s & 0xFFFFFF00) >> 8)) == -1) break;
            this.procArgTypes[i] = s == 1 ? (short)0 : 1;
            this.procArghTypes[i] = s2;
        }
    }
}

