/*
 * Decompiled with CFR 0.152.
 */
package execPlanGraph;

import execPlanGraph.QEPHelpers;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;

class QEPSupportList {
    protected int nodeType;
    protected int nodeID;
    protected String suppInfo;
    protected String[] formattedSuppInfo;
    protected QEPSupportList next;
    protected QEPSupportList prev;

    protected QEPSupportList(int n, int n2, String string) {
        this.nodeType = n;
        this.nodeID = n2;
        this.suppInfo = string;
        this.formattedSuppInfo = null;
        this.next = this;
        this.prev = this;
    }

    protected boolean add(QEPSupportList qEPSupportList) {
        return this.prev.addNode(qEPSupportList);
    }

    protected boolean addNode(QEPSupportList qEPSupportList) {
        qEPSupportList.prev = this;
        qEPSupportList.next = this.next;
        this.next.prev = qEPSupportList;
        this.next = qEPSupportList;
        return true;
    }

    protected boolean addChild(QEPSupportList qEPSupportList, int n, int n2) {
        return this.addChild(qEPSupportList, n, n2, this);
    }

    protected boolean addChild(QEPSupportList qEPSupportList, int n, int n2, QEPSupportList qEPSupportList2) {
        return this.nodeID != n && this.next != qEPSupportList2 ? this.next.addChild(qEPSupportList, n, n2, qEPSupportList2) : false;
    }

    protected int drawSuppInfo(Graphics graphics, int n, int n2, boolean bl) {
        if (graphics != null) {
            Font font = graphics.getFont();
            graphics.setFont(new Font(font.getName(), 0, font.getSize()));
            n = bl ? (n -= 50) : (n += 50);
            Point point = this.drawSuppNode(graphics, n, n2, bl);
            graphics.setFont(font);
            return (point.y - n2) / 50;
        }
        return 0;
    }

    protected Point drawSuppNode(Graphics graphics, int n, int n2, boolean bl) {
        if (this.formattedSuppInfo == null) {
            return new Point(n, n2);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        n2 -= n4;
        for (int i = 0; i < this.formattedSuppInfo.length; ++i) {
            n3 = fontMetrics.stringWidth(this.formattedSuppInfo[i]);
            n2 += n4;
            if (bl) {
                graphics.drawString(this.formattedSuppInfo[i], n - n3, n2);
                continue;
            }
            graphics.drawString(this.formattedSuppInfo[i], n, n2);
        }
        return new Point(n + n3, n2);
    }

    protected String[] replacePexprs(QEPSupportList qEPSupportList, String[] stringArray) {
        String[] stringArray2 = this.needsListHead() ? this.replaceNode(qEPSupportList, stringArray) : this.replaceNode(this, stringArray);
        return this.next != qEPSupportList ? QEPHelpers.concat(stringArray2, this.next.replacePexprs(qEPSupportList, stringArray)) : stringArray2;
    }

    protected String[] replaceNode(QEPSupportList qEPSupportList, String[] stringArray) {
        if (stringArray == null) {
            if (this.nodeType == 5) {
                return this.getPexprs(this.suppInfo);
            }
        } else if (this.suppInfo.toLowerCase().startsWith("pexpr")) {
            try {
                int n = Integer.parseInt(this.suppInfo.substring(5));
                if (n > 0 && n <= stringArray.length) {
                    this.suppInfo = stringArray[n - 1];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new String[]{this.suppInfo};
    }

    protected String[] getSuppInfo(QEPSupportList qEPSupportList) {
        return this.getSuppInfo(qEPSupportList, false);
    }

    protected String[] getSuppInfo(QEPSupportList qEPSupportList, boolean bl) {
        String[] stringArray = this.needsListHead() ? this.getSuppNode(qEPSupportList, bl) : this.getSuppNode(this, bl);
        return this.next != qEPSupportList ? QEPHelpers.concat(stringArray, this.next.getSuppInfo(qEPSupportList, bl)) : stringArray;
    }

    protected String[] getSuppNode(QEPSupportList qEPSupportList, boolean bl) {
        return new String[]{this.suppInfo};
    }

    protected void formatSuppInfo(QEPSupportList qEPSupportList, Graphics graphics) {
        String[] stringArray = this.getSuppInfo(this);
        if (stringArray == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(new Font("Tahoma", 0, 16));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (int i = 0; i < stringArray.length; ++i) {
            this.formattedSuppInfo = QEPHelpers.concat(this.formattedSuppInfo, QEPHelpers.split(stringArray[i], 250, fontMetrics));
        }
        graphics.setFont(font);
    }

    protected int getType() {
        return this.nodeType;
    }

    protected int getNodeID() {
        return this.nodeID;
    }

    protected String getSupportInfo() {
        return this.suppInfo;
    }

    protected void setSupportInfo(String string) {
        this.suppInfo = string;
    }

    protected boolean isLSuppInfo() {
        switch (this.nodeType) {
            case 21: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 38: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    protected boolean needsListHead() {
        return false;
    }

    protected String[] getPexprs(String string) {
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!((n2 = string.indexOf("from", n2)) == -1 || Character.isWhitespace(cArray[n2 - 1]) && Character.isWhitespace(cArray[n2 + 4]))) {
            n2 += 4;
        }
        if (n2 == -1) {
            return null;
        }
        cArray = string.substring(6, n2).trim().toCharArray();
        n = 0;
        block7: for (n2 = 0; n2 <= cArray.length; ++n2) {
            if (n2 == cArray.length || cArray[n2] == ',' && n3 == 0 && !bl && !bl2) {
                arrayList.add(new String(cArray, n, n2 - n));
                n = n2 + 1;
                continue;
            }
            switch (cArray[n2]) {
                case '\'': {
                    if (bl2 || n2 == n && cArray[n2 - 1] == '\'') continue block7;
                    bl = !bl;
                    continue block7;
                }
                case '\"': {
                    if (bl || n2 == n && cArray[n2 - 1] == '\"') continue block7;
                    bl2 = !bl2;
                    continue block7;
                }
                case '(': {
                    if (bl || bl2) continue block7;
                    ++n3;
                    continue block7;
                }
                case ')': {
                    if (bl || bl2) continue block7;
                    --n3;
                    continue block7;
                }
            }
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = (String)arrayList.get(i);
            if (string2.toLowerCase().startsWith("distinct")) {
                string2 = string2.substring(8);
            }
            stringArray[i] = string2.trim();
        }
        return stringArray;
    }
}

