/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.usercodedeployment.impl;

import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.internal.usercodedeployment.impl.ClassData;
import com.hazelcast.internal.usercodedeployment.impl.ClassLocator;
import com.hazelcast.internal.usercodedeployment.impl.ClassSource;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public final class ClassDataProvider {
    private final UserCodeDeploymentConfig.ProviderMode providerMode;
    private final ClassLoader parent;
    private final ConcurrentMap<String, ClassSource> classSourceMap;
    private final ConcurrentMap<String, ClassSource> clientClassSourceMap;
    private final ILogger logger;

    public ClassDataProvider(UserCodeDeploymentConfig.ProviderMode providerMode, ClassLoader parent, ConcurrentMap<String, ClassSource> classSourceMap, ConcurrentMap<String, ClassSource> clientClassSourceMap, ILogger logger) {
        this.providerMode = providerMode;
        this.parent = parent;
        this.classSourceMap = classSourceMap;
        this.clientClassSourceMap = clientClassSourceMap;
        this.logger = logger;
    }

    public ClassData getClassDataOrNull(String className) {
        ClassData classData = this.loadBytecodesFromClientCache(className);
        if (classData != null) {
            return classData;
        }
        if (this.providerMode == UserCodeDeploymentConfig.ProviderMode.OFF) {
            return null;
        }
        classData = this.loadBytecodesFromParent(className);
        if (classData == null && this.providerMode == UserCodeDeploymentConfig.ProviderMode.LOCAL_AND_CACHED_CLASSES) {
            classData = this.loadBytecodesFromCache(className);
        }
        return classData;
    }

    private ClassData loadBytecodesFromCache(String className) {
        ClassSource classSource = (ClassSource)this.classSourceMap.get(ClassLocator.extractMainClassName(className));
        if (classSource == null) {
            return null;
        }
        return classSource.getClassData(className);
    }

    private ClassData loadBytecodesFromClientCache(String className) {
        ClassSource classSource = (ClassSource)this.clientClassSourceMap.get(ClassLocator.extractMainClassName(className));
        if (classSource == null) {
            return null;
        }
        return classSource.getClassData(className);
    }

    private ClassData loadBytecodesFromParent(String className) {
        byte[] mainClassDefinition = this.loadBytecodeFromParent(className);
        if (mainClassDefinition == null) {
            return null;
        }
        Map<String, byte[]> innerClassDefinitions = this.loadInnerClasses(className);
        innerClassDefinitions = this.loadAnonymousClasses(className, innerClassDefinitions);
        ClassData classData = new ClassData();
        if (innerClassDefinitions != null) {
            classData.setInnerClassDefinitions(innerClassDefinitions);
        }
        classData.setMainClassDefinition(mainClassDefinition);
        return classData;
    }

    private Map<String, byte[]> loadAnonymousClasses(String className, Map<String, byte[]> innerClassDefinitions) {
        int i = 1;
        try {
            while (true) {
                String innerClassName = String.valueOf(className) + "$" + i;
                this.parent.loadClass(innerClassName);
                byte[] innerByteCode = this.loadBytecodeFromParent(innerClassName);
                if (innerClassDefinitions == null) {
                    innerClassDefinitions = new HashMap<String, byte[]>();
                }
                innerClassDefinitions.put(innerClassName, innerByteCode);
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return innerClassDefinitions;
        }
    }

    private Map<String, byte[]> loadInnerClasses(String className) {
        HashMap<String, byte[]> innerClassDefinitions = null;
        try {
            Class<?>[] declaredClasses;
            Class<?> aClass = this.parent.loadClass(className);
            Class<?>[] classArray = declaredClasses = aClass.getDeclaredClasses();
            int n = declaredClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> declaredClass = classArray[n2];
                String innerClassName = declaredClass.getName();
                byte[] innerByteCode = this.loadBytecodeFromParent(innerClassName);
                if (innerClassDefinitions == null) {
                    innerClassDefinitions = new HashMap<String, byte[]>();
                }
                innerClassDefinitions.put(innerClassName, innerByteCode);
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
        }
        return innerClassDefinitions;
    }

    /*
     * Loose catch block
     */
    private byte[] loadBytecodeFromParent(String className) {
        InputStream is;
        block5: {
            String resource = className.replace('.', '/').concat(".class");
            is = null;
            is = this.parent.getResourceAsStream(resource);
            if (is == null) break block5;
            byte[] byArray = IOUtil.toByteArray(is);
            IOUtil.closeResource(is);
            return byArray;
            {
                catch (IOException e) {
                    try {
                        this.logger.severe(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeResource(is);
                        throw throwable;
                    }
                }
            }
        }
        IOUtil.closeResource(is);
        return null;
    }
}

