/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.predicates.AbstractVisitor;
import com.hazelcast.query.impl.predicates.AndPredicate;
import com.hazelcast.query.impl.predicates.CompositeEqualPredicate;
import com.hazelcast.query.impl.predicates.CompositeRangePredicate;
import com.hazelcast.query.impl.predicates.EqualPredicate;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import com.hazelcast.query.impl.predicates.RangePredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CompositeIndexVisitor
extends AbstractVisitor {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Predicate visit(AndPredicate andPredicate, Indexes indexes) {
        originalSize = andPredicate.predicates.length;
        if (originalSize < 2) {
            return andPredicate;
        }
        compositeIndexes = indexes.getCompositeIndexes();
        if (compositeIndexes.length == 0) {
            return andPredicate;
        }
        prefixes = null;
        comparisons = null;
        output = null;
        var8_8 = andPredicate.predicates;
        var9_10 = andPredicate.predicates.length;
        var10_12 = 0;
        while (var10_12 < var9_10) {
            predicate = var8_8[var10_12];
            if (PredicateUtils.isEqualPredicate(predicate)) {
                equalPredicate = (EqualPredicate)predicate;
                replaced /* !! */  = (prefixes = CompositeIndexVisitor.obtainHashMap(prefixes, originalSize)).put(equalPredicate.attributeName, equalPredicate);
                if (replaced /* !! */  != null) {
                    output = CompositeIndexVisitor.obtainOutput(output, originalSize);
                    output.add(replaced /* !! */ );
                }
            } else if (PredicateUtils.isRangePredicate(predicate)) {
                rangePredicate = (RangePredicate)predicate;
                replaced /* !! */  = (comparisons = CompositeIndexVisitor.obtainHashMap(comparisons, originalSize)).put(rangePredicate.getAttribute(), rangePredicate);
                if (replaced /* !! */  != null) {
                    output = CompositeIndexVisitor.obtainOutput(output, originalSize);
                    output.add(replaced /* !! */ );
                }
            } else {
                output = CompositeIndexVisitor.obtainOutput(output, originalSize);
                output.add(predicate);
            }
            ++var10_12;
        }
        if (prefixes == null || comparisons == null && prefixes.size() == 1) {
            return andPredicate;
        }
        if (CompositeIndexVisitor.$assertionsDisabled || !prefixes.isEmpty()) ** GOTO lbl83
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            bestPrefix = 0;
            bestIndex = null;
            bestComparison = null;
            var14_23 = compositeIndexes;
            var13_22 = compositeIndexes.length;
            rangePredicate = 0;
            while (rangePredicate < var13_22) {
                index = var14_23[rangePredicate];
                components = index.getComponents();
                if (components.length >= bestPrefix && (index.isOrdered() || prefixes.size() >= components.length)) {
                    prefix = 0;
                    while (prefix < components.length && prefixes.containsKey(components[prefix])) {
                        ++prefix;
                    }
                    if (prefix != 0) {
                        if (index.isOrdered()) {
                            v0 = comparison = prefix < components.length && comparisons != null ? comparisons.get(components[prefix]) : null;
                            if (comparison != null) {
                                ++prefix;
                            }
                            if (prefix > bestPrefix) {
                                bestPrefix = prefix;
                                bestIndex = index;
                                bestComparison = comparison;
                            } else if (prefix == bestPrefix) {
                                if (!CompositeIndexVisitor.$assertionsDisabled && bestIndex == null) {
                                    throw new AssertionError();
                                }
                                if (bestIndex.isOrdered() && bestIndex.getComponents().length > components.length) {
                                    bestIndex = index;
                                    bestComparison = comparison;
                                }
                            }
                        } else if (prefix == components.length && prefix >= bestPrefix) {
                            bestPrefix = prefix;
                            bestIndex = index;
                            bestComparison = null;
                        }
                    }
                }
                ++rangePredicate;
            }
            if (bestIndex == null || bestPrefix == 1) break;
            v1 = equalPrefixLength = bestComparison == null ? bestPrefix : bestPrefix - 1;
            if (output == null && (generated = CompositeIndexVisitor.tryGenerateFast(prefixes, comparisons, equalPrefixLength, bestComparison, bestIndex)) != null) {
                return generated;
            }
            output = CompositeIndexVisitor.obtainOutput(output, originalSize);
            CompositeIndexVisitor.addToOutput(prefixes, comparisons, output, equalPrefixLength, bestComparison, bestIndex);
lbl83:
            // 2 sources

            ** while (!prefixes.isEmpty())
        }
lbl84:
        // 2 sources

        return output == null ? andPredicate : output.generate(prefixes, comparisons, andPredicate);
    }

    private static Predicate tryGenerateFast(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, int prefixLength, RangePredicate comparison, InternalIndex index) {
        if (index.isOrdered()) {
            assert (prefixLength <= index.getComponents().length);
            return CompositeIndexVisitor.tryGenerateFastOrdered(prefixes, comparisons, prefixLength, comparison, index);
        }
        assert (comparison == null);
        assert (prefixLength == index.getComponents().length);
        return CompositeIndexVisitor.tryGenerateFastUnordered(prefixes, comparisons, prefixLength, index);
    }

    private static Predicate tryGenerateFastOrdered(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, int prefixLength, RangePredicate comparison, InternalIndex index) {
        assert (index.isOrdered());
        String[] components = index.getComponents();
        if (prefixes.size() != prefixLength) {
            return null;
        }
        if (comparison == null) {
            if (comparisons != null) {
                assert (!comparisons.isEmpty());
                return null;
            }
            if (prefixLength == components.length) {
                return CompositeIndexVisitor.generateEqualPredicate(index, prefixes, true);
            }
            return CompositeIndexVisitor.generateRangePredicate(index, prefixes, prefixLength, true);
        }
        if (comparisons.size() != 1) {
            return null;
        }
        return CompositeIndexVisitor.generateRangePredicate(index, prefixes, prefixLength, comparison, true);
    }

    private static Predicate tryGenerateFastUnordered(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, int prefixLength, InternalIndex index) {
        assert (!index.isOrdered());
        if (comparisons != null) {
            assert (!comparisons.isEmpty());
            return null;
        }
        if (prefixLength != prefixes.size()) {
            return null;
        }
        return CompositeIndexVisitor.generateEqualPredicate(index, prefixes, true);
    }

    private static void addToOutput(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, Output output, int prefixLength, RangePredicate comparison, InternalIndex index) {
        if (index.isOrdered()) {
            assert (prefixLength <= index.getComponents().length);
            CompositeIndexVisitor.addToOutputOrdered(prefixes, comparisons, output, prefixLength, comparison, index);
        } else {
            assert (comparison == null);
            assert (prefixLength == index.getComponents().length);
            CompositeIndexVisitor.addToOutputUnordered(prefixes, output, index);
        }
    }

    private static void addToOutputOrdered(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, Output output, int prefixLength, RangePredicate comparison, InternalIndex index) {
        assert (index.isOrdered());
        String[] components = index.getComponents();
        if (prefixLength == components.length) {
            output.addGenerated(CompositeIndexVisitor.generateEqualPredicate(index, prefixes, false));
            return;
        }
        if (comparison == null) {
            output.addGenerated(CompositeIndexVisitor.generateRangePredicate(index, prefixes, prefixLength, false));
        } else {
            comparisons.remove(comparison.getAttribute());
            output.addGenerated(CompositeIndexVisitor.generateRangePredicate(index, prefixes, prefixLength, comparison, false));
        }
    }

    private static void addToOutputUnordered(Map<String, EqualPredicate> prefixes, Output output, InternalIndex index) {
        assert (!index.isOrdered());
        output.addGenerated(CompositeIndexVisitor.generateEqualPredicate(index, prefixes, false));
    }

    private static Predicate generateEqualPredicate(InternalIndex index, Map<String, EqualPredicate> prefixes, boolean fast) {
        String[] components = index.getComponents();
        Comparable[] values = new Comparable[components.length];
        int i = 0;
        while (i < components.length) {
            values[i] = fast ? prefixes.get((Object)components[i]).value : prefixes.remove((Object)components[i]).value;
            ++i;
        }
        return new CompositeEqualPredicate(index, new CompositeValue(values));
    }

    private static Predicate generateRangePredicate(InternalIndex index, Map<String, EqualPredicate> prefixes, int prefixLength, boolean fast) {
        String[] components = index.getComponents();
        Comparable[] from = new Comparable[components.length];
        Comparable[] to = new Comparable[components.length];
        int i = 0;
        while (i < prefixLength) {
            Comparable value;
            from[i] = value = fast ? prefixes.get((Object)components[i]).value : prefixes.remove((Object)components[i]).value;
            to[i] = value;
            ++i;
        }
        i = prefixLength;
        while (i < components.length) {
            from[i] = CompositeValue.NEGATIVE_INFINITY;
            to[i] = CompositeValue.POSITIVE_INFINITY;
            ++i;
        }
        return new CompositeRangePredicate(index, new CompositeValue(from), false, new CompositeValue(to), false, prefixLength);
    }

    private static Predicate generateRangePredicate(InternalIndex index, Map<String, EqualPredicate> prefixes, int prefixLength, RangePredicate comparison, boolean fast) {
        boolean hasTo;
        assert (!(comparison instanceof EqualPredicate));
        assert (comparison.getFrom() != AbstractIndex.NULL && comparison.getTo() != AbstractIndex.NULL);
        String[] components = index.getComponents();
        boolean fullyMatched = components.length == prefixLength + 1;
        boolean hasFrom = comparison.getFrom() != null;
        boolean bl = hasTo = comparison.getTo() != null;
        assert (hasFrom || hasTo);
        assert (hasFrom || !comparison.isFromInclusive());
        assert (hasTo || !comparison.isToInclusive());
        Comparable[] from = new Comparable[components.length];
        Comparable[] to = new Comparable[components.length];
        int i = 0;
        while (i < prefixLength) {
            Comparable value;
            from[i] = value = fast ? prefixes.get((Object)components[i]).value : prefixes.remove((Object)components[i]).value;
            to[i] = value;
            ++i;
        }
        from[prefixLength] = hasFrom ? comparison.getFrom() : AbstractIndex.NULL;
        to[prefixLength] = hasTo ? comparison.getTo() : CompositeValue.POSITIVE_INFINITY;
        i = prefixLength + 1;
        while (i < components.length) {
            from[i] = !hasFrom || comparison.isFromInclusive() ? CompositeValue.NEGATIVE_INFINITY : CompositeValue.POSITIVE_INFINITY;
            to[i] = !hasTo || comparison.isToInclusive() ? CompositeValue.POSITIVE_INFINITY : CompositeValue.NEGATIVE_INFINITY;
            ++i;
        }
        return new CompositeRangePredicate(index, new CompositeValue(from), fullyMatched && comparison.isFromInclusive(), new CompositeValue(to), fullyMatched && comparison.isToInclusive(), prefixLength);
    }

    private static <K, V> Map<K, V> obtainHashMap(Map<K, V> map, int capacity) {
        return map == null ? new HashMap(capacity) : map;
    }

    private static Output obtainOutput(Output output, int capacity) {
        return output == null ? new Output(capacity) : output;
    }

    private static class Output
    extends ArrayList<Predicate> {
        private boolean requiresGeneration;

        public Output(int capacity) {
            super(capacity);
        }

        public void addGenerated(Predicate predicate) {
            this.add(predicate);
            this.requiresGeneration = true;
        }

        public Predicate generate(Map<String, EqualPredicate> prefixes, Map<String, RangePredicate> comparisons, AndPredicate andPredicate) {
            if (!this.requiresGeneration) {
                return andPredicate;
            }
            int newSize = this.size() + prefixes.size() + (comparisons == null ? 0 : comparisons.size());
            assert (newSize > 0);
            Predicate[] predicates = new Predicate[newSize];
            int index = 0;
            for (Predicate predicate : this) {
                predicates[index++] = predicate;
            }
            if (!prefixes.isEmpty()) {
                for (Predicate predicate : prefixes.values()) {
                    predicates[index++] = predicate;
                }
            }
            if (comparisons != null && !comparisons.isEmpty()) {
                for (Predicate predicate : comparisons.values()) {
                    predicates[index++] = predicate;
                }
            }
            assert (index == newSize);
            return new AndPredicate(predicates);
        }
    }
}

