/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.hazelcast.spi.BackupOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class AddAllBackupOperation
extends AbstractRingBufferOperation
implements BackupOperation {
    private long lastSequenceId;
    private Data[] items;

    public AddAllBackupOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public @SuppressFBWarnings(value={"EI_EXPOSE_REP"}) AddAllBackupOperation(String name, long lastSequenceId, Data[] items) {
        super(name);
        this.items = items;
        this.lastSequenceId = lastSequenceId;
    }

    @Override
    public void run() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        long firstSequenceId = this.lastSequenceId - (long)this.items.length + 1L;
        int i = 0;
        while (i < this.items.length) {
            ringbuffer.set(firstSequenceId + (long)i, this.items[i]);
            ++i;
        }
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.lastSequenceId);
        out.writeInt(this.items.length);
        Data[] dataArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            Data item = dataArray[n2];
            out.writeData(item);
            ++n2;
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.lastSequenceId = in.readLong();
        int length = in.readInt();
        this.items = new Data[length];
        int k = 0;
        while (k < this.items.length) {
            this.items[k] = in.readData();
            ++k;
        }
    }
}

