/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CompletableFutureTask<V>
extends AbstractCompletableFuture<V>
implements ICompletableFuture<V>,
RunnableFuture<V> {
    private static final AtomicReferenceFieldUpdater<CompletableFutureTask, Thread> RUNNER = AtomicReferenceFieldUpdater.newUpdater(CompletableFutureTask.class, Thread.class, "runner");
    private final Callable<V> callable;
    private volatile Thread runner;

    public CompletableFutureTask(Callable<V> callable, ExecutorService asyncExecutor) {
        super(asyncExecutor, Logger.getLogger(CompletableFutureTask.class));
        this.callable = callable;
    }

    public CompletableFutureTask(Runnable runnable, V result, ExecutorService asyncExecutor) {
        super(asyncExecutor, Logger.getLogger(CompletableFutureTask.class));
        this.callable = Executors.callable(runnable, result);
    }

    @Override
    public void run() {
        block10: {
            if (this.isDone()) {
                return;
            }
            if (this.runner != null || !RUNNER.compareAndSet(this, null, Thread.currentThread())) {
                return;
            }
            try {
                Callable<V> c = this.callable;
                if (c == null) break block10;
                ExecutionException result = null;
                try {
                    try {
                        result = (ExecutionException)c.call();
                    }
                    catch (Throwable ex) {
                        result = new ExecutionException(ex);
                        this.setResult(result);
                    }
                }
                finally {
                    this.setResult(result);
                }
            }
            finally {
                this.runner = null;
            }
        }
    }

    @Override
    protected void cancelled(boolean mayInterruptIfRunning) {
        Thread executingThread;
        if (mayInterruptIfRunning && (executingThread = this.runner) != null) {
            executingThread.interrupt();
        }
    }

    public String toString() {
        return "CompletableFutureTask{callable=" + this.callable + ", runner=" + this.runner + '}';
    }
}

