/*
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
package it.finanze.sanita.gva.enums;

import it.finanze.sanita.gva.validator.IUC;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum CVACErrorEnum implements IUC {
	T000("000"),T001("001"), T002("002"), T003("003"), T004("004"), T005("005"), T006("006"), T007("007"), T008("008"), T009("009"), T010("010"), T011("011"), T012("012"), T013("013"), T014("014"), T015("015"), T016("016"), T017("017"), T018("018"), T019("019"), T020("020"), T021("021"), T022("022"), T023("023"), T024("024"), T025("025"),
	T026("026"), T027("027"), T028("028"), T029("029"), T030("030"), T031("031"), T032("032"), T033("033"), T034("034"), T035("035"), T036("036"), T037("037"), T038("038"), T039("039"), T040("040"), T041("041"), T042("042"), T043("043"), T044("044"), T045("045"), T046("046"), T047("047"), T048("048"), T049("049"), T050("050"),
	T051("051"), T052("052"), T053("053"), T054("054"), T055("055"), T056("056"), T057("057"), T058("058"), T059("059"), T060("060"), T061("061"), T062("062"), T063("063"), T064("064"), T065("065"), T066("066"), T067("067"), T068("068"), T069("069"), T070("070"), T071("071"), T072("072"), T073("073"), T074("074"), T075("075"),
	T076("076"), T077("077"), T078("078"), T079("079"), T080("080"), T081("081"), T082("082"), T083("083"), T084("084"), T085("085"), T086("086"),
	CERT_VAC_ROOT("001"),
	CERT_VAC_CODE("002"),
	CERT_VAC_CODE_SYSTEM("003"),
	CERT_VAC_CODE_SYSTEM_NAME("004"),
	CERT_VAC_DISPLAY_NAME("005"),
	CERT_VAC_ENTRY_ROOT("006"),
	CERT_VAC_ENTRY_CLASS_CODE("007"),
	CERT_VAC_ENTRY_MOOD_CODE("008"),
	CERT_VAC_ENTRY_TEMPLATE_ID("009"),
	CERT_VAC_ENTRY_STATUS("010"),
	CERT_VAC_ENTRY_TIME("011"),
	CERT_VAC_ENTRY_CODE_SYSTEM("012"),
	CERT_VAC_ENTRY_CODE_SYSTEM_NAME("013"),
	CERT_VAC_ENTRY_APPR_CODE_SYSTEM("014"),
	CERT_VAC_ENTRY_APPR_CODE_SYSTEM_NAME("015"),
	CERT_VAC_ENTRY_CONS_TYPE_CODE("016"),
	CERT_VAC_ENTRY_CONS_CODE_SYSTEM("017"),
	CERT_VAC_ENTRY_CONS_CODE_SYSTEM_NAME("018"),
	CERT_VAC_ENTRY_PART_TYPE_CODE("019"),
	CERT_VAC_ENTRY_PART_CLASS_CODE("020"),
	CERT_VAC_ENTRY_TYPE_CODE("021"),
	CERT_VAC_ENTRY_INV_ID("022"),
	CERT_VAC_ENTRY_OBS_CLASS_CODE("023"),
	CERT_VAC_ENTRY_OBS_MOOD_CODE("024"),
	CERT_VAC_ENTRY_OBS_TEMPLATE_ID("025"),
	CERT_VAC_ENTRY_OBS_STATUS_CODE("026"),
	CERT_VAC_ENTRY_SUB_CLASS_CODE("027"),
	CERT_VAC_ENTRY_SUB_MOOD_CODE("028"),
	CERT_VAC_ENTRY_SUB_ROOT("029"),
	CERT_VAC_ENTRY_SUB_STATUS("030"),
	CERT_VAC_ENTRY_SUB_CONS_TYPE_CODE("031"),
	CERT_VAC_ENTRY_SUB_MAN_CODE("032"),
	CERT_VAC_ENTRY_SUB_MAN_CODE_SYSTEM_NAME("033"),
	CERT_VAC_ENTRY_SUB_MAN_TRANS_CODE_SYSTEM("034"),
	CERT_VAC_ENTRY_SUB_MAN_TRANS_CODE_SYSTEM_NAME("035"),
	CERT_VAC_ENTRY_SUB_PART_TYPE_CODE("036"),
	CERT_VAC_ENTRY_SUB_PART_CLASS_CODE("037"),
	CERT_VAC_ENTRY_SUB_TYPE_CODE("038"),
	CERT_VAC_ENTRY_SUB_INV_ID("039"),
	CERT_VAC_ENTRY_SUB_OBS_CLASS_CODE("040"),
	CERT_VAC_ENTRY_SUB_OBS_MOOD_CODE("041"),
	CERT_VAC_ENTRY_SUB_OBS_ROOT("042"),
	CERT_VAC_ENTRY_SUB_OBS_CODE_("043"),
	CERT_VAC_ENTRY_SUB_OBS_CODE_SYSTEM("044"),
	CERT_VAC_ENTRY_SUB_OBS_CODE_SYSTEM_NAME("045"),
	CERT_VAC_ENTRY_SUB_OBS_STATUS("046"),
	CERT_VAC_ENTRY_SUB_STATUS_CODE("047"),
	CERT_VAC_ENTRY_SUB_TIME("048"),
	CERT_VAC_ENTRY_SUB_CODE_SYSTEM("049"),
	CERT_VAC_ENTRY_SUB_CODE_SYSTEM_NAME("050"),
	CERT_VAC_ENTRY_SUB_APP_CODE_SYSTEM("051"),
	CERT_VAC_ENTRY_SUB_APP_CODE_SYSTEM_NAME("052"),
	CERT_VAC_ENTRY_SUB_CONS_CODE_SYSTEM("053"),
	CERT_VAC_ENTRY_SUB_CONS_CODE_SYSTEM_NAME("054"),
	CERT_VAC_ENTRY_SUB_CONS_TRANS_CODE_SYSTEM("055"),
	CERT_VAC_ENTRY_SUB_CONS_TRANS_CODE_SYSTEM_NAME("056"),
	CERT_VAC_ENTRY_SUB_ER_TYPE_CODE("057"),
	CERT_VAC_ENTRY_SUB_ER_INV_ID("058"),
	CERT_VAC_ENTRY_SUB_ER_OBS_MOOD_CODE("059"),
	CERT_VAC_ENTRY_SUB_ER_OBS_ROOT("060"),
	CERT_VAC_ENTRY_SUB_ER_OBS_STATUS("061"),
	CERT_VAC_ENTRY_SUB_ER_OBS_TIME("062"),
	SING_VAC_TYPE_CODE("063"),
	SING_VAC_INV_ID("064"),
	SING_VAC_OBS_MOOD_CODE("065"),
	SING_VAC_OBS_ROOT("066"),
	SING_VAC_OBS_STATUS("067"),
	SING_VAC_OBS_TIME("068"),
	SING_VAC_ER_TYPE_CODE("069"),
	SING_VAC_ER_INV_ID("070"),
	SING_VAC_ER_OBS_CLASS_CODE("071"),
	SING_VAC_ER_OBS_ROOT("072"),
	CERT_VAC_SUB_CLASS_CODE("073"),
	CERT_VAC_SUB_MOOD_CODE("074"),
	CERT_VAC_SUB_ROOT("075"),
	CERT_VAC_SUB_CODE("076"),
	CERT_VAC_SUB_TIME("077"),
	CERT_VAC_SUB_CODE_SYSTEM("078"),
	CERT_VAC_SUB_CODE_SYSTEM_NAME("079"),
	CERT_VAC_SUB_APPR_CODE_SYSTEM("080"),
	CERT_VAC_SUB_APPR_CODE_SYSTEM_NAME("081"),
	CERT_VAC_SUB_TYPE_CODE("082"),
	CERT_VAC_SUB_MAN_CODE_SYSTEM("083"),
	CERT_VAC_SUB_MAN_CODE_SYSTEM_NAME("084"),
	CERT_VAC_SUB_MAN_TRAN_CODE_SYSTEM("085"),
	CERT_VAC_SUB_MAN_TRAN_CODE_SYSTEM_NAME("086"),
	CERT_VAC_SUB_PART_TYPE_CODE("087"),
	CERT_VAC_SUB_PART_PART_ROLE("088"),
	CERT_VAC_SUB_ER_TYPE_CODE("089"),
	CERT_VAC_SUB_ER_INV_ID("090"),
	CERT_VAC_SUB_ER_OBS_CLASS_CODE("091"),
	CERT_VAC_SUB_ER_OBS_ROOT("092"),
	CERT_VAC_SUB_ER_OBS_STATUS_CODE("093"),
	CERT_VAC_SUB_ER_OBS_MOOD_CODE("094"),
	CERT_VAC_SUB_ER_OBS_STATUS("095"),
	CERT_VAC_SUB_OBS_CLASS_CODE("096"),
	CERT_VAC_SUB_OBS_MOOD_CODE("097"),
	CERT_VAC_SUB_OBS_ROOT("098"),
	CERT_VAC_SUB_OBS_STATUS("099"),
	CERT_VAC_SUB_STATUS("100"),
	CERT_VAC_SUB_CONS_TYPE_CODE("101"),
	CERT_VAC_SUB_CONS_CODE_SYSTEM("102"),
	CERT_VAC_SUB_CONS_CODE_SYSTEM_NAME("103"),
	CERT_VAC_SUB_CONS_TRANS_CODE_SYSTEM("104"),
	CERT_VAC_SUB_CONS_TRANS_CODE_SYSTEM_NAME("105"),
	CERT_VAC_SUB_ER_OBS_CODE("106"),
	CERT_VAC_SUB_ER_OBS_CODE_SYSTEM("107"),
	CERT_VAC_SUB_ER_OBS_CODE_SYSTEM_NAME("108"),
	CERT_VAC_SUB_ER_TIME_LOW("109"),
	CERT_VAC_SUB_ER_TIME_HIGH("110"),
	CERT_VAC_SUB_ER_OBS_TYPE_CODE("111"),
	CERT_VAC_SUB_ER_OBS_INV_ID("112"),
	CERT_VAC_SUB_ER_OBS_TIME_LOW("113"),
	CERT_VAC_SUB_ER_OBS_TIME_HIGH("114"),
	CERT_VAC_TIME("115"),
	CERT_VAC_SUB_ROUTE_CODE_SYSTEM("116"),
	CERT_VAC_SUB_ROUTE_CODE_SYSTEM_NAME("117"),
	CERT_VAC_SUB_ER_CLASS_CODE("118"),
	CERT_VAC_SUB_ER_MOOD_CODE("119"),
	CERT_VAC_OBS_ROOT("120"),
	CERT_VAC_SUB_ER_STATUS("121"),
	CERT_VAC_SUB_STATUS_CODE("122"),
	CERT_VAC_MOOD_CODE("123"),
	CERT_VAC_CLASS_CODE("124"),
	CERT_VAC_OBS_CLASS_CODE("125"),
	CERT_VAC_OBS_MOOD_CODE("126"),
	CERT_VAC_OBS_STATUS_CODE("127"),
	CERT_VAC_ROUTE_CODE_SYSTEM("128"),
	CERT_VAC_ROUTE_CODE_SYSTEM_NAME("129"),
	CERT_VAC_APP_CODE_SYSTEM("130"),
	CERT_VAC_APP_CODE_SYSTEM_NAME("131"),
	CERT_VAC_CONS_TYPE_CODE("132"),
	CERT_VAC_CONS_CODE_SYSTEM("133"),
	CERT_VAC_CONS_CODE_SYSTEM_NAME("134"),
	CERT_VAC_CONS_TRANS_CODE_SYSTEM("135"),
	CERT_VAC_CONS_TRANS_CODE_SYSTEM_NAME("136"),
	CERT_VAC_PART_TYPE_CODE("137"),
	CERT_VAC_PART_CLASS_CODE("138"),
	CERT_VAC_ER_TYPE_CODE("139"),
	CERT_VAC_ER_INV_ID("140"),
	CERT_VAC_OBS_CODE_SYSTEM("141"),
	CERT_VAC_OBS_CODE_SYSTEM_NAME("142"),
	CERT_VAC_OBS_STATUS("143"),
	CERT_VAC_OBS_CODE("144"),
	CERT_VAC_OBS_VALUE("145"),
	CERT_VAC_SUB_PART_CLASS_CODE("146"),
	CERT_VAC_SUB_OBS_TIME_LOW("147"),
	COMP_TYPE_CODE("148"),
	COMP_COND_IND("149"),
	COMP_CLASS_CODE("150"),
	COMP_MOOD_CODE("151"),
	COMP_STRUCT_TYPE_CODE("152"),
	COMP_COMP_COND_IND("153"),
	COMP_COMP_CLASS_CODE("154"),
	COMP_COMP_MOOD_CODE("155"),
	SING_VAC_OBS_CLASS_CODE("156"),
	SING_VAC_ER_OBS_MOOD_CODE("157"),
	SING_VAC_ER_OBS_STATUS("158"),
	CERT_VAC_ENTRY_SUB_ER_OBS_CLASS_CODE("159");

	private final String code;

}
