/*
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
package it.finanze.sanita.gva.enums;

import it.finanze.sanita.gva.validator.IUC;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum SVACErrorEnum implements IUC {

	T000("000"),T001("001"), T002("002"), T003("003"), T004("004"), T005("005"), T006("006"), T007("007"), T008("008"), T009("009"), T010("010"), T011("011"), T012("012"), T013("013"), T014("014"), T015("015"), T016("016"), T017("017"), T018("018"), T019("019"), T020("020"), T021("021"), T022("022"), T023("023"), T024("024"), T025("025"),
	T026("026"), T027("027"), T028("028"), T029("029"), T030("030"), T031("031"), T032("032"), T033("033"), T034("034"), T035("035"), T036("036"), T037("037"), T038("038"), T039("039"), T040("040"), T041("041"), T042("042"), T043("043"), T044("044"), T045("045"),
	T046("046"), T047("047"), T048("048"),
	TRASPORTO_CLASS_CODE("001"),
	STATUS("002"),
	TIME("003"),
	MATERIAL_CODE_SYSTEM("004"),
	MATERIAL_CODE_SYSTEM_NAME("005"),
	MATERIAL_TRANS_CODE_SYSTEM("006"),
	MATERIAL_TRANS_CODE_SYSTEM_NAME("007"),
	SUBSTANCE_CLASS_CODE("008"),
	SUBSTANCE_MOOD_CODE("009"),
	SUBSTANCE_ROOT("010"),
	SUBSTANCE_STATUS_CODE("011"),
	SUBSTANCE_CONS_TYPE_CODE("012"),
	SUBSTANCE_CONS_MAN_CODE_SYSTEM("013"),
	SUBSTANCE_CONS_MAN_CODE_SYSTEM_NAME("014"),
	SUBSTANCE_CONS_MAN_TRANS_CODE_SYSTEM("015"),
	SUBSTANCE_CONS_MAN_TRANS_CODE_SYSTEM_NAME("016"),
	PART_TYPE_CODE("017"),
	PART_CLASS_CODE("018"),
	ER_TYPE_CODE("019"),
	OBS_CLASS_CODE("020"),
	OBS_MOOD_CODE("021"),
	OBS_TEMPLATE_ID("022"),
	OBS_CODE("023"),
	OBS_CODE_SYSTEM("024"),
	OBS_CODE_SYSTEM_NAME("025"),
	OBS_STATUS_CODE("026"),
	TEMPLATE_ID("027"),
	SUBSTANCE_CODE_SYSTEM("028"),
	SUBSTANCE_APPROACH_CODE_SYSTEM("029"),
	SUBSTANCE_APPROACH_CODE_SYSTEM_NAME("030"),
	OBS_TIME("031"),
	SUBSTANCE_TYPE_CODE("032"),
	TEMPLATE_ROOT("033"),
	STATUS_CODE("034"),
	TYPE_CODE("035"),
	MAN_CODE_SYSTEM("036"),
	MAN_CODE_SYSTEM_NAME("037"),
	MAN_TRANS_CODE_SYSTEM("038"),
	MAN_TRANS_CODE_SYSTEM_NAME("039"),
	SUB_CODE_SYSTEM("040"),
	SUB_SITE_CODE_SYSTEM("041"),
	SUB_SITE_CODE_SYSTEM_NAME("042"),
	SUB_CONS_TYPE_CODE("043"),
	SUB_CONS_MATERIAL_CODE_SYSTEM("044"),
	SUB_CONS_MATERIAL_CODE_SYSTEM_NAME("045"),
	SUB_CONS_MATERIAL_TRANS_CODE_SYSTEM("046"),
	SUB_CONS_MATERIAL_TRANS_CODE_SYSTEM_NAME("047"),
	SUB_PART_TYPE_CODE("048"),
	SUB_PART_CLASS_CODE("049"),
	SUB_ER_TYPE_CODE("050"),
	SUB_ER_INV_ID("051"),
	SUV_INV_ID("052"),
	CONTEXT_ID("053"),
	CLASS_CODE("054"),
	MOOD_CODE("055"),
	COMP_TYPE_CODE("056"),
	COMP_CONTEXT_ID("057"),
	COMP_CLASS_CODE("058"),
	COMP_MOOD_CODE("059"),
	COMP_TEMPLATE_ID("060"),
	COMP_CODE("061"),
	COMP_CODE_SYSTEM("062"),
	COMP_CODE_SYSTEM_NAME("063"),
	COMP_DISPLAY_NAME("064"),
	COMP_SUBSTANCE_CLASS_CODE("065"),
	COMP_SUBSTANCE_MOOD_CODE("066");

	private final String code;

}
