package it.finanze.sanita.gva.validator;

import java.util.ArrayList;
import java.util.List;

import it.finanze.sanita.gva.dto.ErrorUCTDTO;
import it.finanze.sanita.gva.enums.PssErrorEnum;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class PssValidator extends DocumentTypeValidator {


	public static List<ErrorUCTDTO> validateUC1New(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>(); 
		ValidationXML.equalIC(errors, PssErrorEnum.T000, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T001, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "code", "48765-2");
		ValidationXML.equalIC(errors, PssErrorEnum.T002, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T003, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T004, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "displayName", "Allergie, Reazioni Avverse");
		ValidationXML.equalTAG(errors, PssErrorEnum.T005, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > title", "Allergie e Intolleranze");
		ValidationXML.equalIC(errors, PssErrorEnum.T006, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T007, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T008, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T009, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > code", "nullFlavor", "NA");
		ValidationXML.equalIC(errors, PssErrorEnum.T010, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T011, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T012, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T013, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T014, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "code", "52473-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T015, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T016, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T017, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "displayName", "Allergia o causa della reazione");
		ValidationXML.equalIC(errors, PssErrorEnum.T018, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T019, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T020, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > value", "codeSystemName", "ObservationIntoleranceType");
		ValidationXML.equalIC(errors, PssErrorEnum.T021, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant", "typeCode", "CSM");
		ValidationXML.equalIC(errors, PssErrorEnum.T022, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant > participantRole", "classCode", "MANU");
		ValidationXML.equalIC(errors, PssErrorEnum.T023, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "classCode", "MMAT");
		ValidationXML.equalIC(errors, PssErrorEnum.T024, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship", "typeCode", "MFST", "SUBJ", "REFR");
		ValidationXML.equalIC(errors, PssErrorEnum.T025, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.5.1", "2.16.840.1.113883.2.9.10.1.4.3.1.5.2", "2.16.840.1.113883.2.9.10.1.4.3.1.5.3", "2.16.840.1.113883.2.9.10.1.4.3.1.6");
		ValidationXML.equalIC(errors, PssErrorEnum.T026, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "code", "75321-0", "5321-0", "SEV", "33999-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T027, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T028, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystemName", "LOINC", "ActCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T029, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "displayName", "Obiettività Clinica", "Clinical Finding", "Criticality", "Stato");
		ValidationXML.equalIC(errors, PssErrorEnum.T030, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T031, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T032, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T033, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T034, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T035, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T036, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "code", "10160-0");
		ValidationXML.equalIC(errors, PssErrorEnum.T037, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T038, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T039, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "displayName", "History of medication use");
		ValidationXML.equalTAG(errors, PssErrorEnum.T040, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > title", "Terapie Farmacologiche");
		ValidationXML.equalIC(errors, PssErrorEnum.T041, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T042, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration", "moodCode", "INT", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T043, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.2.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T044, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > statusCode", "code", "active", "suspended", "aborted", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T045, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.2.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T046, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, PssErrorEnum.T047, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T048, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "code", "11369-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T049, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T050, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T051, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "displayName", "Storia di immunizzazioni");
		ValidationXML.equalTAG(errors, PssErrorEnum.T052, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > title",  "Vaccinazioni");
		ValidationXML.equalIC(errors, PssErrorEnum.T053, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T054, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration", "moodCode", "INT", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T055, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.3.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T056, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "code", "IMMUNIZ");
		ValidationXML.equalIC(errors, PssErrorEnum.T057, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T058, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "codeSystemName", "ActCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T059, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable", "typeCode", "CSM");
		ValidationXML.equalIC(errors, PssErrorEnum.T060, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct", "classCode", "MANU");
		ValidationXML.equalIC(errors, PssErrorEnum.T061, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.3.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T062, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "classCode", "MMAT");
		ValidationXML.equalIC(errors, PssErrorEnum.T063, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "determinerCode", "KIND");
		ValidationXML.equalIC(errors, PssErrorEnum.T064, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T065, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T066, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "code", "11450-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T067, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T068, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T069, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "displayName", "Lista dei Problemi");
		ValidationXML.equalTAG(errors, PssErrorEnum.T070, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > title", "Lista dei Problemi");
		ValidationXML.equalIC(errors, PssErrorEnum.T071, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T072, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T073, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T074, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > code", "nullFlavor", "NA");
		ValidationXML.equalIC(errors, PssErrorEnum.T075, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T076, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T077, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T078, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T079, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, PssErrorEnum.T090, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T091, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T092, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "displayName", "Problema","Problem");
		ValidationXML.equalIC(errors, PssErrorEnum.T093, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T094, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > value", "xsi:type", "CD");
		ValidationXML.equalIC(errors, PssErrorEnum.T095, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.4", "2.16.840.1.113883.2.9.10.1.4.3.1.6", "2.16.840.1.113883.2.9.10.1.4.3.4.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T096, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.3", "");
		ValidationXML.equalIC(errors, PssErrorEnum.T097, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.16");
		ValidationXML.equalIC(errors, PssErrorEnum.T098, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "code", "10157-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T099, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T100, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T101, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "displayName", "Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, PssErrorEnum.T102, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, PssErrorEnum.T103, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T104, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.16.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T105, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "code", "10157-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T106, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T107, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T108, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, PssErrorEnum.T109, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T110, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject", "typeCode", "SBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T111, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject", "classCode", "PRS");
		ValidationXML.equalIC(errors, PssErrorEnum.T112, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > code", "codeSystem", "2.16.840.1.113883.5.111");
		ValidationXML.equalIC(errors, PssErrorEnum.T113, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > code", "codeSystemName", "RoleCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T114, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T115, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, PssErrorEnum.T116, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T117, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T118, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.16.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T119, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T120, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T121, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T122, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T123, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.16.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T124, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
		ValidationXML.equalIC(errors, PssErrorEnum.T125, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T126, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.6");
		ValidationXML.equalIC(errors, PssErrorEnum.T127, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "code", "29762-2");
		ValidationXML.equalIC(errors, PssErrorEnum.T128, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T129, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T130, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "displayName", "Stile di vita");
		ValidationXML.equalIC(errors, PssErrorEnum.T131, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T132, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T133, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T134, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T135, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T136, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T137, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T138, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "code", "10162-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T139, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T140, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T141, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "displayName", "Storia di gravidanze");
		ValidationXML.equalIC(errors, PssErrorEnum.T142, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T143, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T144, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.7.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T145, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T146, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T147, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T148, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > value", "xsi:type", "CD", "PQ", "TS", "INT", "ST");
		ValidationXML.equalIC(errors, PssErrorEnum.T149, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.8");
		ValidationXML.equalIC(errors, PssErrorEnum.T150, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "code", "8716-3");
		ValidationXML.equalIC(errors, PssErrorEnum.T151, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T152, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T153, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "displayName", "Parametri vitali");
		ValidationXML.equalIC(errors, PssErrorEnum.T154, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, PssErrorEnum.T155, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T156, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.8.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T157, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T158, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T159, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T160, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T161, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T162, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.8.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T163, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T164, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.9");
		ValidationXML.equalIC(errors, PssErrorEnum.T165, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "code", "46264-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T166, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T167, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T168, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "displayName", "Storia di uso di dispositivi medici","Storia d'uso di dispositivi medici");
		ValidationXML.equalIC(errors, PssErrorEnum.T169, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > entry > supply > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.9.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T170, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.10");
		ValidationXML.equalIC(errors, PssErrorEnum.T171, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "code", "18776-5");
		ValidationXML.equalIC(errors, PssErrorEnum.T172, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T173, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T174, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "displayName", "Piano di cura");
		ValidationXML.equalIC(errors, PssErrorEnum.T175, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T176, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T177, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T178, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation > id", "root", "9a6d1bac-17d3-4195-89a4-1121bc809b4a");
		ValidationXML.equalIC(errors, PssErrorEnum.T179, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T180, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T181, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T182, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, PssErrorEnum.T184, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > procedure > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T185, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T186, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > encounter > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T187, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T188, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T189, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T190, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act > id", "root", "9a6d1bac-17d3-4195-89a4-1121bc809b4a");
		ValidationXML.equalIC(errors, PssErrorEnum.T191, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.11");
		ValidationXML.equalIC(errors, PssErrorEnum.T192, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "code", "47519-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T193, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T194, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T195, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "displayName", "Storia di procedure");
		ValidationXML.equalTAG(errors, PssErrorEnum.T196, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > title", "Trattamenti e procedure terapeutiche, chirurgiche e diagnostiche");
		ValidationXML.equalIC(errors, PssErrorEnum.T197, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, PssErrorEnum.T198, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.11.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T200, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.6.103", "2.16.840.1.113883.2.9.77.22.11.12");
		ValidationXML.equalIC(errors, PssErrorEnum.T201, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.12");
		ValidationXML.equalIC(errors, PssErrorEnum.T202, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "code", "46240-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T203, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T204, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T205, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "displayName", "Storia di ospedalizzazioni e storia di visite ambulatoriali");
		ValidationXML.equalIC(errors, PssErrorEnum.T206, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter", "classCode", "ENC");
		ValidationXML.equalIC(errors, PssErrorEnum.T207, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T208, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.12.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T209, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T210, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.13");
		ValidationXML.equalIC(errors, PssErrorEnum.T211, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "code", "47420-5");
		ValidationXML.equalIC(errors, PssErrorEnum.T212, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalTAG(errors, PssErrorEnum.T213, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > title", "Stato funzionale del Paziente");
		ValidationXML.equalIC(errors, PssErrorEnum.T214, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry", "typeCode", "DRIV");
		ValidationXML.equalIC(errors, PssErrorEnum.T215, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer", "classCode", "BATTERY");
		ValidationXML.equalIC(errors, PssErrorEnum.T216, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T217, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.14.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T218, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T219, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T220, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T221, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.14.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T222, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > code", "code", "75246-9", "ASSERTION");
		ValidationXML.equalIC(errors, PssErrorEnum.T223, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T224, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T225, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > value", "xsi:type", "CD");
		ValidationXML.equalIC(errors, PssErrorEnum.T226, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.15", "2.16.840.1.113883.2.9.5.2.8","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T227, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.15");
		ValidationXML.equalIC(errors, PssErrorEnum.T228, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "code", "42348-3");
		ValidationXML.equalIC(errors, PssErrorEnum.T229, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T230, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T231, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "displayName", "Dichiarazioni anticipate di trattamento");
		ValidationXML.equalTAG(errors, PssErrorEnum.T232, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > title", "Assenso / Dissenso Donazione Organi");
		ValidationXML.equalIC(errors, PssErrorEnum.T233, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.17");
		ValidationXML.equalIC(errors, PssErrorEnum.T234, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "code", "57827-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T235, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T236, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T237, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "displayName", "Motivo di esenzione dal co-pagamento");
		ValidationXML.equalTAG(errors, PssErrorEnum.T238, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > title", "Esenzioni");
		ValidationXML.equalIC(errors, PssErrorEnum.T239, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T240, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T241, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.17.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T242, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.18");
		ValidationXML.equalIC(errors, PssErrorEnum.T243, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "code", "PSSIT99");
		ValidationXML.equalIC(errors, PssErrorEnum.T244, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "codeSystem", "2.16.840.1.113883.2.9.5.2.8");
		ValidationXML.equalIC(errors, PssErrorEnum.T245, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "codeSystemName", "ProfiloSanitarioSinteticoIT");
		ValidationXML.equalIC(errors, PssErrorEnum.T246, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "displayName", "Reti di Patologia");
		ValidationXML.equalTAG(errors, PssErrorEnum.T247, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > title", "Reti di Patologia");
		ValidationXML.equalIC(errors, PssErrorEnum.T248, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act", "classCode", "PCPR");
		ValidationXML.equalIC(errors, PssErrorEnum.T249, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T250, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.18.1");
 
		return errors;
	}


	public static List<ErrorUCTDTO> validateUC2New(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();

		ValidationXML.equalIC(errors, PssErrorEnum.T251, xml, "ClinicalDocument > component > structuredBody > component > section[ID='ALLERGIE_INTOLLERANZE'] > templateId", "root","2.16.840.1.113883.2.9.10.1.4.2.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T252, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "code", "48765-2");
		ValidationXML.equalIC(errors, PssErrorEnum.T253, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T254, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T255, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > code", "displayName", "Allergie, Reazioni Avverse");
		ValidationXML.equalIC(errors, PssErrorEnum.T256, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T257, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T258, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T259, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > code", "nullFlavor", "NA");
		ValidationXML.equalIC(errors, PssErrorEnum.T260, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T261, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T262, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T263, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.4", "2.16.840.1.113883.2.9.10.1.4.3.1.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T264, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "code", "OINT", "52473-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T265, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.5.4", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T266, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "codeSystemName", "ObservationIntoleranceType", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T267, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > code", "displayName", "Intolerance", "Allergia o causa della reazione");
		ValidationXML.equalIC(errors, PssErrorEnum.T268, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T269, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.5.1150.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T270, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant", "typeCode", "CSM");
		ValidationXML.equalIC(errors, PssErrorEnum.T271, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant > participantRole", "classCode", "MANU");
		ValidationXML.equalIC(errors, PssErrorEnum.T272, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "classCode", "MMAT");
		ValidationXML.equalIC(errors, PssErrorEnum.T273, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship", "typeCode", "MFST", "SUBJ", "REFR");
		ValidationXML.equalIC(errors, PssErrorEnum.T274, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.5.1", "2.16.840.1.113883.2.9.10.1.4.3.1.5.2", "2.16.840.1.113883.2.9.10.1.4.3.1.5.3", "2.16.840.1.113883.2.9.10.1.4.3.1.6");
		ValidationXML.equalIC(errors, PssErrorEnum.T275, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "code", "75321-0", "5321-0", "SEV", "33999-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T276, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T277, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystemName", "LOINC", "ActCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T278, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "displayName", "Obiettività Clinica", "Clinical Finding", "Criticality", "Stato");
		ValidationXML.equalIC(errors, PssErrorEnum.T279, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T280, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T281, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T282, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Allergie_Intolleranze] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T283, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T284, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "code", "10160-0");
		ValidationXML.equalIC(errors, PssErrorEnum.T285, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T286, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T287, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > code", "displayName", "History of medication use");
		ValidationXML.equalTAG(errors, PssErrorEnum.T288, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > title", "Terapie Farmacologiche");
		ValidationXML.equalIC(errors, PssErrorEnum.T289, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T290, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration", "moodCode", "INT", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T291, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.2.1", "2.16.840.1.113883.2.9.10.1.4.3.2.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T292, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > statusCode", "code", "active", "suspended", "aborted", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T293, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.2.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T294, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Terapie_Farmacologiche] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, PssErrorEnum.T295, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T296, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "code", "11369-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T297, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T298, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T299, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > code", "displayName", "Storia di immunizzazioni");
		ValidationXML.equalTAG(errors, PssErrorEnum.T300, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > title", "Vaccinazioni");
		ValidationXML.equalIC(errors, PssErrorEnum.T301, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T302, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration", "moodCode", "INT", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T303, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.3.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T304, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "code", "IMMUNIZ");
		ValidationXML.equalIC(errors, PssErrorEnum.T305, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T306, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > code", "codeSystemName", "ActCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T307, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T308, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable", "typeCode", "CSM");
		ValidationXML.equalIC(errors, PssErrorEnum.T309, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct", "classCode", "MANU");
		ValidationXML.equalIC(errors, PssErrorEnum.T310, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.3.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T311, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "classCode", "MMAT");
		ValidationXML.equalIC(errors, PssErrorEnum.T312, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "determinerCode", "KIND");
		ValidationXML.equalIC(errors, PssErrorEnum.T313, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T314, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code > translation", "codeSystem", "2.16.840.1.113883.6.73");
		ValidationXML.containsIC(errors, PssErrorEnum.T315, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship", "typeCode", "CAUS", "SUBJ");
		ValidationXML.containsIC(errors, PssErrorEnum.T316, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.containsIC(errors, PssErrorEnum.T317, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.containsIC(errors, PssErrorEnum.T318, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.3.4", "2.16.840.1.113883.2.9.10.1.4.3.3.3");
		ValidationXML.containsIC(errors, PssErrorEnum.T319, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > code", "code", "30973-2", "59781-5");
		ValidationXML.containsIC(errors, PssErrorEnum.T320, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.containsIC(errors, PssErrorEnum.T321, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.containsIC(errors, PssErrorEnum.T322, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > code", "displayName", "Numero di Dose", "Validità della dose");
		ValidationXML.containsIC(errors, PssErrorEnum.T323, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.containsIC(errors, PssErrorEnum.T324, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Vaccinazioni] > entry > substanceAdministration > entryRelationship > observation > value", "xsi:type", "INT", "IVL_TS");
		ValidationXML.equalIC(errors, PssErrorEnum.T325, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T326, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "code", "11450-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T327, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T328, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T329, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > code", "displayName", "Lista dei Problemi");
		ValidationXML.equalTAG(errors, PssErrorEnum.T330, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > title", "Lista dei Problemi");
		ValidationXML.equalIC(errors, PssErrorEnum.T331, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T332, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T333, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T334, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > code",  "nullFlavor", "NA");
		ValidationXML.equalIC(errors, PssErrorEnum.T335, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T336, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T337, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T338, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T339, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, PssErrorEnum.T340, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T341, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T342, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > code", "displayName", "Problema");
		ValidationXML.equalIC(errors, PssErrorEnum.T343, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T344, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > value", "xsi:type", "CD");
		ValidationXML.equalIC(errors, PssErrorEnum.T345, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.4.4", "2.16.840.1.113883.2.9.10.1.4.3.1.6", "“2.16.840.1.113883.2.9.10.1.4.3.4.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T346, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T347, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T348, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T349, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > code", "code", "48767-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T350, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T351, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T352, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > code", "displayName", "Annotation comment");
		ValidationXML.equalIC(errors, PssErrorEnum.T353, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=Lista_Problemi] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T354, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.16");
		ValidationXML.equalIC(errors, PssErrorEnum.T355, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "code", "10157-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T356, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T357, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T358, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > code", "displayName", "Storia di malattie di membri familiari");
		ValidationXML.equalTAG(errors, PssErrorEnum.T359, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > title", "Anamnesi Familiare");
		ValidationXML.equalIC(errors, PssErrorEnum.T360, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, PssErrorEnum.T361, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T362, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.16.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T363, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "code", "10157-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T364, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T365, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T366, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, PssErrorEnum.T367, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T368, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject", "typeCode", "SBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T369, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject", "classCode", "PRS");
		ValidationXML.equalIC(errors, PssErrorEnum.T370, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > code", "codeSystem", "2.16.840.1.113883.5.111");
		ValidationXML.equalIC(errors, PssErrorEnum.T371, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > code", "codeSystemName", "RoleCode");
		ValidationXML.equalIC(errors, PssErrorEnum.T372, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T373, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, PssErrorEnum.T374, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T375, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T376, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.16.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T377, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T378, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T379, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T380, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
		ValidationXML.equalIC(errors, PssErrorEnum.T381, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Anamnesi_Familiare] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T382, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.6");
		ValidationXML.equalIC(errors, PssErrorEnum.T383, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "code", "29762-2");
		ValidationXML.equalIC(errors, PssErrorEnum.T384, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T385, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T386, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > code", "displayName", "Stile di vita");
		ValidationXML.equalIC(errors, PssErrorEnum.T387, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T388, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T389, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T390, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T391, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T392, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stile_di_Vita] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T393, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T394, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "code", "10162-6");
		ValidationXML.equalIC(errors, PssErrorEnum.T395, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T396, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T397, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > code", "displayName", "Storia di gravidanze");
		ValidationXML.equalIC(errors, PssErrorEnum.T398, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T399, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T400, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.7.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T401, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T402, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T403, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T404, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Gravidanze_Parto] > entry > observation > value", "xsi:type", "CD", "PQ", "TS", "INT", "ST");
		ValidationXML.equalIC(errors, PssErrorEnum.T405, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.8");
		ValidationXML.equalIC(errors, PssErrorEnum.T406, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "code", "8716-3");
		ValidationXML.equalIC(errors, PssErrorEnum.T407, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T408, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T409, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "displayName", "Parametri vitali");
		ValidationXML.equalIC(errors, PssErrorEnum.T410, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, PssErrorEnum.T411, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T412, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.8.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T413, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T414, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T415, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T416, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T417, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T418, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.8.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T419, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T420, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.9");
		ValidationXML.equalIC(errors, PssErrorEnum.T421, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "code", "46264-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T422, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T423, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T424, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > code", "displayName", "Storia di uso di dispositivi medici","Storia d'uso di dispositivi medici");
		ValidationXML.equalIC(errors, PssErrorEnum.T425, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Protesi_impianti_ausili] > entry > supply > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.9.1", "2.16.840.1.113883.2.9.10.1.4.3.9.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T426, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.10");
		ValidationXML.equalIC(errors, PssErrorEnum.T427, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "code", "18776-5");
		ValidationXML.equalIC(errors, PssErrorEnum.T428, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T429, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T430, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > code", "displayName", "Piano di cura");
		ValidationXML.equalIC(errors, PssErrorEnum.T431, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T432, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T433, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T434, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > observation > id", "root", "9a6d1bac-17d3-4195-89a4-1121bc809b4a");
		ValidationXML.equalIC(errors, PssErrorEnum.T435, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, PssErrorEnum.T436, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T437, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T438, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, PssErrorEnum.T439, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > procedure > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.3");
		ValidationXML.equalIC(errors, PssErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T440, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > encounter > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T441, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T442, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act", "moodCode", "RQO");
		ValidationXML.equalIC(errors, PssErrorEnum.T443, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.10.5");
		ValidationXML.equalIC(errors, PssErrorEnum.T444, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piani_cura] > entry > act > id", "root", "9a6d1bac-17d3-4195-89a4-1121bc809b4a");
		ValidationXML.equalIC(errors, PssErrorEnum.T445, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "code", "47519-4");
		ValidationXML.equalIC(errors, PssErrorEnum.T446, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T447, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T448, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > code", "displayName", "Storia di procedure");
		ValidationXML.equalTAG(errors, PssErrorEnum.T449, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > title", "Trattamenti e procedure terapeutiche, chirurgiche e diagnostiche");
		ValidationXML.equalIC(errors, PssErrorEnum.T450, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, PssErrorEnum.T451, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T452, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.11.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T453, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Trattamenti_procedure_terapeutiche_chirurgiche_diagnostiche] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.6.103", "2.16.840.1.113883.2.9.77.22.11.12", "2.16.840.1.113883.11.22.36");
		ValidationXML.equalIC(errors, PssErrorEnum.T454, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.12");
		ValidationXML.equalIC(errors, PssErrorEnum.T455, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "code", "46240-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T456, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T457, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T458, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > code", "displayName", "Storia di ospedalizzazioni e storia di visite ambulatoriali");
		ValidationXML.equalIC(errors, PssErrorEnum.T459, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter", "classCode", "ENC");
		ValidationXML.equalIC(errors, PssErrorEnum.T460, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T461, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.12.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T462, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter > code", "codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T463, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Visite_Ricoveri] > entry > encounter > performer", "typeCode", "PRF");
		ValidationXML.equalIC(errors, PssErrorEnum.T464, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.13");
		ValidationXML.equalIC(errors, PssErrorEnum.T465, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "code", "47420-5");
		ValidationXML.equalIC(errors, PssErrorEnum.T466, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T467, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T468, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > code", "displayName", "Nota di valutazione dello stato funzionale");
		ValidationXML.equalTAG(errors, PssErrorEnum.T469, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > title", "Stato funzionale del Paziente");
		ValidationXML.equalIC(errors, PssErrorEnum.T470, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry", "typeCode", "DRIV");
		ValidationXML.equalIC(errors, PssErrorEnum.T471, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer", "classCode", "BATTERY");
		ValidationXML.equalIC(errors, PssErrorEnum.T472, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T473, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.14.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T474, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T475, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T476, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T477, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.14.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T478, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > code", "code", "75246-9", "ASSERTION");
		ValidationXML.equalIC(errors, PssErrorEnum.T479, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, PssErrorEnum.T480, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > statusCode", "code", "completed");
		// ValidationXML.equalIC(errors, PssErrorEnum.T481, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Stato_funzionale_Paziente] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.15", "2.16.840.1.113883.2.9.5.2.8");
		ValidationXML.equalIC(errors, PssErrorEnum.T482, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.14");
		ValidationXML.equalIC(errors, PssErrorEnum.T483, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > code", "code", "30954-2");
		ValidationXML.equalIC(errors, PssErrorEnum.T484, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T485, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T486, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > code", "displayName", "Test diagnostici rilevanti e/o dati di laboratorio");
		ValidationXML.equalTAG(errors, PssErrorEnum.T487, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > title", "Indagini diagnostiche e esami di laboratorio");
		ValidationXML.equalIC(errors, PssErrorEnum.T488, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer", "classCode", "BATTERY", "CLUSTER");
		ValidationXML.equalIC(errors, PssErrorEnum.T489, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T490, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T491, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T492, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, PssErrorEnum.T493, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T494, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.14.2");
		ValidationXML.equalIC(errors, PssErrorEnum.T495, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T496, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T497, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T498, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > value", "xsi:type", "PQ");
		ValidationXML.equalIC(errors, PssErrorEnum.T499, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > interpretationCode", "codeSystem", "2.16.840.1.113883.5.83");
		ValidationXML.equalIC(errors, PssErrorEnum.T500, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > interpretationCode", "codeSystemName", "ObservationInterpretation");
		ValidationXML.equalIC(errors, PssErrorEnum.T501, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Indagini_diagnostiche_esami_laboratorio] > entry > organizer > component > observation > referenceRange > observationRange > value", "xsi:type", "IVL_PQ");
		ValidationXML.equalIC(errors, PssErrorEnum.T502, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.15");
		ValidationXML.equalIC(errors, PssErrorEnum.T503, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "code", "42348-3");
		ValidationXML.equalIC(errors, PssErrorEnum.T504, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T505, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T506, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > code", "displayName", "Dichiarazioni anticipate di trattamento");
		ValidationXML.equalTAG(errors, PssErrorEnum.T507, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Assenso_Dissenso_Donazione_Organi] > title", "Assenso / Dissenso Donazione Organi");
		ValidationXML.equalIC(errors, PssErrorEnum.T508, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.17");
		ValidationXML.equalIC(errors, PssErrorEnum.T509, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "code", "57827-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T510, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T511, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T512, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > code", "displayName", "Motivo di esenzione dal co-pagamento");
		ValidationXML.equalTAG(errors, PssErrorEnum.T513, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > title", "Esenzioni");
		ValidationXML.equalIC(errors, PssErrorEnum.T514, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T515, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T516, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.17.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T517, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > statusCode", "code", "active", "suspended", "aborted", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T518, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, PssErrorEnum.T519, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship", "inversionInd", "true");
		ValidationXML.equalIC(errors, PssErrorEnum.T520, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T521, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T522, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T523, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > code", "code", "48767-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T524, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T525, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T526, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > code", "displayName", "Annotation comment");
		ValidationXML.equalIC(errors, PssErrorEnum.T527, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esenzioni] > entry > act > entryRelationship > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T528, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.2.18");
		ValidationXML.equalIC(errors, PssErrorEnum.T529, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "code", "PSSIT99");
		ValidationXML.equalIC(errors, PssErrorEnum.T530, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "codeSystem", "2.16.840.1.113883.2.9.5.2.8");
		ValidationXML.equalIC(errors, PssErrorEnum.T531, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "codeSystemName", "ProfiloSanitarioSinteticoIT");
		ValidationXML.equalIC(errors, PssErrorEnum.T532, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > code", "displayName", "Reti di Patologia");
		ValidationXML.equalTAG(errors, PssErrorEnum.T533, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > title", "Reti di Patologia");
		ValidationXML.equalIC(errors, PssErrorEnum.T534, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act", "classCode", "PCPR");
		ValidationXML.equalIC(errors, PssErrorEnum.T535, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T536, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.18.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T537, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > statusCode", "code", "active", "suspended", "aborted", "completed");
		ValidationXML.equalIC(errors, PssErrorEnum.T538, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship", "typeCode", "COMP");
		ValidationXML.equalIC(errors, PssErrorEnum.T539, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, PssErrorEnum.T540, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, PssErrorEnum.T541, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.4.3.1.7");
		ValidationXML.equalIC(errors, PssErrorEnum.T542, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > code", "code", "48767-8");
		ValidationXML.equalIC(errors, PssErrorEnum.T543, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, PssErrorEnum.T544, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, PssErrorEnum.T545, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > code", "displayName", "Annotation comment");
		ValidationXML.equalIC(errors, PssErrorEnum.T546, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Reti_Patologia] > entry > act > entryRelationship > act > statusCode", "code", "completed");

		return errors;
	}




}
