package it.finanze.sanita.gva.validator;

import java.util.ArrayList;
import java.util.List;

import it.finanze.sanita.gva.dto.ErrorUCTDTO;
import it.finanze.sanita.gva.enums.RSAErrorEnum;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class RSAValidator extends DocumentTypeValidator {
 

	public static List<ErrorUCTDTO> validateUC24(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();

		ValidationXML.equalIC(errors, RSAErrorEnum.T001, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "code", "29299-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T002, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T003, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T004, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "displayName", "Motivo della visita");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T005, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > title", "Quesito Diagnostico");
		ValidationXML.equalIC(errors, RSAErrorEnum.T006, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T007, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "code", "29298-7");
		ValidationXML.equalIC(errors, RSAErrorEnum.T008, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T009, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T010, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "displayName", "Motivo della visita");
		ValidationXML.equalIC(errors, RSAErrorEnum.T011, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.containsIC(errors, RSAErrorEnum.T012 , xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > value", "codeSystemName", "ICD9CM", "ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T013, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "code", "11329-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T014, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T015, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T016, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "displayName", "Storia Generale");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T017, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > title", "Storia Clinica");
		ValidationXML.equalIC(errors, RSAErrorEnum.T018, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T019, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, RSAErrorEnum.T020, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T021, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T022, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "displayName", "Problem");
		ValidationXML.equalIC(errors, RSAErrorEnum.T023, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T024, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, RSAErrorEnum.T025, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T026, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "code", "10157-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T027, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T028, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T029, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "displayName", "Storie di malattie di membri familiari");
		ValidationXML.equalIC(errors, RSAErrorEnum.T030, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T031, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject", "classcode", "PRS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T032, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T033, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, RSAErrorEnum.T034, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T035, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T036, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T037, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T038, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > value", "codeSystemName", "ICD9-CM", "ICD9CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T039, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, RSAErrorEnum.T040, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T041, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T042, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T043, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "code", "48765-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T044, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T045, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T046, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "displayName", "Allergie e/o Reazioni Avverse");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T047, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > title", "Allergie");
		ValidationXML.equalIC(errors, RSAErrorEnum.T048, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T049, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T050, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > code", "nullFlavor", "NA");
		ValidationXML.equalIC(errors, RSAErrorEnum.T051, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T052, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "code", "52473-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T053, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T054, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T055, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "displayName", "Allergia o causa della reazione");
		ValidationXML.equalIC(errors, RSAErrorEnum.T056, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T057, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > value", "codeSystemName", "ObservationIntoleranceType");
		ValidationXML.equalIC(errors, RSAErrorEnum.T062, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "code", "10160-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T063, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T064, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T065, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "displayName", "Uso di farmaci");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T066, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > title", "Terapia farmacologica in atto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T067, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T068, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T069, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, RSAErrorEnum.T070, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "code", "30954-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T071, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T072, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T073, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "displayName", "Test diagnostici e/o dati di laboratorio rilevanti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T074, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > title", "Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T075, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T076, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "code", "29545-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T077, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T078, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T079, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "displayName", "Osservazioni fisiche");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T080, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > title", "Esame Obiettivo");
		ValidationXML.equalIC(errors, RSAErrorEnum.T081, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "code", "62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T082, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T083, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T084, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "displayName", "Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T085, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > title", "Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T086, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T087, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T088, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act > entryRelationship > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T089, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act > entryRelationship > procedure", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T090, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "code", "93126-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T091, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T092, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T093, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "displayName", "Confronto con precedenti esami eseguiti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T094, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > title", "Confronto con Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T095, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "code", "47045-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T096, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T097, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T098, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "displayName", "Referto");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T099, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > title", "Referto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T100, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "code", "29548-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T101, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T102, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T103, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "displayName", "Diagnosi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T104, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > title", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T105, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T106, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "code", "29308-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T107, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T108, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T109, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "displayName", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T110, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.containsIC(errors, RSAErrorEnum.T111, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > value", "codeSystemName", "ICD9-CM", "ICD9CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T112, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "code", "55110-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T113, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T114, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T115, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "displayName", "Conclusioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T116, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > title", "Conclusioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T117, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "code", "62385-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T118, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T119, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T120, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "displayName", "Raccomandazioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T121, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > title", "Suggerimenti per il Medico Prescrittore");
		ValidationXML.equalIC(errors, RSAErrorEnum.T122, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "code", "80615-8");
		ValidationXML.equalIC(errors, RSAErrorEnum.T123, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T124, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T125, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "displayName", "Follow-up consigliato");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T126, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > title", "Accertamenti e Controlli Consigliati");
		ValidationXML.equalIC(errors, RSAErrorEnum.T127, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > entry > act", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T128, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T129, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "code", "93341-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T130, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T131, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T132, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "displayName", "Farmaci consigliati");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T133, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > title", "Terapia Farmacologica Consigliata");
		ValidationXML.equalIC(errors, RSAErrorEnum.T134, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T135, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T136, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");

		System.out.println(getErrors(errors));

		return errors;
	}

	public static List<ErrorUCTDTO> validateUC25(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();

		ValidationXML.equalIC(errors, RSAErrorEnum.T137, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem",	"2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, RSAErrorEnum.T138, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "code", "29299-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T139, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T140, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T141, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > code", "displayName", "Motivo della visita");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T142, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > title", "Quesito Diagnostico");
		ValidationXML.equalIC(errors, RSAErrorEnum.T143, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T144, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "code", "29298-7");
		ValidationXML.equalIC(errors, RSAErrorEnum.T145, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T146, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T147, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > code", "displayName", "Motivo della visita");
		ValidationXML.equalIC(errors, RSAErrorEnum.T148, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.containsIC(errors, RSAErrorEnum.T149, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Quesito_Diagnostico] > entry > observation > value", "codeSystemName", "ICD9CM", "ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T150, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "code", "11329-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T151, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T152, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T153, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > code", "displayName", "Storia Generale");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T154, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > title", "Storia Clinica");
		ValidationXML.equalIC(errors, RSAErrorEnum.T155, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T156, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, RSAErrorEnum.T157, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T158, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T159, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > code", "displayName", "Problem");
		ValidationXML.equalIC(errors, RSAErrorEnum.T160, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T161, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > entryRelationship > observation > code", "code", "89261-2", "33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T162, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T163, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T164, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > observation > entryRelationship > observation > code", "displayName", "Decorso Clinico", "Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T165, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, RSAErrorEnum.T166, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T167, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "code", "10157-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T168, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T169, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T170, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > code", "displayName", "Storie di malattie di membri familiari");
		ValidationXML.equalIC(errors, RSAErrorEnum.T171, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T172, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject", "classcode", "PRS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T173, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T174, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, RSAErrorEnum.T175, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T176, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T177, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T178, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T179, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > value", "codeSystemName", "ICD9-CM", "ICD9CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T180, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship", "typeCode",	"SUBJ");
		ValidationXML.equalIC(errors, RSAErrorEnum.T181, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T182, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "code",	"35267-4", "39016-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T183, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T184, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T185, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > entry > organizer > component > observation > entryRelationship > observation > code", "displayName", "Età diagnosi patologia", "Età_decesso");
		ValidationXML.equalIC(errors, RSAErrorEnum.T186, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "code", "48765-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T187, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T188, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T189, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > code", "displayName", "Allergie e/o Reazioni Avverse");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T190, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > title", "Allergie");
		ValidationXML.equalIC(errors, RSAErrorEnum.T191, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T192, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T193, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > code", "nullFlavor", "NA");
		ValidationXML.equalIC(errors, RSAErrorEnum.T194, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T195, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "code", "52473-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T196, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T197, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T198, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "displayName", "Allergia o causa della reazione");
		ValidationXML.equalIC(errors, RSAErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T200, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > value", "codeSystemName", "ObservationIntoleranceType");
		ValidationXML.equalIC(errors, RSAErrorEnum.T201, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship", "typeCode", "MFST", "SUBJ", "REFR");
		ValidationXML.equalIC(errors, RSAErrorEnum.T202, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "code", "75321-0", "5321-0", "SEV", "33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T203, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T204, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystemName", "LOINC", "ActCode");
		ValidationXML.equalIC(errors, RSAErrorEnum.T205, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "displayName", "Obiettività Clinica", "Clinical Finding", "Criticality", "Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T206, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T207, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T208, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T209, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T210, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "code", "10160-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T211, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T212, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T213, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > code", "displayName", "Uso di farmaci");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T214, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > title", "Terapia farmacologica in atto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T215, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T216, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T217, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Storia_Clinica] > component > section[ID=Terapia_Farmacologica_in_atto] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, RSAErrorEnum.T218, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "code", "30954-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T219, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T220, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T221, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > code", "displayName", "Test diagnostici e/o dati di laboratorio rilevanti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T222, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > title", "Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T223, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Precedenti_Esami_Eseguiti] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T224, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "code", "29545-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T225, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T226, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T227, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > code", "displayName", "Osservazioni fisiche");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T228, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Esame_Obiettivo] > title", "Esame Obiettivo");
		ValidationXML.equalIC(errors, RSAErrorEnum.T229, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "code", "62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T230, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T231, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T232, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > code", "displayName", "Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T233, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > title", "Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T234, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T235, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T236, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act > entryRelationship > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T237, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Prestazioni] > entry > act > entryRelationship > procedure", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T238, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "code", "93126-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T239, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T240, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T241, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > code", "displayName", "Confronto con precedenti esami eseguiti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T242, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Confronto_con_Precedenti_Esami_Eseguiti] > title", "Confronto con Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T243, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "code", "47045-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T244, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T245, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T246, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > code", "displayName", "Referto");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T247, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Referto] > title", "Referto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T248, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "code", "29548-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T249, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T250, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T251, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > code", "displayName", "Diagnosi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T252, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > title", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T253, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T254, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "code", "29308-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T255, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T256, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T257, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > code", "displayName", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T258, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.containsIC(errors, RSAErrorEnum.T259, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Diagnosi] > entry > observation > value", "codeSystemName", "ICD9-CM", "ICD9CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T260, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "code", "55110-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T261, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T262, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T263, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > code", "displayName", "Conclusioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T264, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Conclusioni] > title", "Conclusioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T265, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "code", "62385-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T266, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T267, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T268, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > code", "displayName", "Raccomandazioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T269, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Suggerimenti_Medico_Prescrittore] > title", "Suggerimenti per il Medico Prescrittore");
		ValidationXML.equalIC(errors, RSAErrorEnum.T270, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "code", "80615-8");
		ValidationXML.equalIC(errors, RSAErrorEnum.T271, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T272, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T273, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > code", "displayName", "Follow-up consigliato");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T274, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > title", "Accertamenti e Controlli Consigliati");
		ValidationXML.equalIC(errors, RSAErrorEnum.T275, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > entry > act", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T276, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti_e_Controlli_Consigliati] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T277, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "code", "93341-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T278, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T279, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T280 , xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > code", "displayName", "Farmaci consigliati");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T281, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > title", "Terapia Farmacologica Consigliata");
		ValidationXML.equalIC(errors, RSAErrorEnum.T282, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T283, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Consigliata] > entry > substanceAdministration", "classCode", "SBADM");

		return errors;
	}

	public static List<ErrorUCTDTO> validateUC1(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		ValidationXML.equalIC(errors, RSAErrorEnum.T01, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "code", "62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T02, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T03, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T04, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "displayName", "Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T05, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > title","Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T06, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T07, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act", "moodCode", "EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T08, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > effectiveTime", "value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T09, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure", "classCode", "PROC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T10, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T11, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code", "code", "47045-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T12, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T13, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T14, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code", "displayName", "Referto");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T15, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > title", "Referto");
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC2(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		ValidationXML.equalIC(errors, RSAErrorEnum.T16, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","code", "29299-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T17, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T18, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T19, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","displayName", "Motivo della visita");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T20, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > title","Quesito Diagnostico");
		ValidationXML.equalIC(errors, RSAErrorEnum.T21, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation","classCode", "OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T22, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation","moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T23, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","code", "29298-7");
		ValidationXML.equalIC(errors, RSAErrorEnum.T24, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T25, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T26, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","displayName", "Motivo della visita");
		ValidationXML.equalIC(errors, RSAErrorEnum.T27, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T28, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value","codeSystemName","ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T30, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","code", "11329-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T31, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T32, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T33, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","displayName","Storia Generale");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T34, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > title","Storia Clinica");
		ValidationXML.equalIC(errors, RSAErrorEnum.T36, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation","classCode", "OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T37, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation","moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T38, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","code", "75326-9");
		ValidationXML.equalIC(errors, RSAErrorEnum.T39, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T40, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T41, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","displayName","Problem");
		ValidationXML.equalIC(errors, RSAErrorEnum.T42, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T43, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","code","89261-2", "33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T44, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T45, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T46, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","displayName", "Decorso Clinico", "Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T47, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","code","89261-2","33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T48, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T49, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T50, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","displayName","Decorso Clinico","Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T51, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer","classCode","CLUSTER");
		ValidationXML.equalIC(errors, RSAErrorEnum.T52, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T53, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","code","10157-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T54, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T55, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T56, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","displayName","Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, RSAErrorEnum.T57, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T58, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject","classcode","PRS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T62, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode","codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T63, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode","codeSystemName","HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, RSAErrorEnum.T65, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T67, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T68, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > statusCode","code","completed");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T69, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > effectiveTime","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T70, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T71, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > value","codeSystemName","ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T71, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship","typeCode","SUBJ");
		ValidationXML.equalIC(errors, RSAErrorEnum.T73, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","classCode", "OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T74, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T75, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","code", "35267-4","39016-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T76, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T77, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T78, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","displayName","Età insorgernza","Età diagnosi patologia");
		ValidationXML.equalIC(errors, RSAErrorEnum.T79, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T80, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T81, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","code","35267-4","39016-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T82, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","displayName","Età diagnosi patologia","Età_decesso");
		ValidationXML.equalIC(errors, RSAErrorEnum.T83, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","code","48765-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T84, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T85, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T86, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","displayName","Allergie e/o Reazioni Avverse");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T87, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > title","Allergie");
		ValidationXML.equalIC(errors, RSAErrorEnum.T88, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T89, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T93, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T94, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T95, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","code","52473-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T96, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T97, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T98, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","displayName","Allergia o causa della reazione");
		ValidationXML.equalIC(errors, RSAErrorEnum.T100, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T103, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > value","codeSystem", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T104, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > value","codeSystemName","ObservationIntoleranceType");
		ValidationXML.equalIC(errors, RSAErrorEnum.T109, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship","typeCode","MFST","SUBJ","REFR");
		ValidationXML.equalIC(errors, RSAErrorEnum.T110, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","code","75321-0","5321-0","SEV","33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T111, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1","2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T112, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T113, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","displayName","Obiettività Clinica","Clinical Finding","Criticality","Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T114, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode","code","completed");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T116, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > effectiveTime > high","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T120, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T121, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T123, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T124, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","code","62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T125, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T126, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T127, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","displayName","Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T128, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > title","Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T130, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T131, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act","moodCode","EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T137, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > effectiveTime","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T140, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure","classCode","PROC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T141, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T142, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","code","93126-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T143, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T144, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T145, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","displayName","Confronto con precedenti esami eseguiti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T146, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > title","Confronto con Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T147, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","code","47045-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T148, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T149, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T150, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","displayName","Referto");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T151, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > title","Referto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T152, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","code","29548-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T153, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T154, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T155, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","displayName","Diagnosi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T156, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > title","Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T157, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T158, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T159, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","code","29308-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T160, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T161, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T162, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","displayName","Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T164, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T167, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","code","55110-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T168, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T169, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T170, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","displayName","Conclusioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T171, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > title","Conclusioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T172, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","code","80615-8");
		ValidationXML.equalIC(errors, RSAErrorEnum.T173, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T174, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T175, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","displayName","Follow-up consigliato");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T176, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > title","Accertamenti e Controlli Consigliati");
		ValidationXML.equalIC(errors, RSAErrorEnum.T177, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act","moodCode","PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T178, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act","classCode","ACT");
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC3(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();

		ValidationXML.equalIC(errors, RSAErrorEnum.T183, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code", "code", "29299-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T184, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T185, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T186, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code", "displayName", "Motivo della visita");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T187, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > title", "Quesito Diagnostico");
		ValidationXML.equalIC(errors, RSAErrorEnum.T188, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T189, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T190, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "code", "29298-7");
		ValidationXML.equalIC(errors, RSAErrorEnum.T191, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T192, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T193, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "displayName", "Motivo della visita");
		ValidationXML.equalIC(errors, RSAErrorEnum.T194, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T195, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value", "codeSystemName", "ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T196, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "code", "62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T02, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T03, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T04, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code", "displayName", "Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T05, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > title", "Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T06, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T07, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act", "moodCode", "EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T08, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > effectiveTime", "value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T197, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code", "code", "93126-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T198, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T200, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code", "displayName", "Confronto con Precedenti Esami Eseguiti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T201, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > title", "Referto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T202, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "code", "29548-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T203, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T204, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T205, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "displayName", "Diagnosi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T206, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > title", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T207, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T208, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T209, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code", "code", "29308-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T210, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T211, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T212, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code", "displayName", "Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T213, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T214, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > value", "codeSystemName", "ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T215, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code", "code", "55110-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T216, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T217, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T218, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code", "displayName", "Conclusioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T219, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > title", "Conclusioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T220, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code", "code", "80615-8");
		ValidationXML.equalIC(errors, RSAErrorEnum.T221, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T222, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T223, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code", "displayName", "Follow-up consigliato");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T224, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > title", "Accertamenti e Controlli Consigliati");
		ValidationXML.equalIC(errors, RSAErrorEnum.T225, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T226, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T227, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code", "code", "93341-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T228, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T229, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T230, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code", "displayName", "Farmaci consigliati");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T231, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > title", "Terapia Farmacologica Consigliata");
		ValidationXML.equalIC(errors, RSAErrorEnum.T232, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration", "moodCode", "PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T233, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T234, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > routeCode", "codeSystem", "2.16.840.1.113883.5.112");
		ValidationXML.equalIC(errors, RSAErrorEnum.T235, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > approachSiteCode", "codeSystem", "2.16.840.1.113883.5.1052");
		ValidationXML.equalIC(errors, RSAErrorEnum.T237, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.6.73","2.16.840.1.113883.2.9.6.1.5","2.16.840.1.113883.2.9.6.1.51");
//		ValidationXML.equalIC(errors, RSAErrorEnum.T240, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > entryRelationship > supply","classCode","SPLY");
//		ValidationXML.equalIC(errors, RSAErrorEnum.T241, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > entryRelationship > supply","moodCode","RQO");
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC4(final String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();

		ValidationXML.equalIC(errors, RSAErrorEnum.T242, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","code","29299-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T243, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T244, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T245, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > code","displayName","Motivo della visita");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T246, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > title","Quesito Diagnostico");
		ValidationXML.equalIC(errors, RSAErrorEnum.T247, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T248, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T249, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","code","29298-7");
		ValidationXML.equalIC(errors, RSAErrorEnum.T250, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T251, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T252, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > code","displayName","Motivo della visita");
		ValidationXML.equalIC(errors, RSAErrorEnum.T254, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T255, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Quesito_Diagnostico'] > entry > observation > value","codeSystemName","ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T257, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","code","11329-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T258, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T259, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T260, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > code","displayName","Storia Generale");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T261, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > title","Storia Clinica");
		ValidationXML.equalIC(errors, RSAErrorEnum.T263, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T264, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T265, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","code","75326-9");
		ValidationXML.equalIC(errors, RSAErrorEnum.T266, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T267, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T268, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > code","displayName","Problem");
		ValidationXML.equalIC(errors, RSAErrorEnum.T269, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > statusCode","code","completed");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T270, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > effectiveTime > low","value");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T271, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > effectiveTime > high","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T273, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","code","89261-2","33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T274, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T275, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T276, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > observation > entryRelationship > observation > code","displayName","Decorso Clinico","Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T279, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer","classCode","CLUSTER");
		ValidationXML.equalIC(errors, RSAErrorEnum.T280, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T281, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","code","10157-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T282, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T283, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T284, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > code","displayName","Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, RSAErrorEnum.T285, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T286, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject","classcode","PRS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T290, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode","codeSystem","2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T291, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode","codeSystemName","HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, RSAErrorEnum.T293, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T294, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T295, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > statusCode","code","completed");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T296, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > effectiveTime","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T297, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T298, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > value","codeSystemName","ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T299, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship","typeCode","SUBJ");
		ValidationXML.equalIC(errors, RSAErrorEnum.T300, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T301, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T302, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","code","35267-4","39016-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T303, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T304, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T305, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > entry > organizer > component > observation > entryRelationship > observation > code","displayName","Età diagnosi patologia","Età_decesso");
		ValidationXML.equalIC(errors, RSAErrorEnum.T306, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","code","48765-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T307, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T308, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T309, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > code","displayName","Allergie e/o Reazioni Avverse");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T310, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > title","Allergie");
		ValidationXML.equalIC(errors, RSAErrorEnum.T311, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T312, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act","moodCode","EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T314, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > effectiveTime > low","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T316, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T317, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T318, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","code","52473-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T319, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T320, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T321, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code","displayName","Allergia o causa della reazione");
		ValidationXML.equalIC(errors, RSAErrorEnum.T323, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > statusCode","code","completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T326, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > value","codeSystem","2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T327, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > value","codeSystemName","ObservationIntoleranceType");
		ValidationXML.containsIC(errors, RSAErrorEnum.T329, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity > code","codeSystem","2.16.840.1.113883.2.9.77.22.11.2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T332, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship","typeCode","MFST","SUBJ","REFR");
		ValidationXML.equalIC(errors, RSAErrorEnum.T333, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","code","75321-0","5321-0","SEV","33999-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T334, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","codeSystem","2.16.840.1.113883.6.1","2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T335, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","codeSystemName","LOINC","ActCode");
		ValidationXML.equalIC(errors, RSAErrorEnum.T336, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code","displayName","Obiettività Clinica","Clinical Finding","Criticality","Stato");
		ValidationXML.equalIC(errors, RSAErrorEnum.T337, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode","code","completed");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T338, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > effectiveTime > low","value");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T339, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > effectiveTime > high","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T343, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T344, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T346, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > act > statusCode","code", "completed");
		ValidationXML.equalIC(errors, RSAErrorEnum.T347, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > code","code","10160-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T348, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T349, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T350, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > code","displayName","Uso di farmaci");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T351, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > title","Terapia farmacologica in atto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T352, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > entry > substanceAdministration","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T353, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > entry > substanceAdministration","classCode","SBADM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T355, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Storia_Clinica'] > component > section[ID='Terapia_Farmacologica_in_atto'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code","codeSystem","2.16.840.1.113883.6.73","2.16.840.1.113883.2.9.6.1.5","2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, RSAErrorEnum.T359, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > code","code","30954-2");
		ValidationXML.equalIC(errors, RSAErrorEnum.T360, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T361, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T362, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > code","displayName","Test diagnostici e/o dati di laboratorio rilevanti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T363, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > title","Precedenti Esami Eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T364, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T365, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation","moodCode","EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T369, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > effectiveTime > low","value");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T370, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > effectiveTime > high","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T371, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Esame_Obiettivo'] > code","code","29545-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T372, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Esame_Obiettivo'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T373, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Esame_Obiettivo'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T374, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Esame_Obiettivo'] > code","displayName","Osservazioni fisiche");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T375, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Esame_Obiettivo'] > title","Esame Obiettivo");
		ValidationXML.equalIC(errors, RSAErrorEnum.T376, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","code","62387-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T377, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T378, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T379, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > code","displayName","Interventi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T380, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > title","Prestazioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T382, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T383, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act","moodCode","EVN");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T389, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > effectiveTime","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T392, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure","classCode","PROC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T393, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Prestazioni'] > entry > act > entryRelationship > procedure","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T394, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","code","93126-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T395, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T396, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T397, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > code","displayName","Confronto con precedenti esami eseguiti");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T398, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Confronto_con_Precedenti_Esami_Eseguiti'] > title","Confronto con precedenti esami eseguiti");
		ValidationXML.equalIC(errors, RSAErrorEnum.T399, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","code","47045-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T400, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T401, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T402, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > code","displayName","Referto");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T403, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Referto'] > title","Referto");
		ValidationXML.equalIC(errors, RSAErrorEnum.T404, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","code","29548-5");
		ValidationXML.equalIC(errors, RSAErrorEnum.T405, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T406, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T407, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code","displayName","Diagnosi");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T408, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > title","Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T409, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation","moodCode","EVN");
		ValidationXML.equalIC(errors, RSAErrorEnum.T410, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation","classCode","OBS");
		ValidationXML.equalIC(errors, RSAErrorEnum.T411, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","code","29308-4");
		ValidationXML.equalIC(errors, RSAErrorEnum.T412, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T413, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T414, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > code","displayName","Diagnosi");
		ValidationXML.equalIC(errors, RSAErrorEnum.T415, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > value","codeSystem","2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, RSAErrorEnum.T416, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > observation > value","codeSystemName","ICD9-CM");
		ValidationXML.equalIC(errors, RSAErrorEnum.T418, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","code","55110-1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T419, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T420, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T421, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > code","displayName","Conclusioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T422, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Conclusioni'] > title","Conclusioni");
		ValidationXML.equalIC(errors, RSAErrorEnum.T423, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Suggerimenti_Medico_Prescrittore'] > code","code","62385-0");
		ValidationXML.equalIC(errors, RSAErrorEnum.T424, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Suggerimenti_Medico_Prescrittore'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T425, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Suggerimenti_Medico_Prescrittore'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T426, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Suggerimenti_Medico_Prescrittore'] > code","displayName","Raccomandazioni");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T427, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Suggerimenti_Medico_Prescrittore'] > title","Suggerimenti per il Medico Prescrittore");
		ValidationXML.equalIC(errors, RSAErrorEnum.T428, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","code","80615-8");
		ValidationXML.equalIC(errors, RSAErrorEnum.T429, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T430, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T431, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > code","displayName","Follow-up consigliato");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T432, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > title","Accertamenti e Controlli Consigliati");
		ValidationXML.equalIC(errors, RSAErrorEnum.T433, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act","moodCode","PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T434, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti_e_Controlli_Consigliati'] > entry > act","classCode","ACT");
		ValidationXML.equalIC(errors, RSAErrorEnum.T439, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code","code","93341-6");
		ValidationXML.equalIC(errors, RSAErrorEnum.T440, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code","codeSystem","2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, RSAErrorEnum.T441, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code","codeSystemName","LOINC");
		ValidationXML.equalIC(errors, RSAErrorEnum.T442, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > code","displayName","Farmaci consigliati");
		ValidationXML.equalTAG(errors, RSAErrorEnum.T443, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > title","Terapia Farmacologica Consigliata");
		ValidationXML.equalIC(errors, RSAErrorEnum.T444, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration","moodCode","PRP");
		ValidationXML.equalIC(errors, RSAErrorEnum.T445, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration","classCode","SBADM");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T446, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > effectiveTime > low","value");
		ValidationXML.hasDateFormat(errors, RSAErrorEnum.T447, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > effectiveTime > high","value");
		ValidationXML.equalIC(errors, RSAErrorEnum.T448, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > routeCode","codeSystem","2.16.840.1.113883.5.112");
		ValidationXML.equalIC(errors, RSAErrorEnum.T449, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > approachSiteCode","codeSystem","2.16.840.1.113883.5.1052");
		ValidationXML.equalIC(errors, RSAErrorEnum.T458, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code","codeSystem","2.16.840.1.113883.6.73","2.16.840.1.113883.2.9.6.1.5","2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, RSAErrorEnum.T467, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > entryRelationship > supply","classCode","SPLY");
		ValidationXML.equalIC(errors, RSAErrorEnum.T468, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Consigliata'] > entry > substanceAdministration > entryRelationship > supply","moodCode","RQO");
		return errors;
	}


}
