package it.finanze.sanita.gva.validator;

import static it.finanze.sanita.gva.dto.XPathAndValuesDTO.buildPathValue;

import java.util.ArrayList;
import java.util.List;

import it.finanze.sanita.gva.dto.ErrorUCTDTO;
import it.finanze.sanita.gva.enums.RapErrorEnum;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class RapValidator extends DocumentTypeValidator {

    public static List<ErrorUCTDTO> validateUC1New(String xml){
        List<ErrorUCTDTO> errors = new ArrayList<>();

        ValidationXML.equalIC(errors, RapErrorEnum.T001, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T002, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T003, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.132");
        ValidationXML.equalIC(errors, RapErrorEnum.T004, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "code", "22636-5");
        ValidationXML.equalIC(errors, RapErrorEnum.T005, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T006, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T007, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "displayName", "Referto patologico anamnesi rilevante");
        ValidationXML.equalIC(errors, RapErrorEnum.T020, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T021, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T022, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.167");
        ValidationXML.equalIC(errors, RapErrorEnum.T023, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "code", "67803-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T024, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T025, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T026, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "displayName", "Procedura");
        ValidationXML.equalIC(errors, RapErrorEnum.T039, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T040, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T041, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T042, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.168");
        ValidationXML.equalIC(errors, RapErrorEnum.T043, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > value", "xsi:type", "CD", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T044, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T051, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura']", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T052, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.142");
        ValidationXML.equalIC(errors, RapErrorEnum.T053, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "code",	"29300-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T054, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T055, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T056, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "displayName",	"Procedure");
        ValidationXML.equalIC(errors, RapErrorEnum.T069, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure", "classCode",	"PROC");
        ValidationXML.equalIC(errors, RapErrorEnum.T070, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T071, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.143");
        ValidationXML.equalIC(errors, RapErrorEnum.T072, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "code", "81707-2", "85348-1", "85069-3", "8026-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T073, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T074, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T075, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "displayName", "Tecnica di dissezione", "Procedura utilizzata per ottenere un campione tumorale", "Metodo di test di laboratorio", "Colorazione");
        ValidationXML.equalIC(errors, RapErrorEnum.T076, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystem",	"2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T077, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystemName", "SNOMED");
        ValidationXML.equalIC(errors, RapErrorEnum.T078, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > targetSiteCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T080, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T081, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T082, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.259");
        ValidationXML.equalIC(errors, RapErrorEnum.T083, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply", "classCode", "SPLY");
        ValidationXML.equalIC(errors, RapErrorEnum.T084, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T085, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.251");
        ValidationXML.equalIC(errors, RapErrorEnum.T086, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "code",	"74384-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T087, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T088, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > statusCode", "code",	"completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T093, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T094, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T095, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T096, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystem", 	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T097, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T099, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > specimen > specimenRole", "classCode",	"SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T100, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T146, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "classCode",	"DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T147, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T148, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.176");
        ValidationXML.equalIC(errors, RapErrorEnum.T149, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "code",  "22637-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T150, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T151, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T152, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "displayName",	"Referto patologico.diagnosi finale");
        ValidationXML.equalIC(errors, RapErrorEnum.T165, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T166, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T167, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "code", "29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T168, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T169, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T170, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "displayName",	"Diagnosi");
        ValidationXML.equalIC(errors, RapErrorEnum.T171, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T172, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T173, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T174, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T175, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T176, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode",	"SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T177, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode",	"SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T178, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T179, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T180, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T181, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T182, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T183, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T184, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T185, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T186, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code",	"48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T187, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T188, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T189, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName",	"Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T190, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T191, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry", "typeCode", "COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T192, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T193, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T194, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "code", "29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T195, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T196, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T197, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "displayName", "Diagnosi");
        ValidationXML.equalIC(errors, RapErrorEnum.T198, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T200, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T201, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T202, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T203, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode",	"SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T204, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode",	"SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T205, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T206, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T207, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T208, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T209, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation",	"B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T210, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode",	"ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T211, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T212, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T213, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code",	"48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T214, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T215, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T216, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName",	"Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T217, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T218, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T219, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode",	"BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T220, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T221, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "code",	"29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T222, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T223, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T224, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "displayName",	"Diagnosi");
        ValidationXML.equalIC(errors, RapErrorEnum.T225, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T226, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T227, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T228, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T229, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T230, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode",	"SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T231, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode",	"SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T232, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T233, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T234, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T235, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T236, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation",	"B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T237, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode",	"ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T238, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T239, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T240, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code",	"48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T241, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T242, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T243, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName",	"Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T244, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T245, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T246, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T247, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T248, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T249, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "code", "29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T250, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T251, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T253, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T254, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T255, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T256, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.218");
        ValidationXML.equalIC(errors, RapErrorEnum.T257, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", "typeCode",	"COMP");
        ValidationXML.equalIC(errors, RapErrorEnum.T258, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T259, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T260, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.218");
        ValidationXML.equalIC(errors, RapErrorEnum.T261, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T262, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T263, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T264, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T265, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T266, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T267, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T268, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.218");
        ValidationXML.equalIC(errors, RapErrorEnum.T269, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > code", "code","42075-2");
        ValidationXML.equalIC(errors, RapErrorEnum.T270, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem",	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T271, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T272, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "classCode",	"OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T273, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T274, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.218");
        ValidationXML.equalIC(errors, RapErrorEnum.T275, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode",	"ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T276, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode",	"EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T277, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T278, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code",	"48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T279, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", 	"2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T280, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName",	"LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T281, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName",	"Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T282, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T283, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry", "typeCode",	"COMP");
        
        return errors;
    }
    
    public static List<ErrorUCTDTO> validateUC2New(String xml){
        List<ErrorUCTDTO> errors = new ArrayList<>();
 
        ValidationXML.equalIC(errors, RapErrorEnum.T286, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.132");
        ValidationXML.equalIC(errors, RapErrorEnum.T287, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "code", "22636-5");
        ValidationXML.equalIC(errors, RapErrorEnum.T288, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T289, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T290, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "displayName", "Referto patologico anamnesi rilevante");
        ValidationXML.equalIC(errors, RapErrorEnum.T293, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.167");
        ValidationXML.equalIC(errors, RapErrorEnum.T294, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "code", "67803-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T295, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T296, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T297, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "displayName", "Procedura");
        ValidationXML.equalIC(errors, RapErrorEnum.T300, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T301, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.168");
        ValidationXML.equalIC(errors, RapErrorEnum.T302, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > value", "xsi:type", "CD", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T306, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.142");
        ValidationXML.equalIC(errors, RapErrorEnum.T307, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "code", "29300-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T308, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T309, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T310, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "displayName", "Procedure");
        ValidationXML.equalIC(errors, RapErrorEnum.T312, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T313, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.143");
        ValidationXML.equalIC(errors, RapErrorEnum.T314, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "code", "81707-2", "85348-1", "85069-3", "8026-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T315, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T316, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystemName","LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T317, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T318, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystemName", "SNOMED");
        ValidationXML.equalIC(errors, RapErrorEnum.T321, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T322, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.259");
        ValidationXML.equalIC(errors, RapErrorEnum.T323, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T324, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.251");
        ValidationXML.equalIC(errors, RapErrorEnum.T325, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "code", "74384-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T326, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T327, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T330, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T331, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T332, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T333, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystemName","LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T334, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > specimen > specimenRole > templateId", "root",  "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T348, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.211");
        ValidationXML.equalIC(errors, RapErrorEnum.T349, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > code", "code", "85691-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T350, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T351, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T352, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > code", "displayName", "Risultato dell'autopsia Narrativa");
        ValidationXML.equalIC(errors, RapErrorEnum.T355, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T356, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T357, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Epicrisi'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T358, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.176");
        ValidationXML.equalIC(errors, RapErrorEnum.T359, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "code", "22637-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T360, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T361, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T362, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "displayName", "Referto patologico.diagnosi finale");
         

        return errors;
    }
    
    public static List<ErrorUCTDTO> validateUC3New(String xml){
        List<ErrorUCTDTO> errors = new ArrayList<>();

        ValidationXML.equalIC(errors, RapErrorEnum.T363, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T364, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T365, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.132");
        ValidationXML.equalIC(errors, RapErrorEnum.T366, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "code", "22636-5");
        ValidationXML.equalIC(errors, RapErrorEnum.T367, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T368, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T369, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "displayName", "Referto patologico anamnesi rilevante");
        ValidationXML.equalIC(errors, RapErrorEnum.T370, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T371, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T372, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T373, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.282");
        ValidationXML.equalIC(errors, RapErrorEnum.T374, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "code", "11329-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T375, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T376, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T377, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "displayName", "Anamnesi Generale");
        ValidationXML.equalIC(errors, RapErrorEnum.T378, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T379, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.135");
        ValidationXML.equalIC(errors, RapErrorEnum.T380, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "code", "75326-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T381, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T382, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T383, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "displayName", "Problem");
        ValidationXML.equalIC(errors, RapErrorEnum.T384, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T385, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > value", "xsi:type", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T386, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T387, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation", "", "2.16.840.1.113883.3.1937.777.63.10.136", false, buildPathValue(null, "moodCode", "EVN"),
                buildPathValue("code", "code", "89261-2"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Decorso Clinico"),
                buildPathValue("value", "xsi:type", "CD"), buildPathValue("value", "code", "LA18821-1", "LA28752-6"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.10"), buildPathValue("value", "codeSystemName", "ProblemCronicity"), buildPathValue("value", "displayName", "Acute", "Chronic"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T399, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation", "", "2.16.840.1.113883.3.1937.777.63.10.137", false,
                buildPathValue("code", "code", "33999-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Stato"),
                buildPathValue("value", "xsi:type", "CD"), buildPathValue("value", "code", "LA16666-2", "LA18632-2"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.7"), buildPathValue("value", "codeSystemName", "StatoClinicoProblema"), buildPathValue("value", "displayName", "Active", "Inactive"));
        ValidationXML.equalIC(errors, RapErrorEnum.T410, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, RapErrorEnum.T411, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T412, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.138");
        ValidationXML.equalIC(errors, RapErrorEnum.T413, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "code", "10157-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T414, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T415, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T416, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
        ValidationXML.equalIC(errors, RapErrorEnum.T417, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T418, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject", "typeCode", "SBJ");
        ValidationXML.equalIC(errors, RapErrorEnum.T419, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject", "contextControlCode", "OP");
        ValidationXML.equalIC(errors, RapErrorEnum.T420, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject", "classCode", "PRS");
        ValidationXML.equalIC(errors, RapErrorEnum.T421, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject > subject", "classCode", "PSN");
        ValidationXML.equalIC(errors, RapErrorEnum.T422, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T423, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.144");
        ValidationXML.equalIC(errors, RapErrorEnum.T424, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T425, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T426, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
        ValidationXML.equalIC(errors, RapErrorEnum.T427, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T428, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.145", false, buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "35267-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Età insorgenza"), buildPathValue("value", "xsi:type", "IVL_PQ"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T435, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.152", false, buildPathValue("observation", "moodCode", "EVN"),
            buildPathValue("code", "code", "39016-1"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("value", "xsi:type", "IVL_PQ"));
        ValidationXML.equalIC(errors, RapErrorEnum.T440, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.130");
        ValidationXML.equalIC(errors, RapErrorEnum.T441, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "code", "42349-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T442, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T443, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T444, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "displayName", "Motivo del consulto");
        ValidationXML.equalIC(errors, RapErrorEnum.T445, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T446, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T447, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.131");
        ValidationXML.equalIC(errors, RapErrorEnum.T448, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "code", "29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T449, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T450, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T451, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "displayName", "Diagnosi");
        ValidationXML.equalIC(errors, RapErrorEnum.T452, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > value", "xsi:type", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T453, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T454, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T455, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T456, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T457, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T458, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T459, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T460, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.155");
        ValidationXML.equalIC(errors, RapErrorEnum.T461, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "code", "48765-2");
        ValidationXML.equalIC(errors, RapErrorEnum.T462, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T463, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T464, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "displayName", "Allergie e/o reazioni avverse");
        ValidationXML.equalTAG(errors, RapErrorEnum.T465, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > title", "Allergie");
        ValidationXML.equalIC(errors, RapErrorEnum.T466, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T467, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > author > assignedAuthor > representedOrganization > asOrganizationPartOf", "classCode", "PART");
        ValidationXML.equalIC(errors, RapErrorEnum.T468, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T469, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T470, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.156");
        ValidationXML.equalIC(errors, RapErrorEnum.T471, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > code", "nullFlavor", "NA");
        ValidationXML.equalIC(errors, RapErrorEnum.T472, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship", "typeCode", "SUBJ");
        ValidationXML.equalIC(errors, RapErrorEnum.T473, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T474, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship", "> observation", "2.16.840.1.113883.3.1937.777.63.10.157", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "52473-6"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Allergia o causa della reazione"),
                buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "xsi:type", "CD"));
        ValidationXML.equalIC(errors, RapErrorEnum.T481, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant", "contextControlCode", "OP");
        ValidationXML.equalIC(errors, RapErrorEnum.T482, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole", "classCode", "MANU");
        ValidationXML.equalIC(errors, RapErrorEnum.T483, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "classCode",	"MMAT");
        ValidationXML.equalIC(errors, RapErrorEnum.T484, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "determinerCode", "INSTANCE");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T487, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.163", false, buildPathValue(null, "typeCode", "MFST"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "75321-0"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Obiettività Clinica"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T493, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.164", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "82606-5"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Allergy or intolerance criticality"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T500, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.165", false, buildPathValue(null, "typeCode", "REFR"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "33999-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Stato"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T509, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > act", "2.16.840.1.113883.3.1937.777.63.10.166", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue(null, "classCode", "ACT"), buildPathValue("act", "moodCode", "EVN"),
                buildPathValue("code", "code", "48767-8"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Annotazioni e commenti"), buildPathValue("statusCode", "code", "completed"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T515, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "", "2.16.840.1.113883.3.1937.777.63.10.279", false, buildPathValue("code", "code", "48767-8"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "codeSystemName", "2.16.840.1.113883.6.1"));
        ValidationXML.equalIC(errors, RapErrorEnum.T520, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T521, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T522, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.167");
        ValidationXML.equalIC(errors, RapErrorEnum.T523, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "code", "67803-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T524, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T525, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T526, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "displayName", "Procedura");
        ValidationXML.equalIC(errors, RapErrorEnum.T527, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T528, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T529, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.168");
        ValidationXML.equalIC(errors, RapErrorEnum.T530, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > value", "xsi:type", "CD", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T531, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T532, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T533, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T534, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T535, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T536, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T537, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T538, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.169");
        ValidationXML.equalIC(errors, RapErrorEnum.T539, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "code", "8677-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T540, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T541, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T542, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "displayName", "History of Medication use");
        ValidationXML.equalTAG(errors, RapErrorEnum.T543, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > title","Terapie farmacologiche pregresse");
        ValidationXML.equalIC(errors, RapErrorEnum.T544, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T545, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, RapErrorEnum.T546, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T547, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.170");
        ValidationXML.equalIC(errors, RapErrorEnum.T548, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable", "typeCode", "CSM");
        ValidationXML.equalIC(errors, RapErrorEnum.T549, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct", "classCode", "MANU");
        ValidationXML.equalIC(errors, RapErrorEnum.T560, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.171");
        ValidationXML.equalIC(errors, RapErrorEnum.T561, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "classCode", "MMAT");
        ValidationXML.equalIC(errors, RapErrorEnum.T562, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.172");
        ValidationXML.equalIC(errors, RapErrorEnum.T563, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T564, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T565, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T566, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T567, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T568, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.175");
        ValidationXML.equalIC(errors, RapErrorEnum.T569, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "code", "103567-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T570, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T571, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "codeSystemName", "LOINC");
        ValidationXML.equalTAG(errors, RapErrorEnum.T572, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > title", "Terapia Oncologica Pregressa");
        ValidationXML.equalIC(errors, RapErrorEnum.T573, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T574, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, RapErrorEnum.T575, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T576, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.170");
        ValidationXML.equalIC(errors, RapErrorEnum.T577, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable", "typeCode", "CSM");
        ValidationXML.equalIC(errors, RapErrorEnum.T581, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.171");
        ValidationXML.equalIC(errors, RapErrorEnum.T582, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.172");
        ValidationXML.equalIC(errors, RapErrorEnum.T583, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T584, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.183");
        ValidationXML.equalIC(errors, RapErrorEnum.T585, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T586, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T587, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T588, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T589, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T590, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T591, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T592, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.180");
        ValidationXML.equalIC(errors, RapErrorEnum.T593, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "code", "47519-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T594, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T605, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T606, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "displayName", "History of procedures");
        ValidationXML.equalIC(errors, RapErrorEnum.T607, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T608, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure", "classCode", "PROC");
        ValidationXML.equalIC(errors, RapErrorEnum.T609, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T610, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.183");
        ValidationXML.equalIC(errors, RapErrorEnum.T611, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T612, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T613, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T614, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T615, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T616, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.184");
        ValidationXML.equalIC(errors, RapErrorEnum.T617, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "code", "55114-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T618, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T619, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T620, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "displayName", "Prior imaging procedure descriptions");
        ValidationXML.equalIC(errors, RapErrorEnum.T621, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T622, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.186");
        ValidationXML.equalIC(errors, RapErrorEnum.T623, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > observation > value", "xsi:type", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T624, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T625, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T626, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T627, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T628, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T629, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.142");
        ValidationXML.equalIC(errors, RapErrorEnum.T630, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "code", "29300-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T631, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T632, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T633, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "displayName", "Procedure");
        ValidationXML.equalIC(errors, RapErrorEnum.T635, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T636, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.143");
        ValidationXML.equalIC(errors, RapErrorEnum.T637, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "code", "81707-2", "85348-1", "85069-3", "8026-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T638, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T639, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T640, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "displayName", "Tecnica di dissezione", "Procedura utilizzata per ottenere un campione tumorale", "Metodo di test di laboratorio", "Colorazione");
        ValidationXML.equalIC(errors, RapErrorEnum.T641, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T642, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystemName", "SNOMED");
        ValidationXML.equalIC(errors, RapErrorEnum.T643, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > targetSiteCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T644, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > approachSiteCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T645, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T646, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T647, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.259");
        ValidationXML.equalIC(errors, RapErrorEnum.T648, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T649, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.251");
        ValidationXML.equalIC(errors, RapErrorEnum.T650, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "code", "74384-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T651, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T652, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T653, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.257");
        ValidationXML.equalIC(errors, RapErrorEnum.T654, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T655, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T656, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T657, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T658, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystemName", "LOINC");
//        ValidationXML.equalIC(errors, RapErrorEnum.T660, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T661, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T662, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T663, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T664, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T665, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T666, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T667, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T668, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T669, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T670, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T671, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T672, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T673, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T674, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T675, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T676, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T677, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T678, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T679, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T680, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T681, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T682, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T683, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.149");
        ValidationXML.equalIC(errors, RapErrorEnum.T684, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "code", "22634-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T685, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T686, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T687, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "displayName", "Pathology report gross observation");
        ValidationXML.equalIC(errors, RapErrorEnum.T688, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T689, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T690, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T691, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T692, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T693, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T694, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T695, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T696, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T697, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T698, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T699, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T700, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T701, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T702, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T703, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T704, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T705, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T706, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T707, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T708, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T709, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T710, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T711, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T712, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T713, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T714, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T715, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T716, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T717, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T718, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.193");
        ValidationXML.equalIC(errors, RapErrorEnum.T719, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "code", "22635-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T720, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T721, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T722, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "displayName", "Referto patologico.osservazione microscopica");
        ValidationXML.equalIC(errors, RapErrorEnum.T723, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T724, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization", "determinerCode", "INSTANCE");
        ValidationXML.equalIC(errors, RapErrorEnum.T725, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization > asOrganizationPartOf", "classCode", "PART");
        ValidationXML.equalIC(errors, RapErrorEnum.T726, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T727, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T728, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "code", "102034-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T729, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T730, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T731, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "displayName", "Path report.microscopic observation");
        ValidationXML.equalIC(errors, RapErrorEnum.T732, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T733, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T735, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T736, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T737, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T738, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T739, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T740, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T741, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T742, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T743, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T744, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T745, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T746, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T747, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T748, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T749, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T750, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T751, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T752, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T753, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T754, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T755, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T756, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T757, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T758, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T759, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T760, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.190");
        ValidationXML.equalIC(errors, RapErrorEnum.T761, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > code", "code", "33755-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T762, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T766, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T767, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.196");
        ValidationXML.equalIC(errors, RapErrorEnum.T768, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "code", "33738-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T769, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T780, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T781, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > value", "xsi:type", "CE.IPS", "PQ", "IVL_PQ", "ST", "RTO_QTY_QTY");
        ValidationXML.equalIC(errors, RapErrorEnum.T782, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T783, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T784, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T785, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T786, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T787, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T788, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T789, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T790, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T791, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T792, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T793, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T794, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T795, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T796, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T797, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.176");
        ValidationXML.equalIC(errors, RapErrorEnum.T798, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "code", "22637-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T799, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T800, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T801, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "displayName", "Referto patologico.diagnosi finale");
        ValidationXML.equalIC(errors, RapErrorEnum.T802, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T803, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > author > assignedAuthor > representedOrganization", "determinerCode", "INSTANCE");
        ValidationXML.equalIC(errors, RapErrorEnum.T805, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T806, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T808, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T809, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T811, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T812, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T813, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T814, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T815, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T816, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T817, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T818, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T819, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T820, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T821, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T822, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T823, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T824, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T825, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T826, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T827, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T828, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T829, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T830, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T831, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T832, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.containsIC(errors, RapErrorEnum.T833, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "code", "22036-8", "29308-4", "22640-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T834, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T835, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.containsIC(errors, RapErrorEnum.T836, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "displayName", "Istologia:Osservazione", "Diagnosi", "Segno indicativo di stadio");
        ValidationXML.equalIC(errors, RapErrorEnum.T837, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T838, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T839, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T840, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T842, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T843, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T844, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T845, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T846, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T847, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T848, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T849, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T850, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T851, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T852, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T853, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T854, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T855, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T857, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T858, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T860, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");

//        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T861, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "", "2.16.840.1.113883.3.1937.777.63.10.150", false,
//                buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD"),
//                buildPathValue("specimen", "typeCode", "SPC"), buildPathValue("specimenRole", "classCode", "SPEC"), buildPathValue("specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174"),
//                buildPathValue("entryRelationship > observationMedia", "classCode", "OBS"), buildPathValue("entryRelationship > observationMedia", "moodCode", "EVN"), buildPathValue("entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209"),
//                buildPathValue("entryRelationship > observationMedia > value", "representation", "B64"), buildPathValue("act", "classCode", "ACT"), buildPathValue("act", "moodCode", "EVN"), buildPathValue("act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166"),
//                buildPathValue("act > code", "code", "48767-8"), buildPathValue("act > code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("act > code", "codeSystemName", "LOINC"), buildPathValue("act > code", "displayName", "Annotazioni e commenti"),
//                buildPathValue("act > statusCode", "code", "completed"), buildPathValue(null, "moodCode", "EVN"), buildPathValue("statusCode", "code", "completed", "aborted", "suspended", "active"));

        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T892, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "", "2.16.840.1.113883.3.1937.777.63.10.217", false,
                buildPathValue("code", "code", "59541-3"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"),
                buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Grado del sistema patologico"),
                buildPathValue("value", "xsi:type", "ST", "CD"));

        ValidationXML.checkNestedSections(errors, RapErrorEnum.T893, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation","2.16.840.1.113883.3.1937.777.63.10.217", "entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.218",
                buildPathValue(null, "typeCode", "COMP"), buildPathValue("entryRelationship > observation", "moodCode", "EVN"));

        ValidationXML.checkNestedSections(errors, RapErrorEnum.T894, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation","2.16.840.1.113883.3.1937.777.63.10.217", "entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.222",
                buildPathValue(null, "typeCode", "COMP"), buildPathValue("entryRelationship > observation", "moodCode", "EVN"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T905, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "", "2.16.840.1.113883.3.1937.777.63.10.226", false,
                buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "TS", "PQ"),
                buildPathValue("entryRelationship > observation", "moodCode", "EVN"),
                buildPathValue("act", "classCode", "ACT"), buildPathValue("act", "moodCode", "EVN"), buildPathValue("act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166"),
                buildPathValue("act > code", "code", "48767-8"), buildPathValue("act > code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("act > code", "codeSystemName", "LOINC"), buildPathValue("act > code", "displayName", "Annotazioni e commenti"),
                buildPathValue("act > statusCode", "code", "completed"), buildPathValue(null, "moodCode", "EVN"), buildPathValue("entryRelationship > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.214"),
                buildPathValue("entryRelationship > observation > code", "code", "85351-5"), buildPathValue("entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("entryRelationship > observation > code", "codeSystemName", "LOINC"),
                buildPathValue("entryRelationship > observation", "moodCode", "EVN"), buildPathValue("entryRelationship > act", "classCode", "ACT"), buildPathValue("entryRelationship > act", "moodCode", "EVN"),
                buildPathValue("entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166"),
                buildPathValue("entryRelationship > act > code", "code", "48767-8"), buildPathValue("entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1"),
                buildPathValue("entryRelationship > act > code", "codeSystemName", "LOINC"), buildPathValue("entryRelationship > act > code", "displayName", "Annotazioni e commenti"),
                buildPathValue("entryRelationship > act > statusCode", "code", "completed"));

        ValidationXML.equalIC(errors, RapErrorEnum.T916, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > value", "xsi:type", "CD", "PQ", "IVL_PQ" , "ST", "TS" , "RTO_QTY_QTY");
        ValidationXML.containsIC(errors, RapErrorEnum.T917, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T918, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T919, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T920, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T921, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T925, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T926, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T927, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T928, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T929, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "displayName", "Annotazioni e Commenti");

        return errors;
    }

    public static List<ErrorUCTDTO> validateUC24New(String xml){
        List<ErrorUCTDTO> errors = new ArrayList<>();

        ValidationXML.equalIC(errors, RapErrorEnum.T930, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T931, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T932, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.132");
        ValidationXML.equalIC(errors, RapErrorEnum.T933, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "code", "22636-5");
        ValidationXML.equalIC(errors, RapErrorEnum.T934, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T935, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T936, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > code", "displayName", "Referto patologico anamnesi rilevante");
        ValidationXML.equalIC(errors, RapErrorEnum.T937, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T938, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T939, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T940, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.282");
        ValidationXML.equalIC(errors, RapErrorEnum.T941, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "code", "11329-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T942, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T943, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T944, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > code", "displayName", "Anamnesi Generale");
        ValidationXML.equalIC(errors, RapErrorEnum.T945, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T946, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.135");
        ValidationXML.equalIC(errors, RapErrorEnum.T947, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "code", "75326-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T948, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T949, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T950, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > code", "displayName", "Problem");
        ValidationXML.equalIC(errors, RapErrorEnum.T951, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T952, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > value", "xsi:type", "CD");

        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T953, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation", "", "2.16.840.1.113883.3.1937.777.63.10.136", false, buildPathValue(null, "moodCode", "EVN"),
                buildPathValue("code", "code", "89261-2"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Decorso Clinico"),
                buildPathValue("value", "xsi:type", "CD"), buildPathValue("value", "code", "LA18821-1", "LA28752-6"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.10"), buildPathValue("value", "codeSystemName", "ProblemCronicity"), buildPathValue("value", "displayName", "Acute", "Chronic"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T965, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation", "", "2.16.840.1.113883.3.1937.777.63.10.137", false,
                buildPathValue("code", "code", "33999-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Stato"),
                buildPathValue("value", "xsi:type", "CD"), buildPathValue("value", "code", "LA16666-2", "LA18632-2"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.77.22.11.7"), buildPathValue("value", "codeSystemName", "StatoClinicoProblema"), buildPathValue("value", "displayName", "Active", "Inactive"));
        ValidationXML.equalIC(errors, RapErrorEnum.T975, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, RapErrorEnum.T976, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T977, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.138");
        ValidationXML.equalIC(errors, RapErrorEnum.T978, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "code", "10157-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T979, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T980, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T981, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
        ValidationXML.equalIC(errors, RapErrorEnum.T982, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T983, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject", "typeCode", "SBJ");
        ValidationXML.equalIC(errors, RapErrorEnum.T984, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject", "contextControlCode", "OP");
        ValidationXML.equalIC(errors, RapErrorEnum.T985, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject", "classCode", "PRS");
        ValidationXML.equalIC(errors, RapErrorEnum.T986, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject > subject", "classCode", "PSN");
        ValidationXML.equalIC(errors, RapErrorEnum.T987, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T988, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.144");
        ValidationXML.equalIC(errors, RapErrorEnum.T989, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T990, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T991, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");

        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T992, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.145", false, buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "35267-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Età insorgenza"), buildPathValue("value", "xsi:type", "IVL_PQ"));
        ValidationXML.equalIC(errors, RapErrorEnum.T1006, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.130");
        ValidationXML.equalIC(errors, RapErrorEnum.T1007, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "code", "42349-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1008, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1009, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1010, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > code", "displayName", "Motivo del consulto");
        ValidationXML.equalIC(errors, RapErrorEnum.T1011, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1012, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1013, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.131");
        ValidationXML.equalIC(errors, RapErrorEnum.T1014, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "code", "29308-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T1015, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1016, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1017, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > code", "displayName", "Diagnosi");
        ValidationXML.equalIC(errors, RapErrorEnum.T1018, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > value", "xsi:type", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T1019, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1020, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1021, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1022, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1023, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1024, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1025, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1026, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.155");
        ValidationXML.equalIC(errors, RapErrorEnum.T1027, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "code", "48765-2");
        ValidationXML.equalIC(errors, RapErrorEnum.T1028, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1029, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1030, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > code", "displayName", "Allergie e/o reazioni avverse");
        ValidationXML.equalTAG(errors, RapErrorEnum.T1031, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > title", "Allergie");
        ValidationXML.equalIC(errors, RapErrorEnum.T1032, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1033, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > author > assignedAuthor > representedOrganization > asOrganizationPartOf", "classCode", "PART");


        ValidationXML.equalIC(errors, RapErrorEnum.T1034, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1035, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1036, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.156");
        ValidationXML.equalIC(errors, RapErrorEnum.T1037, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > code", "nullFlavor", "NA");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1038, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship", "> observation", "2.16.840.1.113883.3.1937.777.63.10.157", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "52473-6"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Allergia o causa della reazione"),
                buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "xsi:type", "CD"));
        ValidationXML.equalIC(errors, RapErrorEnum.T1047, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant", "contextControlCode", "OP");
        ValidationXML.equalIC(errors, RapErrorEnum.T1048, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole", "classCode", "MANU");
        ValidationXML.equalIC(errors, RapErrorEnum.T1049, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "classCode","MMAT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1050, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > participant > participantRole > playingEntity", "determinerCode", "INSTANCE");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1051, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.163", false, buildPathValue(null, "typeCode", "MFST"),
                buildPathValue("code", "code", "75321-0"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Obiettività Clinica"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1058, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.164", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "82606-5"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Allergy or intolerance criticality"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1065, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.165", false, buildPathValue(null, "typeCode", "REFR"), buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("code", "code", "33999-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Stato"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1072, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", " > act", "2.16.840.1.113883.3.1937.777.63.10.166", false, buildPathValue(null, "typeCode", "SUBJ"), buildPathValue(null, "classCode", "ACT"), buildPathValue("act", "moodCode", "EVN"),
                buildPathValue("code", "code", "48767-8"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Annotazioni e commenti"), buildPathValue("statusCode", "code", "completed"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1081, xml,"ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Allergie'] > entry > act", "", "2.16.840.1.113883.3.1937.777.63.10.279", false, buildPathValue("code", "code", "48767-8"),
                buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "codeSystemName", "2.16.840.1.113883.6.1"));
        ValidationXML.equalIC(errors, RapErrorEnum.T1086, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1087, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1088, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.167");
        ValidationXML.equalIC(errors, RapErrorEnum.T1089, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "code", "67803-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T1090, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1091, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1092, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > code", "displayName", "Procedura");
        ValidationXML.equalIC(errors, RapErrorEnum.T1093, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1094, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1095, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.168");
        ValidationXML.equalIC(errors, RapErrorEnum.T1096, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > observation > value", "xsi:type", "CD", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T1097, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1098, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1099, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1100, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1101, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_Esami_Eseguiti'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1102, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1103, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1104, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.169");
        ValidationXML.equalIC(errors, RapErrorEnum.T1105, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "code", "8677-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T1106, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1107, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1108, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > code", "displayName", "History of Medication use");
        ValidationXML.equalTAG(errors, RapErrorEnum.T1109, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > title", "Terapie farmacologiche pregresse");
        ValidationXML.equalIC(errors, RapErrorEnum.T1110, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1111, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, RapErrorEnum.T1112, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1113, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.170");
        ValidationXML.equalIC(errors, RapErrorEnum.T1114, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable", "typeCode", "CSM");
        ValidationXML.equalIC(errors, RapErrorEnum.T1115, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct", "classCode", "MANU");
        ValidationXML.equalIC(errors, RapErrorEnum.T1116, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.171");
        ValidationXML.equalIC(errors, RapErrorEnum.T1117, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial", "classCode", "MMAT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1118, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.172");
        ValidationXML.equalIC(errors, RapErrorEnum.T1119, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1120, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1121, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1122, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1123, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Terapie_Farmacologiche_Pregresse'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1124, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.175");
        ValidationXML.equalIC(errors, RapErrorEnum.T1125, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "code", "103567-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T1126, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1127, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > code", "codeSystemName", "LOINC");
        ValidationXML.equalTAG(errors, RapErrorEnum.T1128, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > title", "Terapia Oncologica Pregressa");
        ValidationXML.equalIC(errors, RapErrorEnum.T1129, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1130, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, RapErrorEnum.T1131, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1132, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.170");
        ValidationXML.equalIC(errors, RapErrorEnum.T1133, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable", "typeCode", "CSM");
        ValidationXML.equalIC(errors, RapErrorEnum.T1134, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.171");
        ValidationXML.equalIC(errors, RapErrorEnum.T1135, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.172");
        ValidationXML.equalIC(errors, RapErrorEnum.T1136, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1137, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.183");
        ValidationXML.equalIC(errors, RapErrorEnum.T1138, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1139, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1140, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1141, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1142, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID=Terapia_Oncologica_Pregressa] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1143, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1144, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1145, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.180");
        ValidationXML.equalIC(errors, RapErrorEnum.T1146, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "code", "47519-4");
        ValidationXML.equalIC(errors, RapErrorEnum.T1147, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1148, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1149, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > code", "displayName", "History of procedures");
        ValidationXML.equalIC(errors, RapErrorEnum.T1150, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1151, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure", "classCode", "PROC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1152, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1153, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.183");
        ValidationXML.equalIC(errors, RapErrorEnum.T1154, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1155, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1156, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1157, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1158, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Precedenti_trattamenti_e_procedure_chirurgiche_e_diagnostiche_pregresse'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1159, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.184");
        ValidationXML.equalIC(errors, RapErrorEnum.T1160, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "code", "55114-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T1161, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1162, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1163, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > code", "displayName", "Prior imaging procedure descriptions");
        ValidationXML.equalIC(errors, RapErrorEnum.T1164, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1165, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.186");
        ValidationXML.equalIC(errors, RapErrorEnum.T1166, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > observation > value", "xsi:type", "ST");
        ValidationXML.equalIC(errors, RapErrorEnum.T1167, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1168, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1169, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1170, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1171, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Indagini_Radiologiche'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1172, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.142");
        ValidationXML.equalIC(errors, RapErrorEnum.T1173, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "code", "29300-1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1174, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1175, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1176, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > code", "displayName", "Procedure");
        ValidationXML.equalIC(errors, RapErrorEnum.T1178, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1179, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.143");
        ValidationXML.equalIC(errors, RapErrorEnum.T1180, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "code", "81707-2", "85348-1", "85069-3", "8026-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T1181, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1182, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1183, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > code", "displayName", "Tecnica di dissezione", "Procedura utilizzata per ottenere un campione tumorale", "Metodo di test di laboratorio", "Colorazione");
        ValidationXML.equalIC(errors, RapErrorEnum.T1184, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T1185, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > methodCode", "codeSystemName", "SNOMED");
        ValidationXML.equalIC(errors, RapErrorEnum.T1186, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > targetSiteCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T1187, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > approachSiteCode", "codeSystem", "2.16.840.1.113883.6.96");
        ValidationXML.equalIC(errors, RapErrorEnum.T1188, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1189, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1190, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.259");
        ValidationXML.equalIC(errors, RapErrorEnum.T1191, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1192, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.251");
        ValidationXML.equalIC(errors, RapErrorEnum.T1193, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "code", "74384-9");
        ValidationXML.equalIC(errors, RapErrorEnum.T1194, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1195, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > supply > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1196, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.257");
        ValidationXML.equalIC(errors, RapErrorEnum.T1197, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1198, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1199, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1200, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1201, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1202, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > value", "xsi:type", "ST","RTO_QTY_QTY","IVL_PQ","INT","CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T1203, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1204, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T1205, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1206, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1207, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1208, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1209, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1210, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1211, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1212, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1213, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1214, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1215, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1216, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1217, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1218, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1219, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1220, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1221, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1222, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1223, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1224, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1225, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.149");
        ValidationXML.equalIC(errors, RapErrorEnum.T1226, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "code", "22634-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T1227, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1228, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1229, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > code", "displayName", "Pathology report gross observation");
        ValidationXML.equalIC(errors, RapErrorEnum.T1230, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1231, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1232, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1233, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1234, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1235, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1236, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1237, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1238, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1239, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1240, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T1241, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1242, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1243, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1244, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1245, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1246, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1247, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1248, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1249, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1250, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1251, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1252, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1253, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1254, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1255, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1256, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1257, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1258, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1259, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.193");
        ValidationXML.equalIC(errors, RapErrorEnum.T1260, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "code", "22635-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T1261, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1262, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1263, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > code", "displayName", "Referto patologico.osservazione microscopica");
        ValidationXML.equalIC(errors, RapErrorEnum.T1264, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization", "classCode", "ORG");
        ValidationXML.equalIC(errors, RapErrorEnum.T1265, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization", "determinerCode", "INSTANCE");
        ValidationXML.equalIC(errors, RapErrorEnum.T1266, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > author > assignedAuthor > representedOrganization > asOrganizationPartOf", "classCode", "PART");
        ValidationXML.equalIC(errors, RapErrorEnum.T1267, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1268, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1269, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "code", "102034-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T1270, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1271, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1272, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > code", "displayName", "Path report.microscopic observation");
        ValidationXML.equalIC(errors, RapErrorEnum.T1273, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1274, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1275, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1276, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1277, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1278, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1279, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1280, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T1281, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1282, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1283, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1284, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1285, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1286, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1287, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1288, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1289, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1290, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1291, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1292, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1293, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1294, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1295, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1296, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Microscopica'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1297, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1298, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1299, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.190");
        ValidationXML.equalIC(errors, RapErrorEnum.T1300, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > code", "code", "33755-0");
        ValidationXML.equalIC(errors, RapErrorEnum.T1301, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1305, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1306, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.196");
        ValidationXML.equalIC(errors, RapErrorEnum.T1307, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "code", "33738-6");
        ValidationXML.equalIC(errors, RapErrorEnum.T1308, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1309, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1310, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > value", "xsi:type", "CE.IPS", "PQ", "IVL_PQ", "ST", "RTO_QTY_QTY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1311, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1312, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1313, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1314, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1315, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1316, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1317, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1318, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1319, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1320, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1321, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1322, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1323, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Stato_del_Margine'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1324, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1325, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi']", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1326, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.176");
        ValidationXML.equalIC(errors, RapErrorEnum.T1327, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "code", "22637-3");
        ValidationXML.equalIC(errors, RapErrorEnum.T1328, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1329, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1330, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > code", "displayName", "Referto patologico.diagnosi finale");
        ValidationXML.equalIC(errors, RapErrorEnum.T1334, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1335, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1337, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1338, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1340, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1341, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1342, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1343, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1344, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T1345, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1346, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1347, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1348, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T1349, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1350, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1351, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1352, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1353, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1354, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1355, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1356, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1357, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1358, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1359, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1360, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1361, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.containsIC(errors, RapErrorEnum.T1362, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "code", "22036-8", "29308-4", "22640-7");
        ValidationXML.equalIC(errors, RapErrorEnum.T1363, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1364, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.containsIC(errors, RapErrorEnum.T1365, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "displayName", "Istologia:Osservazione", "Diagnosi", "Segno indicativo di stadio");
        ValidationXML.equalIC(errors, RapErrorEnum.T1366, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1367, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1368, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1369, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1370, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T1371, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1372, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1373, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1374, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1375, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1376, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1377, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1378, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1379, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1380, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1381, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1382, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, RapErrorEnum.T1383, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1385, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1386, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1388, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1389, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.150");
        ValidationXML.equalIC(errors, RapErrorEnum.T1390, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1391, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1392, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > value", "xsi:type", "ST", "RTO_QTY_QTY", "IVL_PQ", "INT", "CD");
        ValidationXML.equalIC(errors, RapErrorEnum.T1393, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen", "typeCode", "SPC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1394, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole", "classCode", "SPEC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1395, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > specimen > specimenRole > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.174");
        ValidationXML.equalIC(errors, RapErrorEnum.T1396, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "classCode", "OBS");
        ValidationXML.equalIC(errors, RapErrorEnum.T1397, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1398, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.209");
        ValidationXML.equalIC(errors, RapErrorEnum.T1399, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observationMedia > value", "representation", "B64");
        ValidationXML.equalIC(errors, RapErrorEnum.T1400, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1401, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1402, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1403, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1404, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1405, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1406, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1407, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1408, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "moodCode", "EVN");

        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1409, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "", "2.16.840.1.113883.3.1937.777.63.10.217", false,
                buildPathValue("code", "code", "59541-3"), buildPathValue("code", "", ""), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Grado del sistema patologico"),
                buildPathValue("value", "xsi:type", "CD", "ST"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1415, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.218", buildPathValue(null, "typeCode", "COMP"), buildPathValue("observation", "moodCode", "EVN"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1418, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.222", buildPathValue(null, "typeCode", "COMP"), buildPathValue("observation", "moodCode", "EVN"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1421, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation", "", "2.16.840.1.113883.3.1937.777.63.10.226", buildPathValue(null, "moodCode", "EVN"),
                buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1424, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.222", buildPathValue(null, "typeCode", "COMP"), buildPathValue("observation", "moodCode", "EVN"));
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1425, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.214", buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "85351-5"),
                buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"));
        ValidationXML.equalIC(errors, RapErrorEnum.T1427, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Notizie_Cliniche'] > component > section[ID='Quesito_Diagnostico'] > entry > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T1428, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Procedura'] > entry > procedure > entryRelationship > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T1429, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Osservazione_Macroscopica'] > entry > organizer > component > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T1430, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > observation > statusCode", "code", "aborted", "active", "completed", "suspended");
        ValidationXML.checkSectionByTemplateId(errors, RapErrorEnum.T1431, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship", " > observation", "2.16.840.1.113883.3.1937.777.63.10.216", buildPathValue("observation", "moodCode", "EVN"),
                buildPathValue("value", "xsi:type", "PQ", "IVL_PQ", "ST", "TS", "RTO_QTY_QTY", "CD"));
        ValidationXML.equalIC(errors, RapErrorEnum.T1433, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > statusCode", "code", "active", "completed", "suspended");
        ValidationXML.equalIC(errors, RapErrorEnum.T1433, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, RapErrorEnum.T1434, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, RapErrorEnum.T1435, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.166");
        ValidationXML.equalIC(errors, RapErrorEnum.T1436, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1437, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1438, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1439, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > code", "displayName", "Annotazioni e commenti");
        ValidationXML.equalIC(errors, RapErrorEnum.T1440, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > organizer > component > observation > entryRelationship > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, RapErrorEnum.T1441, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > templateId", "root", "2.16.840.1.113883.3.1937.777.63.10.279");
        ValidationXML.equalIC(errors, RapErrorEnum.T1442, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, RapErrorEnum.T1443, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, RapErrorEnum.T1444, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, RapErrorEnum.T1445, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Diagnosi'] > entry > act > code", "displayName", "Annotazioni e Commenti");
        
        return errors;
    }
  
}
