package it.finanze.sanita.gva.validator;

import static it.finanze.sanita.gva.dto.XPathAndValuesDTO.buildPathValue;

import java.util.ArrayList;
import java.util.List;

import it.finanze.sanita.gva.dto.ErrorUCTDTO;
import it.finanze.sanita.gva.dto.SectionCriteriaDTO;
import it.finanze.sanita.gva.enums.VPSErrorEnum;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class VPSValidator extends DocumentTypeValidator {

    public static List<ErrorUCTDTO> validateUC30(String xml){
        List<ErrorUCTDTO> errors = new ArrayList<>();

        ValidationXML.equalIC(errors, VPSErrorEnum.T000, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T001, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T002, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.20");
        ValidationXML.equalIC(errors, VPSErrorEnum.T003, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "code", "11459-5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T004, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T005, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T006, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "displayName", "Modalità di Trasporto");
        ValidationXML.equalIC(errors, VPSErrorEnum.T007, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act", "classCode", "TRNS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T008, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T009, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.40");
        ValidationXML.equalIC(errors, VPSErrorEnum.T010, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T011, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > code", "codeSystemName", "ModalitàTrasporto_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T012, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T013, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant", "typeCode", "REFB");
        ValidationXML.equalIC(errors, VPSErrorEnum.T014, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T015, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant > participantRole > code", "codeSystemName", "ResponsabileInvio_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T016, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T017, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T018, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.42");
        ValidationXML.equalIC(errors, VPSErrorEnum.T019, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "code", "46239-0");
        ValidationXML.equalIC(errors, VPSErrorEnum.T020, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T021, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T022, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "displayName", "Motivo della Visita");
        ValidationXML.equalIC(errors, VPSErrorEnum.T023, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", "typeCode", "COMP");
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T025, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", " > observation", "2.16.840.1.113883.2.9.10.1.6.37", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "56817-0"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.2"));
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T026, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", " > observation", "2.16.840.1.113883.2.9.10.1.6.87", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "29298-7"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"));
        ValidationXML.equalIC(errors, VPSErrorEnum.T030, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.21");
        ValidationXML.equalIC(errors, VPSErrorEnum.T031, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "code", "54094-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T032, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T033, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T034, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T035, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.39");
        ValidationXML.equalIC(errors, VPSErrorEnum.T036, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "code", "11283-9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T037, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T038, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T039, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "displayName", "Valutazione Acutezza");
        ValidationXML.equalIC(errors, VPSErrorEnum.T040, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T041, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T042, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > value", "codeSystemName", "CodiceTriage_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T043, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > performer", "typeCode", "PRF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T044, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > performer > assignedEntity > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T045, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T046, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T047, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.56");
        ValidationXML.equalIC(errors, VPSErrorEnum.T048, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "code", "78337-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T049, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T050, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T051, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "displayName", "Inquadramento clinico iniziale");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T052, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > title", "Inquadramento clinico iniziale");
        ValidationXML.equalIC(errors, VPSErrorEnum.T053, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T054, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T055, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.55");
        ValidationXML.equalIC(errors, VPSErrorEnum.T056, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "code", "11329-0");
        ValidationXML.equalIC(errors, VPSErrorEnum.T057, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T058, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T059, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "displayName", "Anamnesi Generale");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T060, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > title", "Anamnesi");
        ValidationXML.equalIC(errors, VPSErrorEnum.T061, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T062, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T063, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "code", "75326-9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T064, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T065, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T066, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "displayName", "Problem");
        ValidationXML.equalIC(errors, VPSErrorEnum.T067, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T072, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, VPSErrorEnum.T073, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T074, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "code", "10157-6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T075, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T076, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T077, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject", "classcode", "PRS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T078, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T079, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "AdministrativeGender");
        ValidationXML.equalIC(errors, VPSErrorEnum.T090, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T091, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T092, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T093, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
        ValidationXML.equalIC(errors, VPSErrorEnum.T094, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > value", "codeSystemName", "ICD9-CM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T095, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T096, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T097, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T098, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T099, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T100, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.58");
        ValidationXML.equalIC(errors, VPSErrorEnum.T101, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "code",  "29545-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T102, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "codeSystem",  "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T103, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T104, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "displayName",  "Esame Obiettivo");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T105, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > title", "Esame Obiettivo");
        ValidationXML.equalIC(errors, VPSErrorEnum.T106, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T107, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T108, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T109, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T110, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.57");
        ValidationXML.equalIC(errors, VPSErrorEnum.T111, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "code", "42346-7");
        ValidationXML.equalIC(errors, VPSErrorEnum.T112, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T113, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T114, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "displayName", "Medications on admission (narrative)");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T115, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > title", "Terapia farmacologica all’ingresso");
        ValidationXML.equalIC(errors, VPSErrorEnum.T116, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > author > assignedAuthor > id", "root",  "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T117, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > author > assignedAuthor > id", "assigningAuthorityName",  "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T118, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T119, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T120, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.50");
        ValidationXML.equalIC(errors, VPSErrorEnum.T121, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "code", "46240-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T122, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T123, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T124, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "displayName", "History of Hospitalizations + Outpatient Visits Narrative");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T125, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > title", "Fasi dell’episodio di Pronto Soccorso");
        ValidationXML.equalIC(errors, VPSErrorEnum.T126, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter", "classcode", "ENC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T127, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T128, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.51");
        ValidationXML.equalIC(errors, VPSErrorEnum.T129, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > participant", "typeCode", "LOC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T133, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
        ValidationXML.equalIC(errors, VPSErrorEnum.T137, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship", "typeCode",  "SUBJ");
        ValidationXML.equalIC(errors, VPSErrorEnum.T138, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act", "classCode",  "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T139, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act", "moodCode",  "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T140, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > templateId", "root",  "2.16.840.1.113883.2.9.10.1.6.47");
        ValidationXML.equalIC(errors, VPSErrorEnum.T141, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T142, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T143, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "displayName", "Annotation Comment");
        ValidationXML.equalIC(errors, VPSErrorEnum.T144, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T145, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T146, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.23");
        ValidationXML.equalIC(errors, VPSErrorEnum.T147, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "code", "8648-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T148, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T149, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T150, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "displayName", "Decorso Ospedaliero");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T151, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > title", "Decorso Ospedaliero");
        ValidationXML.equalIC(errors, VPSErrorEnum.T152, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T153, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T154, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.26");
        ValidationXML.equalIC(errors, VPSErrorEnum.T155, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "code", "62387-6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T156, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T157, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T158, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "displayName", "Procedure ed Interventi");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T159, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > title", "Interventi Prestazioni Consulenze");
        ValidationXML.equalIC(errors, VPSErrorEnum.T160, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T161, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act", "moodCode", "EVN", "RQO");
        ValidationXML.equalIC(errors, VPSErrorEnum.T162, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
        ValidationXML.equalIC(errors, VPSErrorEnum.T163, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > statusCode", "code", "Completed", "Aborted");
        ValidationXML.equalIC(errors, VPSErrorEnum.T164, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T165, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T166, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T167, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.27");
        ValidationXML.equalIC(errors, VPSErrorEnum.T168, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "code", "30954-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T169, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T170, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T171, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "displayName", "Relevant diagnostic tests/laboratory data");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T172, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > title", "Accertamenti");
        ValidationXML.equalIC(errors, VPSErrorEnum.T173, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, VPSErrorEnum.T174, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T175, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.45");
        ValidationXML.equalIC(errors, VPSErrorEnum.T176, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T177, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T178, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation", "classCode", "OBS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T179, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T180, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.46");
        ValidationXML.equalIC(errors, VPSErrorEnum.T181, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T182, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T184, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T185, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.28");
        ValidationXML.equalIC(errors, VPSErrorEnum.T186, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "code", "8716-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T187, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T188, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T189, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "displayName", "Parametri vitali");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T190, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > title", "Parametri vitali");
        ValidationXML.equalIC(errors, VPSErrorEnum.T191, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, VPSErrorEnum.T192, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T193, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.90");
        ValidationXML.equalIC(errors, VPSErrorEnum.T194, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "code", "85353-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T195, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T196, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T197, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "displayName", "Vital signs, weight, height, head circumference, oxygen saturation and BMI");
        ValidationXML.equalIC(errors, VPSErrorEnum.T198, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T200, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.91");
        ValidationXML.equalIC(errors, VPSErrorEnum.T201, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T202, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T203, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T204, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T205, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T206, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T207, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.29");
        ValidationXML.equalIC(errors, VPSErrorEnum.T208, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "code", "29549-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T209, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T210, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T211, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "displayName", "Medication administered Narrative");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T212, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > title", "Terapia Farmacologica Effettuata in Pronto Soccorso");
        ValidationXML.equalIC(errors, VPSErrorEnum.T213, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T214, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T215, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
        ValidationXML.equalIC(errors, VPSErrorEnum.T216, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > statusCode", "code",  "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T217, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
        ValidationXML.equalIC(errors, VPSErrorEnum.T218, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.6.73");
        ValidationXML.equalIC(errors, VPSErrorEnum.T219, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T222, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T223, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T224, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.24");
        ValidationXML.equalIC(errors, VPSErrorEnum.T225, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "code", "28574-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T226, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T227, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T228, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "displayName", "Note di Dimissione");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T229, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > title", "Dimissione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T230, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T231, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T232, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66");
        ValidationXML.equalIC(errors, VPSErrorEnum.T233, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > code", "codeSystem",  "2.16.840.1.113883.2.9.5.1.4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T234, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T235, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > performer > assignedEntity", "classCode", "ASSIGNED");
        ValidationXML.equalIC(errors, VPSErrorEnum.T236, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter", "classCode", "ENC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T237, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.67");
        ValidationXML.equalIC(errors, VPSErrorEnum.T238, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > code", "code", "IMP");
        ValidationXML.equalIC(errors, VPSErrorEnum.T239, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T240, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > code", "codeSystemName", "TipoEncounterPostDimissione_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T241, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > participant", "typeCode", "LOC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T242, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > participant > participantRole", "classCode", "SDLOC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T243, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
        ValidationXML.equalIC(errors, VPSErrorEnum.T244, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.11");
        ValidationXML.equalIC(errors, VPSErrorEnum.T245, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > participant > participantRole > code", "codeSystemName", "TipoLuogoPostDimissione_VPS");
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T246, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > encounter > entryRelationship",  " > observation", "2.16.840.1.113883.2.9.10.1.6.68", false, buildPathValue(null, "typeCode", "RSON"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.13"), buildPathValue("code", "codeSystemName", "ProblemType_VPS"), buildPathValue("statusCode", "code", "completed"));
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T247, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship", " > observation", "2.16.840.1.113883.2.9.10.1.6.70", false, buildPathValue("observation", "classCode", "OBS"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "29308-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Diagnosi"), buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.6.103"), buildPathValue("value", "codeSystemName", "ICD9-CM"));
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T248, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship", " > observation", "2.16.840.1.113883.2.9.10.1.6.69", false, buildPathValue("observation", "classCode", "OBS"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "11302-7"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Esito"), buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.5"), buildPathValue("value", "codeSystemName", "EsitoTrattamento_VPS"));
        ValidationXML.containsSection(errors, VPSErrorEnum.T249, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry", " > observation",
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.66", buildPathValue("code", "code","75328-5"), buildPathValue("code", "displayName", "Prognosi"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("observation", "classCode", "OBS")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.72", buildPathValue("code", "code","11283-9"), buildPathValue("code", "displayName", "Valutazione Acutezza"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("observation", "classCode", "OBS")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.86", buildPathValue("code", "code","31211-6"), buildPathValue("code", "displayName", "Date of death"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("observation", "classCode", "OBS")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.73", buildPathValue("code", "code","45477-7"), buildPathValue("code", "displayName", "Advance directive-autopsy request"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN"), buildPathValue("observation", "classCode", "OBS")));
        ValidationXML.equalIC(errors, VPSErrorEnum.T250, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T251, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T252, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T253, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T254, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T255, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.34");
        ValidationXML.equalIC(errors, VPSErrorEnum.T256, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "code", "18776-5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T257, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T258, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T259, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "displayName", "Piano di Cura");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T260, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > title", "Piano di Cura");
        ValidationXML.equalIC(errors, VPSErrorEnum.T261, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T262, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T263, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T264, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act", "moodCode", "INT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T265, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
        ValidationXML.equalIC(errors, VPSErrorEnum.T266, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > statusCode", "code", "active");
        ValidationXML.equalIC(errors, VPSErrorEnum.T267, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference", "typeCode", "REFR");
        ValidationXML.equalIC(errors, VPSErrorEnum.T268, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T269, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T270, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.89");
        ValidationXML.equalIC(errors, VPSErrorEnum.T271, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > id", "root", "2.16.840.1.113883.2.9.4.3.9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T272, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T273, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T274, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T275, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.74");
        ValidationXML.equalIC(errors, VPSErrorEnum.T276, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "code", "75311-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T277, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T278, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T279, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "displayName", "Terapia farmacologica alla dimissione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T280, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T281, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T282, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration", "moodCode", "INT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T283, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
        ValidationXML.equalIC(errors, VPSErrorEnum.T284, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > statusCode", "code", "active");
        ValidationXML.equalIC(errors, VPSErrorEnum.T285, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > effectiveTime", "xsi:type", "IVL_TS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T286, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
        ValidationXML.equalIC(errors, VPSErrorEnum.T287, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T288, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code > translation", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.51");
        ValidationXML.equalIC(errors, VPSErrorEnum.T289, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T290, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > participant > participantRole > id", "root", "2.16.840.1.113883.2.9.4.3.2");

        return errors;
    }

    public static List<ErrorUCTDTO> validateUC31(String xml) {
        List<ErrorUCTDTO> errors = new ArrayList<>();

        ValidationXML.equalIC(errors, VPSErrorEnum.T333, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T334, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T335, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.20");
        ValidationXML.equalIC(errors, VPSErrorEnum.T336, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "code", "11459-5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T337, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T338, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T339, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > code", "displayName", "Modalità di Trasporto");
        ValidationXML.equalIC(errors, VPSErrorEnum.T340, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act", "classCode", "TRNS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T341, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T342, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.40");
        ValidationXML.equalIC(errors, VPSErrorEnum.T343, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T344, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > code", "codeSystemName", "ModalitàTrasporto_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T345, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T346, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant", "typeCode", "REFB");
        ValidationXML.equalIC(errors, VPSErrorEnum.T347, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T348, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Modalita_di_Trasporto] > entry > act > participant > participantRole > code", "codeSystemName", "ResponsabileInvio_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T349, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T350, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T351, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.42");
        ValidationXML.equalIC(errors, VPSErrorEnum.T352, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "code", "46239-0");
        ValidationXML.equalIC(errors, VPSErrorEnum.T353, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T354, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T355, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > code", "displayName", "Motivo della Visita");
        ValidationXML.equalIC(errors, VPSErrorEnum.T356, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", "typeCode", "COMP");
        ValidationXML.equalIC(errors, VPSErrorEnum.T357, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry > observation", "moodCode", "EVN");
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T358, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", " > observation", "2.16.840.1.113883.2.9.10.1.6.37", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "56817-0"), buildPathValue("code", "displayName", "Problema all'accesso"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.2"));
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T359, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry", " > observation", "2.16.840.1.113883.2.9.10.1.6.87", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "29298-7"), buildPathValue("code", "displayName", "Ragione della visita"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"));
        ValidationXML.equalIC(errors, VPSErrorEnum.T360, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T361, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T362, xml, "ClinicalDocument > component > structuredBody > component > section[ID=MOTIVO_DELLA_VISITA] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T363, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T364, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T365, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.21");
        ValidationXML.equalIC(errors, VPSErrorEnum.T366, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "code", "54094-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T367, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T368, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T369, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > code", "displayName", "Triage note");
        ValidationXML.equalIC(errors, VPSErrorEnum.T370, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T371, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.39");
        ValidationXML.equalIC(errors, VPSErrorEnum.T372, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "code", "11283-9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T373, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T374, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T375, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > code", "displayName", "Valutazione Acutezza");
        ValidationXML.equalIC(errors, VPSErrorEnum.T376, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T377, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T378, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > value", "codeSystemName", "CodiceTriage_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T379, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > performer", "typeCode", "PRF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T380, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Triage] > entry > observation > performer > assignedEntity > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T381, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T382, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T383, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.56");
        ValidationXML.equalIC(errors, VPSErrorEnum.T384, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "code", "78337-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T385, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T386, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T387, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > code", "displayName", "Inquadramento clinico iniziale");
        ValidationXML.equalIC(errors, VPSErrorEnum.T388, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T389, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T390, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.55");
        ValidationXML.equalIC(errors, VPSErrorEnum.T391, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "code", "11329-0");
        ValidationXML.equalIC(errors, VPSErrorEnum.T392, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T393, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T394, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > code", "displayName", "Anamnesi Generale");
        ValidationXML.equalIC(errors, VPSErrorEnum.T395, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T396, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "code", "75326-9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T397, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T398, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T399, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > code", "displayName", "Problem");
        ValidationXML.equalIC(errors, VPSErrorEnum.T400, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T401, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T402, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, VPSErrorEnum.T403, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T404, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "code", "10157-6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T405, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T406, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T407, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
        ValidationXML.equalIC(errors, VPSErrorEnum.T408, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T409, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject", "classcode", "PRS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T410, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T411, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "AdministrativeGender");
        ValidationXML.equalIC(errors, VPSErrorEnum.T412, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T413, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T415, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T416, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
        ValidationXML.equalIC(errors, VPSErrorEnum.T417, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > value", "codeSystemName", "ICD9-CM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T418, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T419, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T420, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T421, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T422, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T423, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.58");
        ValidationXML.equalIC(errors, VPSErrorEnum.T424, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "code", "29545-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T425, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T426, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T427, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > code", "displayName", "Esame Obiettivo");
        ValidationXML.equalIC(errors, VPSErrorEnum.T428, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Esame_Obiettivo] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T429, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T430, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T431, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.57");
        ValidationXML.equalIC(errors, VPSErrorEnum.T432, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "code", "42346-7");
        ValidationXML.equalIC(errors, VPSErrorEnum.T433, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T434, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T435, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > code", "displayName", "Medications on admission (narrative)");
        ValidationXML.equalIC(errors, VPSErrorEnum.T436, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Terapia_Farmacologica_Ingresso] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T437, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T438, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T439, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.33");
        ValidationXML.equalIC(errors, VPSErrorEnum.T199, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > code", "code", "48765-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T440, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T441, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T442, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > code", "displayName", "Allergie e/o Reazioni Avverse");
        ValidationXML.equalIC(errors, VPSErrorEnum.T443, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T444, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T445, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > code", "nullFlavor", "NA");
        ValidationXML.equalIC(errors, VPSErrorEnum.T446, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T447, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "code", "52473-6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T448, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T449, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T450, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > code", "displayName", "Allergia o causa della reazione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T451, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T452, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Allergie] > entry > act > entryRelationship > observation > value", "codeSystemName", "ObservationIntoleranceType");
        ValidationXML.equalIC(errors, VPSErrorEnum.T456, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T457, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T458, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.59");
        ValidationXML.equalIC(errors, VPSErrorEnum.T459, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > code", "code", "11450-4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T460, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T461, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T462, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > code", "displayName", "Problem List Reported");
        ValidationXML.equalIC(errors, VPSErrorEnum.T463, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T464, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Problemi_Aperti] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T465, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T466, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T467, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.50");
        ValidationXML.equalIC(errors, VPSErrorEnum.T468, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "code", "46240-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T469, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T470, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T471, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > code", "displayName", "History of Hospitalizations + Outpatient Visits Narrative");
        ValidationXML.equalIC(errors, VPSErrorEnum.T472, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter", "classcode", "ENC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T473, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T474, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.51");
        ValidationXML.equalIC(errors, VPSErrorEnum.T479, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship", "typeCode", "SUBJ");
        ValidationXML.equalIC(errors, VPSErrorEnum.T480, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T481, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T482, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.47");
        ValidationXML.equalIC(errors, VPSErrorEnum.T483, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "code", "48767-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T484, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T485, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T486, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Encounters] > entry > encounter > entryRelationship > act > code", "displayName", "Annotation Comment");
        ValidationXML.equalIC(errors, VPSErrorEnum.T487, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T488, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T489, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.23");
        ValidationXML.equalIC(errors, VPSErrorEnum.T490, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "code", "8648-8");
        ValidationXML.equalIC(errors, VPSErrorEnum.T491, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T492, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T493, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Decorso_Ospedaliero] > code", "displayName", "Decorso Ospedaliero");
        ValidationXML.equalIC(errors, VPSErrorEnum.T494, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T495, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T496, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > code", "code", "55109-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T497, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T498, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T499, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > code", "displayName", "Complicazioni");
        ValidationXML.equalIC(errors, VPSErrorEnum.T500, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > entry > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T501, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > entry > observation > code", "code", "75326-9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T502, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T503, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > entry > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T504, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Complicanze] > entry > observation > code", "displayName", "Problem");
        ValidationXML.equalIC(errors, VPSErrorEnum.T505, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T506, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T507, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.26");
        ValidationXML.equalIC(errors, VPSErrorEnum.T508, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "code", "62387-6");
        ValidationXML.equalIC(errors, VPSErrorEnum.T509, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T510, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T511, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > code", "displayName", "Procedure ed Interventi");
        ValidationXML.equalIC(errors, VPSErrorEnum.T512, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T513, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act", "moodCode", "EVN", "RQO");
        ValidationXML.equalIC(errors, VPSErrorEnum.T514, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
        ValidationXML.equalIC(errors, VPSErrorEnum.T515, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > statusCode", "code", "Completed", "Aborted");
        ValidationXML.equalIC(errors, VPSErrorEnum.T516, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INTERVENTI_PRESTAZIONI_CONSULENZE_E_RICHIESTE] > entry > act > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T517, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T518, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T519, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.27");
        ValidationXML.equalIC(errors, VPSErrorEnum.T520, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "code", "30954-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T521, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T522, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T523, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > code", "displayName", "Relevant diagnostic tests/laboratory data");
        ValidationXML.equalTAG(errors, VPSErrorEnum.T524, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > title", "Accertamenti");
        ValidationXML.equalIC(errors, VPSErrorEnum.T525, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer", "classCode", "BATTERY");
        ValidationXML.equalIC(errors, VPSErrorEnum.T526, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T527, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.45");
        ValidationXML.equalIC(errors, VPSErrorEnum.T528, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T529, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T530, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T531, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.46");
        ValidationXML.equalIC(errors, VPSErrorEnum.T532, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Accertamenti] > entry > organizer > component > observation > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T533, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T534, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T535, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.28");
        ValidationXML.equalIC(errors, VPSErrorEnum.T536, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "code", "8716-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T537, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T538, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T539, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > code", "displayName", "Parametri vitali");
        ValidationXML.equalIC(errors, VPSErrorEnum.T540, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "classCode", "CLUSTER");
        ValidationXML.equalIC(errors, VPSErrorEnum.T541, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T542, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.90");
        ValidationXML.equalIC(errors, VPSErrorEnum.T543, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "code", "85353-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T544, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T545, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T546, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > code", "displayName", "Vital signs, weight, height, head circumference, oxygen saturation and BMI");
        ValidationXML.equalIC(errors, VPSErrorEnum.T547, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T548, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T549, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.91");
        ValidationXML.equalIC(errors, VPSErrorEnum.T560, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T561, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T562, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > statusCode", "code", "completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T563, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Parametri_Vitali] > entry > organizer > component > observation > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T564, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T565, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T566, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.29");
        ValidationXML.equalIC(errors, VPSErrorEnum.T567, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "code", "29549-3");
        ValidationXML.equalIC(errors, VPSErrorEnum.T568, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T569, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T570, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > code", "displayName", "Medication administered Narrative");
        ValidationXML.equalIC(errors, VPSErrorEnum.T571, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T572, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T573, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
        ValidationXML.equalIC(errors, VPSErrorEnum.T574, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T575, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
        ValidationXML.equalIC(errors, VPSErrorEnum.T576, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.6.73");
        ValidationXML.equalIC(errors, VPSErrorEnum.T577, xml, "ClinicalDocument > component > structuredBody > component > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T581, xml, "ClinicalDocument > component > structuredBody > component  > section[ID=TERAPIA_FARMACOLOGICA_IN_PRONTO_SOCCORSO] > entry > substanceAdministration > entryRelationship > supply", "moodCode", "RQO");
        ValidationXML.equalIC(errors, VPSErrorEnum.T582, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T583, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T584, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.24");
        ValidationXML.equalIC(errors, VPSErrorEnum.T585, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "code", "28574-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T586, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T587, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T588, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > code", "displayName", "Note di Dimissione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T589, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T590, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T591, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66");
        ValidationXML.equalIC(errors, VPSErrorEnum.T592, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > code", "code", "dimissione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T593, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.5.1.4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T594, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > statusCode", "code", "Completed");
        ValidationXML.equalIC(errors, VPSErrorEnum.T605, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act", "classCode", "TRNS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T606, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.92");
        ValidationXML.equalIC(errors, VPSErrorEnum.T607, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > participant", "typeCode", "LOC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T608, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > participant > participantRole", "classCode", "SDLOC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T609, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
        ValidationXML.equalIC(errors, VPSErrorEnum.T610, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.11");
        ValidationXML.equalIC(errors, VPSErrorEnum.T611, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystemName", "TipoLuogoPostDimissione_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T612, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship", "typeCode", "RSON");
        ValidationXML.equalIC(errors, VPSErrorEnum.T613, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T614, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.68");
        ValidationXML.equalIC(errors, VPSErrorEnum.T615, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.13");
        ValidationXML.equalIC(errors, VPSErrorEnum.T616, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystemName", "ProblemType_VPS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T617, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship > act > entryRelationship > observation > statusCode", "code", "completed");
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T618, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship", " > observation", "2.16.840.1.113883.2.9.10.1.6.70", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "29308-4"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Diagnosi"), buildPathValue("statusCode", "code", "completed"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.6.103"), buildPathValue("value", "codeSystemName", "ICD9-CM"));
        ValidationXML.containsSection(errors, VPSErrorEnum.T619, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry", " > observation",
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.66", buildPathValue("code", "code","75328-5"), buildPathValue("code", "displayName", "Prognosi"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.72", buildPathValue("code", "code","11283-9"), buildPathValue("code", "displayName", "Valutazione Acutezza"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.86", buildPathValue("code", "code","31211-6"), buildPathValue("code", "displayName", "Date of death"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN")),
                new SectionCriteriaDTO("2.16.840.1.113883.2.9.10.1.6.73", buildPathValue("code", "code","45477-7"), buildPathValue("code", "displayName", "Advance directive-autopsy request"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("statusCode", "code", "completed"), buildPathValue("observation", "moodCode", "EVN")));
        ValidationXML.checkSectionByTemplateId(errors, VPSErrorEnum.T620, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Dimissione] > entry > act > entryRelationship", " > observation", "2.16.840.1.113883.2.9.10.1.6.69", false, buildPathValue("observation", "moodCode", "EVN"), buildPathValue("code", "code", "11302-7"), buildPathValue("code", "codeSystem", "2.16.840.1.113883.6.1"), buildPathValue("code", "codeSystemName", "LOINC"), buildPathValue("code", "displayName", "Esito"), buildPathValue("value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.5"), buildPathValue("value", "codeSystemName", "EsitoTrattamento_VPS"));
        ValidationXML.equalIC(errors, VPSErrorEnum.T644, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T645, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T646, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.34");
        ValidationXML.equalIC(errors, VPSErrorEnum.T647, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "code", "18776-5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T648, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T649, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T650, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > code", "displayName", "Piano di Cura");
        ValidationXML.equalIC(errors, VPSErrorEnum.T651, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T652, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T653, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T654, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act", "moodCode", "INT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T655, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
        ValidationXML.equalIC(errors, VPSErrorEnum.T656, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > statusCode", "code", "active");
        ValidationXML.equalIC(errors, VPSErrorEnum.T657, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference", "typeCode", "REFR");
        ValidationXML.equalIC(errors, VPSErrorEnum.T658, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T659, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T660, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.89");
        ValidationXML.equalIC(errors, VPSErrorEnum.T661, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > id", "root", "2.16.840.1.113883.2.9.4.3.9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T662, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Piano_Cura_Dimissione] > entry > act > reference > externalAct > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T663, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione]", "classCode", "DOCSECT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T664, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione]", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T665, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.74");
        ValidationXML.equalIC(errors, VPSErrorEnum.T666, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "code", "75311-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T667, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T668, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "codeSystemName", "LOINC");
        ValidationXML.equalIC(errors, VPSErrorEnum.T669, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > code", "displayName", "Terapia farmacologica alla dimissione");
        ValidationXML.equalIC(errors, VPSErrorEnum.T670, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T671, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T672, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration", "classCode", "SBADM");
        ValidationXML.equalIC(errors, VPSErrorEnum.T673, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration", "moodCode", "INT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T674, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
        ValidationXML.equalIC(errors, VPSErrorEnum.T675, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > effectiveTime", "xsi:type", "IVL_TS");
        ValidationXML.equalIC(errors, VPSErrorEnum.T676, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
        ValidationXML.equalIC(errors, VPSErrorEnum.T677, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5");
        ValidationXML.equalIC(errors, VPSErrorEnum.T678, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code > translation", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.51");
        ValidationXML.equalIC(errors, VPSErrorEnum.T679, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > participant", "typeCode", "REF");
        ValidationXML.equalIC(errors, VPSErrorEnum.T680, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > participant > participantRole > id", "root", "2.16.840.1.113883.2.9.4.3.2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T681, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > reference > externalAct", "classCode", "ACT");
        ValidationXML.equalIC(errors, VPSErrorEnum.T682, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > reference > externalAct", "moodCode", "EVN");
        ValidationXML.equalIC(errors, VPSErrorEnum.T683, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > reference > externalAct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.89");
        ValidationXML.equalIC(errors, VPSErrorEnum.T684, xml, "ClinicalDocument > component > structuredBody > component > section[ID=Terapia_Farmacologica_Dimissione] > entry > substanceAdministration > reference > externalAct > id", "root", "2.16.840.1.113883.2.9.4.3.9");
        ValidationXML.equalIC(errors, VPSErrorEnum.T685, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
        ValidationXML.containsIC(errors, VPSErrorEnum.T686, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T687, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T688, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.containsIC(errors, VPSErrorEnum.T689, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "displayName", "Età diagnosi patologia", "Età_decesso");
        ValidationXML.equalIC(errors, VPSErrorEnum.T688, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
        ValidationXML.containsIC(errors, VPSErrorEnum.T689, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > code", "code", "89261-2", "33999-4");
        ValidationXML.equalIC(errors, VPSErrorEnum.T690, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.containsIC(errors, VPSErrorEnum.T691, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > code", "displayName", "Decorso Clinico", "Stato");
        ValidationXML.containsIC(errors, VPSErrorEnum.T692, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > value", "code", "LA16666-2", "LA18632-2");
        ValidationXML.equalIC(errors, VPSErrorEnum.T693, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.6.1");
        ValidationXML.equalIC(errors, VPSErrorEnum.T694, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > value", "codeSystemName", "LOINC");
        ValidationXML.containsIC(errors, VPSErrorEnum.T695, xml, "ClinicalDocument > component > structuredBody > component > section[ID=INQUADRAMENTO_CLINICO_INIZIALE] > component > section[ID=Anamnesi] > entry > observation > entryRelationship > observation > value", "displayName", "Active", "Inactive");

        return errors;
    }

    public static List<ErrorUCTDTO> validateUC1(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		modalitaTrasporto(xml, errors);
		motivoVisita(xml, errors);
		triage(xml, errors);
		dimissioneV1(xml, errors);
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC2(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		modalitaTrasporto(xml, errors);
		motivoVisita(xml, errors);
		triage(xml, errors);
		encounters(xml, errors);
		decorso(xml, errors);
		accertamenti(xml, errors);
		dimissioneV2(xml, errors);
		pianoCura(xml, errors);
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC3(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		modalitaTrasporto(xml, errors);
		motivoVisita(xml, errors);
		triage(xml, errors);
		inquadramento(xml, errors);
		encounters(xml, errors);
		decorso(xml, errors);
		complicanze(xml, errors);
		richieste(xml, errors);
		dimissione(xml, errors);
		pianoCura(xml, errors);
		terapiaDimissione(xml, errors);
		return errors;
	}

	public static List<ErrorUCTDTO> validateUC4(String xml) {
		List<ErrorUCTDTO> errors = new ArrayList<>();
		
		modalitaTrasporto(xml, errors);
		motivoVisita(xml, errors);
		triage(xml, errors);
		inquadramento(xml, errors);
		encounters(xml, errors);
		decorso(xml, errors);
		complicanze(xml, errors);
		richieste(xml, errors);
		accertamenti(xml, errors);
		parametri(xml, errors);
		terapia(xml, errors);
		dimissione(xml, errors);
		pianoCura(xml, errors);
		terapiaDimissione(xml, errors);
		return errors;
	}
	
	
	private static void terapia(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.29");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > code", "code", "29549-3");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > code", "displayName", "Medication administered Narrative");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_CONS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_ENTRY_CONS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5", "2.16.840.1.113883.6.73");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIE_PART_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_in_Pronto_Soccorso'] > entry > substanceAdministration > participant", "typeCode", "REF");
	}

	private static void parametri(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.28");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > code", "code", "8716-3");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > code", "displayName", "Parametri vitali");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.90");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > code", "code", "85353-1");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > code", "displayName", "Vital signs, weight, height, head circumference, oxygen saturation and BMI");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.91");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.PARAMETRI_ENTRY_COMP_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Parametri_Vitali'] > entry > organizer > component > observation > participant", "typeCode", "REF");
	}


	private static void complicanze(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > code", "code", "55109-3");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > code", "displayName", "Complicazioni");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.COMPLICANZE_OBS_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation > code", "displayName", "Problem");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.COMPLICANZE_OBS_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation > effectiveTime > low", "value");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.COMPLICANZE_OBS_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Complicanze'] > entry > observation > effectiveTime > high", "value");
	}

	private static void richieste(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.26");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > code", "code", "62387-6");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > code", "displayName", "Procedure ed Interventi");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ENTRY_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ENTRY_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > entry > act", "moodCode", "EVN", "RQO");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ENTRY_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ENTRY_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > entry > act > statusCode", "code", "Completed", "Aborted");
		ValidationXML.equalIC(errors, VPSErrorEnum.RICHIESTE_ENTRY_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Interventi_Prestazioni_Consulenze_Richieste'] > entry > act > participant", "typeCode", "REF");
	}


	private static void terapiaDimissione(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.74");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > code", "code", "75311-1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > code", "displayName", "Terapia farmacologica alla dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_AUT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_AUT_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_SUB_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration", "classCode", "SBADM");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_SUB_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration", "moodCode", "INT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_SUB_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.52");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_CONS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > consumable > manufacturedProduct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.53");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_CONS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.5");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_CONS_TRANS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > consumable > manufacturedProduct > manufacturedMaterial > code > translation", "codeSystem", "2.16.840.1.113883.6.73", "2.16.840.1.113883.2.9.6.1.51");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_PART_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > participant", "typeCode", "REF");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_PART_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > participant > participantRole > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_PART_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > participant > participantRole > id", "assigningAuthorityName", "MEF");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_REF_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > reference > externalAct", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_REF_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > reference > externalAct", "moodCode", "EVN" );
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_REF_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > reference > externalAct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.89");
		ValidationXML.equalIC(errors, VPSErrorEnum.TERAPIA_ADM_REF_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Terapia_Farmacologica_Dimissione'] > entry > substanceAdministration > reference > externalAct > id", "root", "2.16.840.1.113883.2.9.4.3.9");
	}

	private static void dimissione(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.24");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "code", "28574-2");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "displayName", "Note di Dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "code", "dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.5.1.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter", "classCode", "ENC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > templateId","root", "2.16.840.1.113883.2.9.10.1.6.67");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.67");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "code", "IMP");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.9");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystemName", "TipoEncounterPostDimissione_VPS");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_PART_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > participant", "typeCode", "LOC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_REL_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > entryRelationship", "typeCode", "RSON");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act", "classCode", "TRNS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act", "moodCode", "EVN");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.92");
//		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > effectiveTime", "value");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_PART_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant", "typeCode", "LOC");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_PART_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole", "classCode", "SDLOC");
//		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_PART_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_PART_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.11");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_PART_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystemName", "TipoLuogoPostDimissione_VPS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship", "typeCode", "RSON");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation", "classCode", "OBS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation", "moodCode", "EVN");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.68");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.13");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystemName", "ProblemType_VPS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.69");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "code", "29308-4", "11302-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "displayName", "Diagnosi", "Esito");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystemName", "ICD9-CM","EsitoTrattamento_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.5");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystemName","ICD9-CM","EsitoTrattamento_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66", "2.16.840.1.113883.2.9.10.1.6.72", "2.16.840.1.113883.2.9.10.1.6.86", "2.16.840.1.113883.2.9.10.1.6.73");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "code", "75328-5", "11283-9", "31211-6", "45477-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "displayName", "Prognosi", "Valutazione Acutezza", "Date of death", "Advance directive-autopsy request.");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > statusCode", "code", "Completed");
	}

	private static void inquadramento(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.56");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > code", "code", "78337-3");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > code", "displayName", "Inquadramento clinico iniziale");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.55");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > code", "code", "11329-0");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > code", "displayName", "Anamnesi Generale");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_MOODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > code", "code", "75326-9");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > code", "displayName", "Problem");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_ER_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation > code", "code", "89261-2", "33999-4");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_ER_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_OBS_ER_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > observation > entryRelationship > observation > code", "displayName", "Decorso Clinico", "Stato");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer", "classCode", "CLUSTER");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > code", "code", "10157-6");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > code", "codeSystemName", "LOINC" );
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > code", "displayName", "Storia di malattie di membri familiari");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_SUB_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject", "classcode", "PRS");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_SUB_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystem", "2.16.840.1.113883.5.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_SUB_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > subject > relatedSubject > subject > administrativeGenderCode", "codeSystemName", "HL7 AdministrativeGender");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_VALUE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > value", "codeSystem", "2.16.840.1.113883.6.103");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_COMP_ORG_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > value", "codeSystemName", "ICD9-CM");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_COMP_ORG_OBS_ER_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_COMP_ORG_OBS_ER_MOODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_ER_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation > code", "code", "35267-4", "39016-1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_ER_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_ER_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ANAMNESI_COMP_ORG_OBS_ER_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Anamnesi'] > entry > organizer > component > observation > entryRelationship > observation > code", "displayName", "Età diagnosi patologia", "Età_decesso");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_MOOD, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.58");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > code", "code", "29545-1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > code", "displayName", "Esame Obiettivo");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_AUT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ESAME_COMP_AUT_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Esame_Obiettivo'] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.57");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > code", "code", "42346-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > code", "displayName", "Medications on admission (narrative)");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_AUT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_TERAPIA_COMP_AUT_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Terapia_Farmacologica_Ingresso'] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.33");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > code", "code", "48765-2");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > code", "displayName", "Allergie e/o Reazioni Avverse");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_MOODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > code", "nullFlavor","NA");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > effectiveTime > low", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_MOODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code", "code", "52473-6");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > code", "displayName", "Allergia o causa della reazione");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_ER_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_VALUE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > value", "codeSystemName", "ObservationIntoleranceType");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship", "typeCode", "MFST", "SUBJ", "REFR");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_ER_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "code", "75321-0", "5321-0", "SEV", "33999-4");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_ER_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1", "2.16.840.1.113883.5.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_ALLERGIE_COMP_ACT_OBS_ER_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Allergie'] > entry > act > entryRelationship > observation > entryRelationship > observation > code", "displayName", "Obiettività Clinica", "Clinical Finding", "Criticality", "Stato");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_MOOD, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.59");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > code", "code", "11450-4");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > code", "displayName", "Problem List Reported");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_AUT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.INQUADRAMENTO_PROB_COMP_AUT_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Inquadramento_Clinico_Iniziale'] > component > section[ID='Problemi_Aperti'] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
	}

	private static void encounters(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.50");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > code", "code", "46240-8");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > code", "displayName", "History of Hospitalizations + Outpatient Visits Narrative");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter", "classcode", "ENC");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.51");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > code", "codeSystemName", "TipoEncounter_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant", "typeCode", "ADM", "ATND", "DIS");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_PART_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant > participantRole", "classCode", "ROL", "SDLOC");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_PART_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant", "typeCode", "LOC","ADM","ATND","DIS");
		ValidationXML.containsIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_PART_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_PART_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.10");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_PART_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > participant > participantRole > code", "displayName", "Cardiologia(a)");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship", "typeCode", "SUBJ");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.47");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act > code", "code", "48767-8");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.ENCOUNTERS_ENC_ER_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Encounters'] > entry > encounter > entryRelationship > act > code", "displayName", "Annotation Comment");
	}

	private static void decorso(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.23");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero'] > code", "code", "8648-8");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DECORSO_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Decorso_Ospedaliero'] > code", "displayName", "Decorso Ospedaliero");
	}

	private static void accertamenti(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > templateId", "root","2.16.840.1.113883.2.9.10.1.6.27");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > code", "code", "30954-2");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_DISPLAY, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > code", "displayName", "Relevant diagnostic tests/laboratory data");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer", "classCode", "BATTERY");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.45");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > participant", "typeCode", "REF");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > component > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_OBS_MOOD, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > component > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_OBS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > component > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.46");
		ValidationXML.equalIC(errors, VPSErrorEnum.ACCERTAMENTI_ORG_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Accertamenti'] > entry > organizer > component > observation > statusCode", "code", "Completed");
	}

	private static void dimissioneV2(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.24");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "code", "28574-2");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "displayName", "Note di Dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "code", "dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.5.1.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter", "classCode", "ENC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.67");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "code", "IMP");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.9");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystemName", "TipoEncounterPostDimissione_VPS");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_PART_TYPE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > participant", "typeCode", "LOC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ENC_TYPE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > entryRelationship", "typeCode", "RSON");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act", "classCode", "TRNS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.92");
//		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > effectiveTime", "value");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_TYPE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant", "typeCode", "LOC");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ROLE_CLASS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole", "classCode", "SDLOC");
//		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ROLE_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.64");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ROLE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.11");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ROLE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > participant > participantRole > code", "codeSystemName", "TipoLuogoPostDimissione_VPS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_TYPE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship", "typeCode", "RSON");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation", "classCode", "OBS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation", "moodCode", "EVN");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_TEMPLATE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.68");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.13");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > code", "codeSystemName", "ProblemType_VPS");
//		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_ACT_ER_OBS_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > act > entryRelationship > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.69", "2.16.840.1.113883.2.9.10.1.6.70");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "code", "29308-4", "11302-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "displayName", "Diagnosi", "Esito");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.6.103", "2.16.840.1.113883.2.9.6.1.54.5");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystemName", "ICD9-CM", "EsitoTrattamento_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66", "2.16.840.1.113883.2.9.10.1.6.72", "2.16.840.1.113883.2.9.10.1.6.86", "2.16.840.1.113883.2.9.10.1.6.73");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "code", "75328-5", "11283-9", "31211-6", "45477-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "displayName", "Prognosi", "Valutazione Acutezza", "Date of death", "Advance directive-autopsy request");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > statusCode", "code", "Completed");
	}

	private static void pianoCura(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.34");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > code", "code", "18776-5");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_CODE_SYTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > code", "displayName", "Piano di Cura");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_AUT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > author > assignedAuthor > id", "root", "2.16.840.1.113883.2.9.4.3.2");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_AUT_ASS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > author > assignedAuthor > id", "assigningAuthorityName", "MEF");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act", "moodCode", "INT");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.62");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > statusCode", "code", "active");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_TYPE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference", "typeCode", "REFR");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_EXT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference > externalAct", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_EXT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference > externalAct", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_EXT_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference > externalAct > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.89");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_EXT_ID_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference > externalAct > id", "root", "2.16.840.1.113883.2.9.4.3.9");
		ValidationXML.equalIC(errors, VPSErrorEnum.PIANO_ACT_EXT_ASS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Piano_Cura_Dimissione'] > entry > act > reference > externalAct > id", "assigningAuthorityName", "MEF");
	}

	private static void modalitaTrasporto(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.20");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > code", "code", "11459-5");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > code", "displayName", "Modalità di Trasporto");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act", "classCode", "TRNS");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.40");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.6");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > code", "codeSystemName", "ModalitàTrasporto_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_PARTECIPANT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > participant", "typeCode", "REFB");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_PARTECIPANT_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > participant > participantRole > code", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRASPORTO_ACT_PARTECIPANT_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Modalità_di_Trasporto'] > entry > act > participant > participantRole > code", "codeSystemName", "ResponsabileInvio_VPS");
	}
	
	private static void motivoVisita(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.42");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > code", "code", "46239-0");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > code", "displayName", "Motivo della Visita");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.37", "2.16.840.1.113883.2.9.10.1.6.87");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > code", "code", "56817-0", "29298-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > code", "displayName", "Problema all'accesso", "Ragione della visita");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_STATUS, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > statusCode", "code", "completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.2", "2.16.840.1.113883.2.9.1.11.1.2.12");
		ValidationXML.equalIC(errors, VPSErrorEnum.MOTIVO_OBS_VALUE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Motivo_Visita'] > entry > observation > value", "codeSystemName", "ProblemaPrincipale_VPS", "CausaAccesso_VPS");
	}

	private static void triage(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_CLASS_DOC, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.21");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > code", "code", "54094-8");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > code", "displayName", "Triage note");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.39");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > code", "code", "11283-9");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > code", "displayName", "Valutazione Acutezza");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > statusCode", "code", "completed");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.TRIAGE_OBS_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > value", "codeSystem", "2.16.840.1.113883.2.9.6.1.54.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_VALUE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > value", "codeSystemName", "CodiceTriage_VPS");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_PERFORMER_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > performer", "typeCode", "PRF");
		ValidationXML.equalIC(errors, VPSErrorEnum.TRIAGE_OBS_PERFORMER_ASSIGNED, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Triage'] > entry > observation > performer > assignedEntity > id", "root","2.16.840.1.113883.2.9.4.3.2");
	}

	private static void dimissioneV1(String xml, List<ErrorUCTDTO> errors) {
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "classCode", "DOCSECT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione']", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.24");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "code", "28574-2");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > code", "displayName", "Note di Dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "classCode", "ACT");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "code", "dimissione");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > code", "codeSystem", "2.16.840.1.113883.2.9.5.1.4");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > statusCode", "code", "Completed");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter", "classCode", "ENC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_ROOT, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] >> entry > act > entryRelationship > encounter > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.67");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "code", "IMP");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystem", "2.16.840.1.113883.2.9.1.11.1.2.9");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > code", "codeSystemName", "TipoEncounterPostDimissione_VPS");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_PART_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > participant", "typeCode", "LOC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ENC_REL_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > encounter > entryRelationship", "typeCode", "RSON");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.70", "2.16.840.1.113883.2.9.10.1.6.69");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "code", "29308-4");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "displayName", "Diagnosi");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > statusCode", "code", "Completed");
		ValidationXML.hasDateFormat(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_TIME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > effectiveTime", "value");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystem", "2.16.840.1.113883.6.103", "2.16.840.1.113883.2.9.6.1.54.5");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_VALUE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > value", "codeSystemName", "ICD9-CM", "EsitoTrattamento_VPS");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "code", "11302-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "codeSystemName", "LOINC");
		ValidationXML.containsIC(errors, VPSErrorEnum.DIMISSIONE_ACT_ER_OBS_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > act > entryRelationship > observation > code", "displayName", "Esito");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CLASS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "classCode", "OBS");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_MOOD_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation", "moodCode", "EVN");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_TEMPLATE_ID, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > templateId", "root", "2.16.840.1.113883.2.9.10.1.6.66", "2.16.840.1.113883.2.9.10.1.6.72", "2.16.840.1.113883.2.9.10.1.6.86", "2.16.840.1.113883.2.9.10.1.6.73");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "code", "75328-5", "11283-9", "31211-6", "45477-7");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_CODE_SYSTEM, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystem", "2.16.840.1.113883.6.1");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_SYSTEM_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "codeSystemName", "LOINC");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_CODE_DISPLAY_NAME, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > code", "displayName", "Prognosi", "Valutazione Acutezza", "Date of death", "Advance directive-autopsy request");
		ValidationXML.equalIC(errors, VPSErrorEnum.DIMISSIONE_OBS_STATUS_CODE, xml, "ClinicalDocument > component > structuredBody > component > section[ID='Dimissione'] > entry > observation > statusCode", "code", "Completed");
	}
}